/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

public class QuoteSequenceException
extends Exception {
    private static final long serialVersionUID = 0L;
    private int position;
    private String input;

    public QuoteSequenceException(String input, int position) {
        super("Mismatched double quotes detected");
        this.position = position;
        this.input = input;
    }

    public String getDescription() {
        return "Error: out of sequence double quote at position " + this.position + "\n" + this.input + "\n" + this.getSpaces(this.position) + "^";
    }

    public String getSpaces(int numberOfSpaces) {
        StringBuffer spaces = new StringBuffer();
        int c = 0;
        while (c < numberOfSpaces) {
            spaces.append(" ");
            ++c;
        }
        return spaces.toString();
    }
}

