/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.ScannerController;
import net.lukemurphey.nsia.console.ConsoleCommand;
import net.lukemurphey.nsia.eventlog.EventLogMessage;

public class ScannerCommand
extends ConsoleCommand {
    public ScannerCommand(Application application, String ... names) {
        super("start | stop", "Starts or stops the scanner", application, names);
    }

    @Override
    public ConsoleCommand.CommandResult run(String[] input) {
        if (input.length < 2) {
            System.out.println("Error: no action provided, indicate whether to start or stop the scanner (example \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        if (input.length > 2) {
            System.out.println("Error: too many arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        if (input[1].equalsIgnoreCase("start")) {
            this.commandStartScanner();
        } else if (input[1].equalsIgnoreCase("stop")) {
            this.commandStopScanner();
        } else {
            System.out.println("Error: action must be either \"start\" or \"stop\", syntax of the command is \"" + input[0] + " start | stop\")");
        }
        return ConsoleCommand.CommandResult.EXECUTED_CORRECTLY;
    }

    private boolean commandStartScanner() {
        ScannerController scannerController = this.application.getScannerController();
        if (scannerController == null && this.application.getScannerController().isCurrentlyScanning()) {
            System.out.println("Scanner is already running");
        } else if (scannerController != null) {
            System.out.print("Starting scanner...");
            this.application.logEvent(EventLogMessage.EventType.SCANNER_STARTED);
            scannerController.enableScanning();
            System.out.println("Done");
        }
        return true;
    }

    private boolean commandStopScanner() {
        ScannerController scannerController = this.application.getScannerController();
        if (scannerController == null) {
            System.out.println("Scanner controller unavailable");
        } else if (!this.application.getScannerController().isCurrentlyScanning()) {
            System.out.println("Scanner is already paused");
        } else {
            System.out.print("Stopping scanner...");
            this.application.logEvent(EventLogMessage.EventType.SCANNER_STOPPED);
            scannerController.disableScanning();
            int milliseconds = 0;
            while (scannerController.getScanningState() == ScannerController.ScannerState.PAUSING && milliseconds < 5000) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                milliseconds += 100;
            }
            if (scannerController.getScanningState() != ScannerController.ScannerState.PAUSED) {
                System.out.println("(backgrounding)");
            } else {
                System.out.println("Done");
            }
        }
        return true;
    }
}

