/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

import java.io.BufferedReader;
import java.io.Console;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.Channels;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.console.ConsoleCommand;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;

public class SetPasswordCommand
extends ConsoleCommand {
    public SetPasswordCommand(Application application, String ... names) {
        super("<username>", "Sets the password for the given username", application, names);
    }

    @Override
    public ConsoleCommand.CommandResult run(String[] input) {
        String password;
        int userId;
        if (input.length < 2) {
            System.out.println("Error: too few arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        if (input.length > 2) {
            System.out.println("Error: too many arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        UserManagement userManagement = new UserManagement(this.application);
        try {
            userId = userManagement.getUserID(input[1]);
        }
        catch (SQLException e) {
            this.application.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            System.out.println("Password could not be set, a SQL exception occurred");
            return ConsoleCommand.CommandResult.ERROR;
        }
        catch (NoDatabaseConnectionException e) {
            this.application.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            System.out.println("Password could not be set, no database connection exists");
            return ConsoleCommand.CommandResult.ERROR;
        }
        catch (InputValidationException e) {
            System.out.println("Username is illegal (contains disallowed characters)");
            this.application.logEvent(EventLogMessage.EventType.USER_NAME_ILLEGAL, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, input[1]));
            return ConsoleCommand.CommandResult.ERROR;
        }
        if (userId < 0) {
            System.out.println("No user exists with the name given");
            this.application.logEvent(EventLogMessage.EventType.USER_ID_INVALID, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, input[1]), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return ConsoleCommand.CommandResult.ERROR;
        }
        Console console = System.console();
        if (console != null) {
            System.out.print("Enter the user's password:");
            password = new String(System.console().readPassword());
            System.out.print("Please the confirm the password:");
            String passwordConfirm = new String(System.console().readPassword());
            if (!password.equals(passwordConfirm)) {
                System.err.println("Error: The passwords do not match, user's password was not updated");
                return ConsoleCommand.CommandResult.ERROR;
            }
        } else {
            InputStream inputStreamChannel = null;
            InputStreamReader inputStreamReader = null;
            BufferedReader in = null;
            try {
                inputStreamChannel = Channels.newInputStream(new FileInputStream(FileDescriptor.in).getChannel());
                inputStreamReader = new InputStreamReader(inputStreamChannel);
                in = new BufferedReader(inputStreamReader);
                System.out.print("Enter the user's password: ");
                password = in.readLine();
            }
            catch (IOException e) {
                System.err.println("Password was not successfully read");
                return ConsoleCommand.CommandResult.ERROR;
            }
        }
        try {
            if (userManagement.changePassword(userId, password)) {
                System.out.println("Password successfully changed");
            } else {
                System.out.println("Password was not successfully changed");
            }
        }
        catch (SQLException e) {
            System.out.println("Password could not be set, a SQL exception occurred");
            this.application.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            return ConsoleCommand.CommandResult.ERROR;
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Password could not be set, the hash algorithm is unknown");
            this.application.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            return ConsoleCommand.CommandResult.ERROR;
        }
        catch (NoDatabaseConnectionException e) {
            System.out.println("Password could not be set, no database connection exists");
            this.application.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            return ConsoleCommand.CommandResult.ERROR;
        }
        catch (InputValidationException e) {
            System.out.println("Password is illegal (contains disallowed characters)");
            this.application.logEvent(EventLogMessage.EventType.PASSWORD_ILLEGAL, new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return ConsoleCommand.CommandResult.ERROR;
        }
        return ConsoleCommand.CommandResult.EXECUTED_CORRECTLY;
    }
}

