/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

import java.sql.SQLException;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.console.ConsoleCommand;
import net.lukemurphey.nsia.eventlog.EventLogMessage;

public class ShowConfigCommand
extends ConsoleCommand {
    public ShowConfigCommand(Application application, String ... names) {
        super(null, "Displays the system configuration (listening port, number of CPUs, etc)", application, names);
    }

    @Override
    public ConsoleCommand.CommandResult run(String[] input) {
        if (input.length > 1) {
            System.out.println("Error: too many arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.ERROR;
        }
        Vector<String[]> table = new Vector<String[]>();
        table.add(new String[]{"System Configuration:", ""});
        table.add(new String[]{"JVM Vendor:", this.application.getJvmVendor()});
        table.add(new String[]{"JVM Version:", this.application.getJvmVersion()});
        table.add(new String[]{"Database Connection:", this.application.getDatabaseInfo()});
        table.add(new String[]{"Database Driver:", this.application.getDatabaseDriver()});
        try {
            table.add(new String[]{"Database Driver Name/Version:", String.valueOf(this.application.getDatabaseDriverName()) + ", " + this.application.getDatabaseDriverVersion()});
            table.add(new String[]{"Database Name/Version:", String.valueOf(this.application.getDatabaseName()) + ", " + this.application.getDatabaseVersion()});
        }
        catch (SQLException e) {
            this.application.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
        }
        catch (NoDatabaseConnectionException e) {
            // empty catch block
        }
        table.add(new String[]{"Operating System:", this.application.getOperatingSystemName()});
        table.add(new String[]{"Operating System Version:", this.application.getOperatingSystemVersion()});
        table.add(new String[]{"Platform Architecture:", this.application.getPlatformArch()});
        table.add(new String[]{"Processor Count:", String.valueOf(this.application.getProcessorCount())});
        table.add(new String[]{"Server Port:", String.valueOf(this.application.getNetworkManager().getServerPort())});
        table.add(new String[]{"SSL Enabled:", String.valueOf(this.application.getNetworkManager().sslEnabled())});
        String[][] tableData = new String[table.size()][];
        table.toArray((T[])tableData);
        System.out.println(ShowConfigCommand.getTableFromString(tableData, true));
        return ConsoleCommand.CommandResult.EXECUTED_CORRECTLY;
    }
}

