/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.console.ConsoleCommand;
import net.lukemurphey.nsia.eventlog.EventLog;

public class ShowEventsCommand
extends ConsoleCommand {
    public ShowEventsCommand(Application application, String ... names) {
        super("true | false", "Enables/disables printing of the log messages to the console interface as they arrive", application, names);
    }

    @Override
    public ConsoleCommand.CommandResult run(String[] input) {
        if (input.length > 2) {
            System.out.println("Error: too many arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        if (input.length > 1 && input[1].equalsIgnoreCase("false")) {
            this.commandHideLogMessages();
        } else if (input.length == 1 || input.length > 1 && input[1].equalsIgnoreCase("true")) {
            this.commandShowLogMessages();
        } else {
            System.out.println("Error: action must be either \"true\" or \"false\", syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        return ConsoleCommand.CommandResult.EXECUTED_CORRECTLY;
    }

    private void commandShowLogMessages() {
        EventLog eventlog = this.application.getEventLog();
        eventlog.repeatMessagesToConsole(true);
        System.out.println("Printing of event log messages to the console is enabled");
    }

    private void commandHideLogMessages() {
        EventLog eventlog = this.application.getEventLog();
        eventlog.repeatMessagesToConsole(false);
        System.out.println("Printing of event log messages to the console is disabled");
    }
}

