/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NumericalOverflowException;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.console.ConsoleCommand;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;

public class UnlockUserCommand
extends ConsoleCommand {
    public UnlockUserCommand(Application application, String ... names) {
        super("<username>", "Unlocks the user's account (if locked due to repeated authentication attempts)", application, names);
    }

    @Override
    public ConsoleCommand.CommandResult run(String[] input) {
        if (input.length > 2) {
            System.out.println("Error: too many arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.ERROR;
        }
        if (input.length < 2) {
            System.out.println("Error: too few arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.ERROR;
        }
        UserManagement userManagement = new UserManagement(this.application);
        try {
            userManagement.clearAuthFailedCount(input[1]);
            System.out.println("Account unlocked, authentication failed count cleared");
        }
        catch (SQLException e) {
            this.application.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            System.out.println("Account could not be unlocked, a SQL exception occurred");
            return ConsoleCommand.CommandResult.ERROR;
        }
        catch (NoDatabaseConnectionException e) {
            this.application.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            System.out.println("Account could not be unlocked, no database connection exists");
            return ConsoleCommand.CommandResult.ERROR;
        }
        catch (InputValidationException e) {
            System.out.println("Username is illegal (contains disallowed characters)");
            this.application.logEvent(EventLogMessage.EventType.USER_NAME_ILLEGAL, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, input[1]));
            return ConsoleCommand.CommandResult.ERROR;
        }
        catch (NumericalOverflowException e) {
            System.out.println("Account could not be unlocked, numerical overflow exception");
            this.application.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            return ConsoleCommand.CommandResult.ERROR;
        }
        return ConsoleCommand.CommandResult.EXECUTED_CORRECTLY;
    }
}

