/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NetworkManager;
import net.lukemurphey.nsia.console.ConsoleCommand;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;

public class WebServicesCommand
extends ConsoleCommand {
    public WebServicesCommand(Application application, String ... names) {
        super("start|stop", "Starts or stops the internal web server", application, names);
    }

    @Override
    public ConsoleCommand.CommandResult run(String[] input) {
        if (input.length < 2) {
            System.out.println("Error: no action provided, indicate whether to start or stop the internal web server (example \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        if (input.length > 2) {
            System.out.println("Error: too many arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        if (input[1].equalsIgnoreCase("start")) {
            this.commandStartWebServices();
        } else if (input[1].equalsIgnoreCase("stop")) {
            this.commandStopWebServices();
        }
        return ConsoleCommand.CommandResult.EXECUTED_CORRECTLY;
    }

    private boolean commandStartWebServices() {
        NetworkManager manager = this.application.getNetworkManager();
        if (manager == null) {
            System.out.println("Web services manager unavailable");
        } else if (manager.isListenerRunning()) {
            System.out.println("Web server is already running");
        } else {
            System.out.print("Starting web server...");
            try {
                manager.startListener();
            }
            catch (Exception e) {
                System.out.println("Server could not be started, exception occurred");
                this.application.logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Start web services"));
            }
            System.out.println("Done");
        }
        return true;
    }

    private boolean commandStopWebServices() {
        NetworkManager manager = this.application.getNetworkManager();
        if (manager == null) {
            System.out.println("Web services manager unavailable");
        } else if (!manager.isListenerRunning()) {
            System.out.println("Web server is not running");
        } else {
            System.out.print("Shutting down web server...");
            manager.stopListener();
        }
        System.out.println("Done");
        System.out.println("Warning: the internal web server has been shutdown. Users will not be able to connect and manage ThreatFactor NSIA remotely.");
        return true;
    }
}

