/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.eventlog;

import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.eventlog.CommonEventFormatMessage;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.eventlog.MessageFormatter;

public class CommonEventFormatMessageFormatter
extends MessageFormatter {
    @Override
    public String formatMessage(EventLogMessage message) {
        CommonEventFormatMessage cef = new CommonEventFormatMessage("ThreatFactor", "NSIA", Application.getVersion(), Integer.toString(message.getEventType().ordinal()), message.getEventType().getName(), message.getEventType().getSeverity().getSyslogEquivalent());
        EventLogField[] fields = message.getFields();
        int c = 0;
        while (c < fields.length) {
            if (fields[c].getName() == EventLogField.FieldName.SOURCE_USER_ID) {
                cef.addExtensionField(new CommonEventFormatMessage.ExtensionField(CommonEventFormatMessage.CommonExtensionDictionaryField.SOURCE_USER_ID, fields[c].getValue()));
            } else if (fields[c].getName() == EventLogField.FieldName.SOURCE_USER_NAME) {
                cef.addExtensionField(new CommonEventFormatMessage.ExtensionField(CommonEventFormatMessage.CommonExtensionDictionaryField.SOURCE_USER, fields[c].getValue()));
            } else if (fields[c].getName() == EventLogField.FieldName.TARGET_USER_NAME) {
                cef.addExtensionField(new CommonEventFormatMessage.ExtensionField(CommonEventFormatMessage.CommonExtensionDictionaryField.DESTINATION_USER_NAME, fields[c].getValue()));
            } else if (fields[c].getName() == EventLogField.FieldName.TARGET_USER_ID) {
                cef.addExtensionField(new CommonEventFormatMessage.ExtensionField(CommonEventFormatMessage.CommonExtensionDictionaryField.DESTINATION_USER_ID, fields[c].getValue()));
            } else if (fields[c].getName() == EventLogField.FieldName.FILE) {
                cef.addExtensionField(new CommonEventFormatMessage.ExtensionField(CommonEventFormatMessage.CommonExtensionDictionaryField.FILE_NAME, fields[c].getValue()));
            } else {
                cef.addExtensionField(new CommonEventFormatMessage.ExtensionField(fields[c].getName().getSimpleNameFormat(), fields[c].getValue()));
            }
            ++c;
        }
        return cef.getCEFMessage();
    }

    @Override
    public String getDescription() {
        return "Common Event Format";
    }
}

