/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.eventlog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogHook;
import net.lukemurphey.nsia.eventlog.EventLogHookException;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.eventlog.EventLogSeverity;
import net.lukemurphey.nsia.eventlog.MessageFormatter;
import net.lukemurphey.nsia.eventlog.SyslogNGAppender;
import net.lukemurphey.nsia.response.ActionFailedException;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.varia.NullAppender;

public class EventLog {
    protected EventLogSeverity loggingLevel = EventLogSeverity.INFORMATIONAL;
    private static final Logger logger = Logger.getLogger((String)EventLog.class.getName());
    private static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss";
    private Vector<EventLogHook> hooks = new Vector();
    private boolean repeatToConsole = false;
    private MessageFormatter formatter = null;
    private Application application = null;
    private SyslogNGAppender syslogAppender = null;
    private String logServeraddress = null;
    private int logServerport = -1;
    private boolean logServerEnabled = false;
    private SyslogNGAppender.Protocol logServerprotocol = null;

    public EventLog() {
        Logger apacheLogger = Logger.getLogger((String)"org.apache");
        apacheLogger.setLevel(EventLogSeverity.OFF);
        Logger httpClientLogger = Logger.getLogger((String)"httpclient");
        httpClientLogger.setLevel(EventLogSeverity.OFF);
        Logger jettyLogger = Logger.getLogger((String)"org.mortbay");
        jettyLogger.setLevel(EventLogSeverity.OFF);
        Logger freemarkerLogger = Logger.getLogger((String)"freemarker.cache");
        freemarkerLogger.setLevel(EventLogSeverity.OFF);
        Logger freemarkerRuntimeLogger = Logger.getLogger((String)"freemarker.runtime");
        freemarkerRuntimeLogger.setLevel(EventLogSeverity.OFF);
        Logger freemarkerBeansLogger = Logger.getLogger((String)"freemarker.beans");
        freemarkerBeansLogger.setLevel(EventLogSeverity.OFF);
        NullAppender appender = new NullAppender();
        logger.addAppender((Appender)appender);
        logger.setLevel(EventLogSeverity.ALL);
    }

    public void repeatMessagesToConsole(boolean repeat) {
        this.repeatToConsole = repeat;
    }

    public MessageFormatter getMessageFormatter() {
        return this.formatter;
    }

    public void setMessageFormatter(MessageFormatter formatter) {
        this.formatter = formatter;
    }

    public void clearLogServer() {
        this.logServeraddress = null;
        this.logServerport = -1;
        this.syslogAppender.close();
    }

    public void setLogServer(String address, int port, SyslogNGAppender.Protocol protocol, boolean enabled) {
        if (address == null) {
            throw new IllegalArgumentException("The syslog server address cannot be null");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("The port must not be less than 0 and must be less than 65535");
        }
        this.logServeraddress = address;
        this.logServerport = port;
        this.logServerprotocol = protocol;
        this.logServerEnabled = enabled;
        this.setupSyslog();
    }

    public void setLogServer(String address, int port) {
        if (address == null) {
            throw new IllegalArgumentException("The syslog server address cannot be null");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("The port must not be less than 0 and must be less than 65535");
        }
        this.logServeraddress = address;
        this.logServerport = port;
        this.setupSyslog();
    }

    public void setLogServer(String address) {
        if (address == null) {
            throw new IllegalArgumentException("The syslog server address cannot be null");
        }
        this.logServeraddress = address;
        this.setupSyslog();
    }

    public void setLogServerProtocol(SyslogNGAppender.Protocol protocol) {
        this.logServerprotocol = protocol;
    }

    public boolean isLogServerLoggingEnabled() {
        return this.logServerEnabled;
    }

    public void logServerLoggingEnabled(boolean enable) {
        if (this.logServerEnabled != enable) {
            this.logServerEnabled = enable;
            this.setupSyslog();
        }
    }

    public void setLogServerPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("The port must not be less than 0 and must be less than 65535");
        }
        this.logServerport = port;
        this.setupSyslog();
    }

    private void setupSyslog() {
        if (!this.logServerEnabled) {
            logger.removeAppender((Appender)this.syslogAppender);
            logger.addAppender((Appender)new NullAppender());
            return;
        }
        if (this.logServeraddress == null) {
            return;
        }
        if (this.logServerport < 0 || this.logServerport > 65535) {
            return;
        }
        if (this.logServerprotocol == null) {
            return;
        }
        PatternLayout patternLayout = new PatternLayout("%m");
        this.syslogAppender = new SyslogNGAppender(this.logServeraddress, this.logServerport, this.logServerprotocol);
        this.syslogAppender.setErrorHandler(new LoggerErrorHandler());
        this.syslogAppender.setLayout((Layout)patternLayout);
        logger.removeAllAppenders();
        logger.addAppender((Appender)this.syslogAppender);
    }

    public String getLogServerAddress() {
        return this.logServeraddress;
    }

    public int getLogServerPort() {
        return this.logServerport;
    }

    public boolean isExternalLoggingEnabled() {
        return this.logServerEnabled;
    }

    public boolean isLogServerResponding() {
        if (this.syslogAppender != null) {
            return this.syslogAppender.isLogServerResponding();
        }
        return true;
    }

    public int getLogCacheSize() {
        if (this.syslogAppender != null) {
            return this.syslogAppender.getCachedMessageCount();
        }
        return 0;
    }

    public int getMaxLogCacheSize() {
        if (this.syslogAppender != null) {
            return this.syslogAppender.getMaxCacheSize();
        }
        return 0;
    }

    public SyslogNGAppender.Protocol getLogServerProtocol() {
        return this.logServerprotocol;
    }

    public void setApplication(Application app) {
        this.application = app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteHook(long hookID) throws SQLException, NoDatabaseConnectionException {
        Vector<EventLogHook> vector = this.hooks;
        synchronized (vector) {
            this.deleteHookInternal(hookID);
        }
    }

    private void deleteHookInternal(long hookID) throws SQLException, NoDatabaseConnectionException {
        Iterator<EventLogHook> iterator = this.hooks.iterator();
        while (iterator.hasNext()) {
            EventLogHook hook = iterator.next();
            if ((long)hook.getEventLogHookID() != hookID) continue;
            iterator.remove();
            hook.delete();
        }
    }

    public void loadHooks() throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        SQLException initCause = null;
        try {
            try {
                connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.ACTION);
                statement = connection.prepareStatement("Select * from EventLogHook");
                result = statement.executeQuery();
                while (result.next()) {
                    EventLogHook hook = EventLogHook.loadFromDatabase(result);
                    if (hook == null) continue;
                    this.addHook(hook);
                }
            }
            catch (SQLException e) {
                initCause = e;
                try {
                    if (result != null) {
                        result.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException ex) {
                    if (ex.getCause() == null && initCause != null) {
                        ex.initCause(initCause);
                        throw ex;
                    }
                    if (initCause != null) {
                        throw initCause;
                    }
                    throw ex;
                }
            }
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException ex) {
                if (ex.getCause() == null && initCause != null) {
                    ex.initCause(initCause);
                    throw ex;
                }
                if (initCause != null) {
                    throw initCause;
                }
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventLogHook getHook(long eventlogHookID) {
        Vector<EventLogHook> vector = this.hooks;
        synchronized (vector) {
            for (EventLogHook hook : this.hooks) {
                if ((long)hook.getEventLogHookID() != eventlogHookID) continue;
                return hook;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventLogHook[] getHooks() {
        Vector<EventLogHook> vector = this.hooks;
        synchronized (vector) {
            EventLogHook[] hooksArray = new EventLogHook[this.hooks.size()];
            this.hooks.toArray(hooksArray);
            return hooksArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHook(EventLogHook hook) {
        if (hook == null) {
            throw new IllegalArgumentException("The event log hook cannot be null");
        }
        Vector<EventLogHook> vector = this.hooks;
        synchronized (vector) {
            this.hooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHook(EventLogHook hook) {
        Vector<EventLogHook> vector = this.hooks;
        synchronized (vector) {
            return this.hooks.remove(hook);
        }
    }

    public boolean getRepeatMessagesToConsole() {
        return this.repeatToConsole;
    }

    public void logEvent(EventLogMessage message) throws IllegalArgumentException {
        this.logEvent(message, true);
    }

    public void logEvent(EventLogMessage message, boolean sendToExternalLogger) throws IllegalArgumentException {
        if (message == null) {
            throw new IllegalArgumentException("The message cannot be null");
        }
        this.writeEventToDatabase(message.getDate(), message.getSeverity(), message.getMessageName(), message.getFieldsAsString(false));
        String messageString = this.formatter == null ? message.toString() : this.formatter.formatMessage(message);
        for (EventLogHook hook : this.hooks) {
            EventLogMessage msg;
            try {
                hook.processEvent(message);
            }
            catch (ActionFailedException e) {
                msg = new EventLogMessage(EventLogMessage.EventType.RESPONSE_ACTION_FAILED);
                msg.addField(new EventLogField(EventLogField.FieldName.RESPONSE_ACTION_ID, hook.getEventLogHookID()));
                msg.addField(new EventLogField(EventLogField.FieldName.RESPONSE_ACTION_NAME, hook.getAction().getDescription()));
                msg.addField(new EventLogField(EventLogField.FieldName.RESPONSE_ACTION_DESC, hook.getAction().getConfigDescription()));
                msg.addField(new EventLogField(EventLogField.FieldName.MESSAGE, e.getMessage()));
                if (e.getCause() != null) {
                    this.logExceptionEvent(msg, e);
                    continue;
                }
                this.logEvent(msg);
            }
            catch (EventLogHookException e) {
                msg = new EventLogMessage(EventLogMessage.EventType.RESPONSE_ACTION_FAILED);
                msg.addField(new EventLogField(EventLogField.FieldName.RESPONSE_ACTION_ID, hook.getEventLogHookID()));
                msg.addField(new EventLogField(EventLogField.FieldName.RESPONSE_ACTION_NAME, hook.getAction().getDescription()));
                msg.addField(new EventLogField(EventLogField.FieldName.RESPONSE_ACTION_DESC, hook.getAction().getConfigDescription()));
                this.logExceptionEvent(msg, e);
            }
        }
        if (sendToExternalLogger) {
            logger.log((Priority)message.getSeverity(), (Object)messageString);
        }
        if (this.repeatToConsole) {
            System.err.println(message.toString());
        }
    }

    private synchronized void writeEventToDatabase(Date datetime, EventLogSeverity severity, String title, String additionalData) {
        try {
            Application app = this.application;
            if (app == null) {
                app = Application.getApplication();
            }
            if (app == null) {
                return;
            }
            Statement statement = null;
            Connection connection = null;
            try {
                try {
                    connection = app.getDatabaseConnection(Application.DatabaseAccessType.EVENT_LOG);
                    statement = connection.prepareStatement("Insert into EventLog (LogDate, Severity, Title, Notes) values (?, ?, ?, ?)");
                    SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
                    statement.setString(1, sdf.format(datetime));
                    statement.setInt(2, severity.getSeverity());
                    statement.setString(3, title);
                    if (additionalData.length() > 16000) {
                        statement.setString(4, String.valueOf(additionalData.substring(0, 15990)) + "[...]");
                    } else {
                        statement.setString(4, additionalData);
                    }
                    statement.execute();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (connection != null) {
                        connection.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getStackTrace(Throwable t) {
        return EventLog.getStackTrace(t, 50);
    }

    private static String getStackTrace(Throwable t, int max_size) {
        StringBuffer buffer = new StringBuffer();
        int iterations = 0;
        StackTraceElement[] stack_trace = t.getStackTrace();
        iterations = stack_trace.length > max_size ? max_size : stack_trace.length;
        buffer.append(t);
        buffer.append("\n");
        int c = 0;
        while (c < iterations) {
            buffer.append(stack_trace[c]);
            if (c < iterations - 1) {
                buffer.append(" at ");
            }
            ++c;
        }
        if (iterations != stack_trace.length) {
            buffer.append("\n... (" + (stack_trace.length - iterations) + " more omitted)");
        }
        if (t.getCause() != null) {
            buffer.append("\n\nCaused by:");
            buffer.append(EventLog.getStackTrace(t.getCause(), max_size));
        }
        return buffer.toString();
    }

    public synchronized void logExceptionEvent(EventLogMessage message, Throwable throwable, boolean sendToExternalLogger) throws IllegalArgumentException {
        String stringRepresentation = EventLog.getStackTrace(throwable);
        message.addField(new EventLogField(EventLogField.FieldName.STACK_TRACE, stringRepresentation));
        this.logEvent(message, sendToExternalLogger);
    }

    public synchronized void logExceptionEvent(EventLogMessage message, Throwable throwable) throws IllegalArgumentException {
        String stringRepresentation = EventLog.getStackTrace(throwable);
        message.addField(new EventLogField(EventLogField.FieldName.STACK_TRACE, stringRepresentation));
        this.logEvent(message);
    }

    public EventLogSeverity getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(EventLogSeverity newLogLevel) {
        this.loggingLevel = newLogLevel;
    }

    public class LoggerErrorHandler
    implements ErrorHandler {
        public static final int LOG_CACHING = 10000;
        public static final int LOG_CACHE_FULL = 10001;
        public static final int LOG_CACHE_EMPTY = 10002;
        public static final int LOG_CACHE_EMPTYING = 10003;
        public static final int LOG_MESSAGE_SEND_FAILED = 10004;
        public static final int LOG_SERVER_CONNECTION_NOT_ESTABLISHED = 10005;
        public static final int LOG_SERVER_AVAILABLE = 10006;

        private LoggerErrorHandler() {
        }

        public void error(String message) {
            EventLog.this.logEvent(new EventLogMessage(EventLogMessage.EventType.LOG_FAILED, new EventLogField(EventLogField.FieldName.MESSAGE, message)), true);
        }

        private EventLogMessage.EventType getEventTypeFromCode(int errorCode) {
            if (errorCode == 10000) {
                return EventLogMessage.EventType.LOGS_BEING_CACHED;
            }
            if (errorCode == 10002) {
                return EventLogMessage.EventType.LOG_CACHE_EMPTY;
            }
            if (errorCode == 10001) {
                return EventLogMessage.EventType.LOG_CACHE_FULL;
            }
            if (errorCode == 10003) {
                return EventLogMessage.EventType.LOG_CACHE_EMPTYING;
            }
            if (errorCode == 10005) {
                return EventLogMessage.EventType.LOG_SERVER_UNAVAILABLE;
            }
            if (errorCode == 10006) {
                return EventLogMessage.EventType.LOG_SERVER_AVAILABLE;
            }
            return EventLogMessage.EventType.LOG_FAILED;
        }

        public void error(String message, Exception exception, int code) {
            EventLogMessage.EventType eventType = this.getEventTypeFromCode(code);
            if (exception == null) {
                EventLog.this.logEvent(new EventLogMessage(eventType, new EventLogField(EventLogField.FieldName.MESSAGE, message)), false);
            } else {
                EventLog.this.logExceptionEvent(new EventLogMessage(eventType, new EventLogField(EventLogField.FieldName.MESSAGE, message)), exception, false);
            }
        }

        public void error(String message, Exception exception, int code, LoggingEvent event) {
            this.error(message, exception, code);
        }

        public void setAppender(Appender appender) {
        }

        public void setBackupAppender(Appender appender) {
        }

        public void setLogger(Logger logger) {
        }

        public void activateOptions() {
        }
    }
}

