/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.eventlog;

import org.apache.log4j.Level;

public class EventLogSeverity
extends Level {
    private static final long serialVersionUID = -4967298534827859874L;
    public static final EventLogSeverity DEBUG = new EventLogSeverity(10000, "Debug", 7);
    public static final EventLogSeverity INFORMATIONAL = new EventLogSeverity(20000, "Informational", 6);
    public static final EventLogSeverity NOTICE = new EventLogSeverity(25000, "Notice", 5);
    public static final EventLogSeverity WARNING = new EventLogSeverity(30000, "Warning", 4);
    public static final EventLogSeverity ERROR = new EventLogSeverity(40000, "Error", 3);
    public static final EventLogSeverity CRITICAL = new EventLogSeverity(43333, "Critical", 2);
    public static final EventLogSeverity ALERT = new EventLogSeverity(46666, "Alert", 1);
    public static final EventLogSeverity EMERGENCY = new EventLogSeverity(50000, "Emergency", 0);

    private EventLogSeverity(int logInt, String desc, int syslogSeverity) {
        super(logInt, desc, syslogSeverity);
    }

    public int getSeverity() {
        return this.toInt();
    }

    public static EventLogSeverity getSeverityById(int severityId) {
        if (DEBUG.getSeverity() == severityId) {
            return DEBUG;
        }
        if (INFORMATIONAL.getSeverity() == severityId) {
            return INFORMATIONAL;
        }
        if (ALERT.getSeverity() == severityId) {
            return ALERT;
        }
        if (CRITICAL.getSeverity() == severityId) {
            return CRITICAL;
        }
        if (EMERGENCY.getSeverity() == severityId) {
            return EMERGENCY;
        }
        if (ERROR.getSeverity() == severityId) {
            return ERROR;
        }
        if (NOTICE.getSeverity() == severityId) {
            return NOTICE;
        }
        if (WARNING.getSeverity() == severityId) {
            return WARNING;
        }
        return NOTICE;
    }

    public static EventLogSeverity getSeverityBySyslogID(int severity) {
        if (severity == EMERGENCY.getSyslogEquivalent()) {
            return EMERGENCY;
        }
        if (severity == CRITICAL.getSyslogEquivalent()) {
            return CRITICAL;
        }
        if (severity == ALERT.getSyslogEquivalent()) {
            return ALERT;
        }
        if (severity == ERROR.getSyslogEquivalent()) {
            return ERROR;
        }
        if (severity == NOTICE.getSyslogEquivalent()) {
            return NOTICE;
        }
        if (severity == WARNING.getSyslogEquivalent()) {
            return WARNING;
        }
        if (severity == INFORMATIONAL.getSyslogEquivalent()) {
            return INFORMATIONAL;
        }
        if (severity == DEBUG.getSyslogEquivalent()) {
            return DEBUG;
        }
        return NOTICE;
    }
}

