/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.eventlog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.eventlog.EventLogSeverity;
import org.apache.commons.lang.StringEscapeUtils;

public class EventLogViewer {
    private Application application;

    public EventLogViewer(Application app) {
        this.application = app;
    }

    private EventLogEntry logEntryFromRow(ResultSet resultSet) throws SQLException {
        Timestamp date = resultSet.getTimestamp("LogDate");
        String notes = resultSet.getString("Notes");
        String title = resultSet.getString("Title");
        int severityId = resultSet.getInt("Severity");
        int logId = resultSet.getInt("EventLogID");
        EventLogSeverity severity = EventLogSeverity.getSeverityById(severityId);
        return new EventLogEntry(severity, date, title, notes, logId);
    }

    private EventLogEntry[] getEntries(PreparedStatement statement, boolean invertOrder) throws SQLException {
        ResultSet resultset = null;
        Vector<EventLogEntry> entriesVector = new Vector<EventLogEntry>();
        try {
            resultset = statement.executeQuery();
            while (resultset.next()) {
                entriesVector.add(this.logEntryFromRow(resultset));
            }
        }
        finally {
            if (resultset != null) {
                resultset.close();
            }
        }
        EventLogEntry[] events = new EventLogEntry[entriesVector.size()];
        if (!invertOrder) {
            entriesVector.toArray(events);
        } else {
            int c = 0;
            while (c < entriesVector.size()) {
                events[events.length - 1 - c] = (EventLogEntry)entriesVector.get(c);
                ++c;
            }
        }
        return events;
    }

    private PreparedStatement getQuery(EventLogFilter filter, Connection connection, boolean countOnly) throws SQLException {
        StringBuffer where = new StringBuffer();
        boolean needsAnd = false;
        if (filter.content != null && !filter.content.isEmpty()) {
            where.append("( lower(Title) like ? or lower(Notes) like ? )");
            needsAnd = true;
        }
        if (filter.entryId >= 0) {
            if (needsAnd) {
                where.append(" and ");
            }
            if (filter.isEntriesAfterId()) {
                where.append("EventLogID >= ?");
            } else {
                where.append("EventLogID <= ?");
            }
            needsAnd = true;
        }
        if (filter.severity != null) {
            if (needsAnd) {
                where.append(" and ");
            }
            where.append("Severity >= ?");
            needsAnd = true;
        }
        PreparedStatement statement = null;
        String whereStatement = where.toString();
        statement = countOnly ? (whereStatement != null && whereStatement.length() > 0 ? connection.prepareStatement("Select count(*) as EntriesCount from EventLog where " + whereStatement) : connection.prepareStatement("Select count(*) as EntriesCount from EventLog where " + whereStatement)) : (whereStatement != null && whereStatement.length() > 0 ? (filter.isEntriesAfterId() ? connection.prepareStatement("Select * from EventLog where " + whereStatement + " order by EventLogID asc") : connection.prepareStatement("Select * from EventLog where " + whereStatement + " order by EventLogID desc")) : (filter.isEntriesAfterId() ? connection.prepareStatement("Select * from EventLog order by EventLogID asc") : connection.prepareStatement("Select * from EventLog order by EventLogID desc")));
        int parameters = 0;
        if (filter.content != null && !filter.content.isEmpty()) {
            statement.setString(1, "%" + StringEscapeUtils.escapeSql((String)filter.content.toLowerCase()) + "%");
            statement.setString(2, "%" + StringEscapeUtils.escapeSql((String)filter.content.toLowerCase()) + "%");
            parameters += 2;
        }
        if (filter.entryId >= 0) {
            statement.setInt(++parameters, filter.entryId);
        }
        if (filter.severity != null) {
            statement.setInt(++parameters, filter.severity.getSeverity());
        }
        statement.setMaxRows(filter.count);
        return statement;
    }

    public EventLogEntry[] getEntries(EventLogFilter filter) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.EVENT_LOG);
            statement = this.getQuery(filter, connection, false);
            if (filter.isEntriesAfterId()) {
                EventLogEntry[] eventLogEntryArray = this.getEntries((PreparedStatement)statement, false);
                return eventLogEntryArray;
            }
            EventLogEntry[] eventLogEntryArray = this.getEntries((PreparedStatement)statement, true);
            return eventLogEntryArray;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    public int getMaxEntryID(String content, EventLogSeverity severity) throws NoDatabaseConnectionException, SQLException {
        return this.getMaxEntryIDInternal(content, severity);
    }

    public int getMaxEntryID(String content) throws NoDatabaseConnectionException, SQLException {
        return this.getMaxEntryIDInternal(content, null);
    }

    public int getMaxEntryID(EventLogSeverity severity) throws NoDatabaseConnectionException, SQLException {
        return this.getMaxEntryIDInternal(null, severity);
    }

    public int getMaxEntryID() throws NoDatabaseConnectionException, SQLException {
        return this.getMaxEntryIDInternal(null, null);
    }

    public int getMinEntryID(String content, EventLogSeverity severity) throws NoDatabaseConnectionException, SQLException {
        return this.getMinEntryIDInternal(content, severity);
    }

    public int getMinEntryID(String content) throws NoDatabaseConnectionException, SQLException {
        return this.getMinEntryIDInternal(content, null);
    }

    public int getMinEntryID(EventLogSeverity severity) throws NoDatabaseConnectionException, SQLException {
        return this.getMinEntryIDInternal(null, severity);
    }

    public int getMinEntryID() throws NoDatabaseConnectionException, SQLException {
        return this.getMinEntryIDInternal(null, null);
    }

    private int getMaxEntryIDInternal(String content, EventLogSeverity severity) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        if (content != null && content.length() == 0) {
            content = null;
        }
        try {
            connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.EVENT_LOG);
            if (content == null && severity == null) {
                statement = connection.prepareStatement("Select EventLogID from EventLog order by EventLogID desc");
            } else if (content == null && severity != null) {
                statement = connection.prepareStatement("Select EventLogID from EventLog where Severity >= ? order by EventLogID desc");
                statement.setInt(1, severity.getSeverity());
            } else if (content != null && severity != null) {
                statement = connection.prepareStatement("Select EventLogID from EventLog where ( lower(Title) like ? or lower(Notes) like ? ) and Severity >= ? order by EventLogID desc");
                statement.setString(1, "%" + StringEscapeUtils.escapeSql((String)content.toLowerCase()) + "%");
                statement.setString(2, "%" + StringEscapeUtils.escapeSql((String)content.toLowerCase()) + "%");
                statement.setInt(3, severity.getSeverity());
            } else {
                statement = connection.prepareStatement("Select EventLogID from EventLog where ( lower(Title) like ? or lower(Notes) like ? ) order by EventLogID desc");
                statement.setString(1, "%" + StringEscapeUtils.escapeSql((String)content.toLowerCase()) + "%");
                statement.setString(2, "%" + StringEscapeUtils.escapeSql((String)content.toLowerCase()) + "%");
            }
            statement.setMaxRows(1);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            return -1;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    private int getMinEntryIDInternal(String content, EventLogSeverity severity) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        if (content != null && content.length() == 0) {
            content = null;
        }
        try {
            connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.EVENT_LOG);
            if (content == null && severity == null) {
                statement = connection.prepareStatement("Select EventLogID from EventLog order by EventLogID asc");
            } else if (content == null && severity != null) {
                statement = connection.prepareStatement("Select EventLogID from EventLog where Severity >= ? order by EventLogID asc");
                statement.setInt(1, severity.getSeverity());
            } else if (content != null && severity != null) {
                statement = connection.prepareStatement("Select EventLogID from EventLog where ( lower(Title) like ? or lower(Notes) like ? ) and Severity >= ? order by EventLogID asc");
                statement.setString(1, "%" + StringEscapeUtils.escapeSql((String)content.toLowerCase()) + "%");
                statement.setString(2, "%" + StringEscapeUtils.escapeSql((String)content.toLowerCase()) + "%");
                statement.setInt(3, severity.getSeverity());
            } else {
                statement = connection.prepareStatement("Select EventLogID from EventLog where ( lower(Title) like ? or lower(Notes) like ? ) order by EventLogID asc");
                statement.setString(1, "%" + StringEscapeUtils.escapeSql((String)content.toLowerCase()) + "%");
                statement.setString(2, "%" + StringEscapeUtils.escapeSql((String)content.toLowerCase()) + "%");
            }
            statement.setMaxRows(1);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            return -1;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    public EventLogEntry getEntry(EventLogFilter filter) throws NoDatabaseConnectionException, SQLException, NotFoundException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.EVENT_LOG);
            filter.count = 1;
            statement = this.getQuery(filter, connection, false);
            EventLogEntry[] entries = this.getEntries((PreparedStatement)statement, true);
            if (entries.length >= 1) {
                EventLogEntry eventLogEntry = entries[0];
                return eventLogEntry;
            }
            throw new NotFoundException("A log entry was not found with the given entry ID (" + filter.entryId + ")");
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    public EventLogEntry getEntry(int entryId) throws SQLException, NoDatabaseConnectionException, NotFoundException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.EVENT_LOG);
            statement = connection.prepareStatement("Select * from EventLog where EventLogID = ?");
            statement.setInt(1, entryId);
            EventLogEntry[] entries = this.getEntries((PreparedStatement)statement, false);
            if (entries.length == 0) {
                throw new NotFoundException("A log entry was not found with the given entry ID (" + entryId + ")");
            }
            EventLogEntry eventLogEntry = entries[0];
            return eventLogEntry;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    public int getEntriesCount() throws SQLException, NoDatabaseConnectionException {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultset = null;
        try {
            connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.EVENT_LOG);
            statement = connection.prepareStatement("Select count(*) as EntriesCount from EventLog");
            resultset = statement.executeQuery();
            if (resultset.next()) {
                int n = resultset.getInt("EntriesCount");
                return n;
            }
            return 0;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (resultset != null) {
                resultset.close();
            }
        }
    }

    public int getEntriesCount(EventLogFilter filter) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultset = null;
        try {
            connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.EVENT_LOG);
            statement = this.getQuery(filter, connection, true);
            resultset = statement.executeQuery();
            if (resultset.next()) {
                int n = resultset.getInt("EntriesCount");
                return n;
            }
            return 0;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (resultset != null) {
                resultset.close();
            }
        }
    }

    public static class EventLogEntry {
        protected EventLogSeverity severity;
        protected Date logDate;
        protected String message;
        protected String notes;
        protected int entryId;

        protected EventLogEntry(EventLogSeverity severity, Date logDate, String message, int entryId) {
            this.severity = severity;
            this.logDate = logDate;
            this.message = message;
            this.notes = null;
            this.entryId = entryId;
        }

        protected EventLogEntry(EventLogSeverity severity, Date logDate, String message, String notes, int entryId) {
            this.severity = severity;
            this.logDate = logDate;
            this.message = message;
            this.notes = notes;
            this.entryId = entryId;
        }

        public EventLogSeverity getSeverity() {
            return this.severity;
        }

        public Date getDate() {
            return (Date)this.logDate.clone();
        }

        public String getFormattedDate() {
            SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy hh:mm:ss zzz");
            return sdf.format(this.logDate);
        }

        public String getMessage() {
            return this.message;
        }

        public int getEntryID() {
            return this.entryId;
        }

        public String getNotes() {
            return this.notes;
        }
    }

    public static class EventLogFilter {
        protected String content = null;
        protected int entryId = -1;
        protected int count = -1;
        protected boolean entriesAfterId = true;
        protected EventLogSeverity severity = null;

        public EventLogFilter(int count) {
            this.setCount(count);
        }

        public void setCount(int count) {
            if (count <= 0) {
                throw new IllegalArgumentException("The number of entries to return must be greater than zero");
            }
            this.count = count;
        }

        public void setSeverityFilter(EventLogSeverity severity) {
            this.severity = severity;
        }

        public void setContentFilter(String contentFilter) {
            this.content = contentFilter;
        }

        public void setEntryID(int entryId) {
            this.entryId = entryId;
        }

        public void setEntryID(int entryId, boolean entriesAfterId) {
            this.entryId = entryId;
            this.entriesAfterId = entriesAfterId;
        }

        public boolean isEntriesAfterId() {
            return this.entriesAfterId;
        }
    }
}

