/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.eventlog;

import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class SyslogNGAppender
extends AppenderSkeleton {
    private Protocol protocol = null;
    private String server = null;
    private int port = 514;
    private Vector<LoggingEvent> messageCache = new Vector();
    private SocketWrapper socket = null;
    private long lastConnectionAttempt = -1L;
    private static int RECONNECT_DELAY = 60000;
    private static int DEFAULT_CONNECT_TIMEOUT = 5000;
    private int maxBufferSize = 8000;
    private boolean connectionErrorNoted = false;
    private boolean maxCacheErrorNoted = false;

    public SyslogNGAppender(String server, int port, Protocol protocol) {
        this.setPort(port);
        this.setServer(server);
        this.setProtocol(protocol);
    }

    public SyslogNGAppender(String server, int port, int maxCacheSize, Protocol protocol) {
        this.setPort(port);
        this.setServer(server);
        this.setMaxCacheSize(maxCacheSize);
        this.setProtocol(protocol);
    }

    public void setMaxCacheSize(int maxCache) {
        if (maxCache < 0) {
            throw new IllegalArgumentException("The maximum message cache size must be greater than or equal to zero");
        }
        this.maxBufferSize = maxCache;
    }

    public synchronized void setPort(int port) {
        this.port = port;
    }

    private synchronized void setProtocol(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("The protocol cannot be null");
        }
        this.protocol = protocol;
    }

    public synchronized Protocol getProtocol() {
        return this.socket.socketType();
    }

    public int getPort() {
        return this.port;
    }

    public synchronized void setServer(String server) {
        this.server = server;
    }

    public String getServer() {
        return this.server;
    }

    public int getMaxCacheSize() {
        return this.maxBufferSize;
    }

    public boolean maxCacheReached() {
        return this.maxCacheErrorNoted;
    }

    public boolean isLogServerResponding() {
        return !this.connectionErrorNoted;
    }

    public int getCachedMessageCount() {
        return this.messageCache.size();
    }

    public synchronized void activateOptions() {
        try {
            this.socket = this.protocol == Protocol.TCP ? SocketWrapper.createTCPSocket(this.server, this.port) : SocketWrapper.createUDPSocket(this.server, this.port);
        }
        catch (IOException e) {
            this.errorHandler.error("Failed to open server socket", (Exception)e, 10005);
        }
    }

    protected void append(LoggingEvent event) {
        if (this.messageCache.size() > 0) {
            Iterator<LoggingEvent> it = this.messageCache.iterator();
            boolean cacheTransmissionStarted = false;
            while (it.hasNext()) {
                if (this.sendEvent(it.next())) {
                    if (!cacheTransmissionStarted) {
                        cacheTransmissionStarted = true;
                        if (this.messageCache.size() > 1) {
                            this.errorHandler.error(this.messageCache.size() + " log messages have been cached due to connectivity issues with the log server; the cache will now be forwarded to the log server.", null, 10003);
                        }
                    }
                    it.remove();
                    continue;
                }
                this.addToCache(event);
                return;
            }
            if (this.messageCache.size() == 0) {
                this.errorHandler.error("Log cache has been cleared; all cached log messages were sent to the log server.", null, 10002);
            }
        }
        if (!this.sendEvent(event)) {
            this.addToCache(event);
        }
    }

    private void addToCache(LoggingEvent event) {
        if (this.messageCache.size() < this.maxBufferSize) {
            this.messageCache.add(event);
        } else if (!this.maxCacheErrorNoted) {
            this.maxCacheErrorNoted = true;
            this.errorHandler.error("The log cache has reached its maximum size (" + this.maxBufferSize + "), messages will be discarded until log server connectivity is restored.", null, 10001);
        }
    }

    private synchronized boolean sendEvent(LoggingEvent event) {
        block18: {
            block17: {
                try {
                    if (this.layout != null) break block17;
                    this.errorHandler.error("No layout for appender " + this.name, null, 5);
                    return false;
                }
                catch (Exception e) {
                    this.errorHandler.error("Exception thrown while attempting to send data to the log server", e, 10004);
                    return false;
                }
            }
            if (this.socket != null) break block18;
            if (this.lastConnectionAttempt < System.currentTimeMillis() - (long)RECONNECT_DELAY) {
                block19: {
                    try {
                        this.socket = this.protocol == Protocol.TCP ? SocketWrapper.createTCPSocket(this.server, this.port) : SocketWrapper.createUDPSocket(this.server, this.port);
                    }
                    catch (UnknownHostException e) {
                        if (!this.connectionErrorNoted) {
                            this.errorHandler.error("Log server host address could not be resolved: " + e.getMessage(), null, 10005);
                            this.connectionErrorNoted = true;
                        }
                    }
                    catch (SocketTimeoutException e) {
                        if (!this.connectionErrorNoted) {
                            this.errorHandler.error("Log server connection timed out: " + e.getMessage(), null, 10005);
                            this.connectionErrorNoted = true;
                        }
                    }
                    catch (IOException e) {
                        if (this.connectionErrorNoted) break block19;
                        this.errorHandler.error("Socket connection to the log server could not be created: " + e.getMessage(), null, 10005);
                        this.connectionErrorNoted = true;
                    }
                }
                this.lastConnectionAttempt = System.currentTimeMillis();
                if (this.socket == null) {
                    return false;
                }
                break block18;
            }
            return false;
        }
        String message = "<" + (event.getLevel().getSyslogEquivalent() + 8) + ">" + StringUtils.replace((String)this.layout.format(event), (String)"\n", (String)"\\n") + "\r\n";
        try {
            this.socket.sendMessage(message);
            if (this.connectionErrorNoted) {
                this.errorHandler.error("Log server connection re-established", null, 10006);
            }
            this.connectionErrorNoted = false;
        }
        catch (IOException e) {
            this.errorHandler.error("Logs could not be sent to the log server for the following reason: " + e.getMessage(), null, 1);
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
            return false;
        }
        return true;
    }

    public void close() {
        try {
            if (this.socket == null) {
                return;
            }
            this.socket.close();
        }
        catch (Exception e) {
            this.errorHandler.error("Exception thrown while attempting to close connection", e, 3);
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public static enum Protocol {
        TCP,
        UDP;

    }

    private static class SocketWrapper {
        private Socket tcpSocket = null;
        private DatagramSocket udpSocket = null;
        private int udpPort = 514;
        private InetAddress udpAddress = null;

        private SocketWrapper() {
        }

        public static SocketWrapper createTCPSocket(String serverAddress, int port) throws UnknownHostException, SocketTimeoutException, IOException {
            SocketWrapper wrapper = new SocketWrapper();
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(serverAddress, port), DEFAULT_CONNECT_TIMEOUT);
            wrapper.tcpSocket = socket;
            return wrapper;
        }

        public static SocketWrapper createUDPSocket(String serverAddress, int port) throws UnknownHostException, IOException {
            InetAddress address;
            SocketWrapper wrapper = new SocketWrapper();
            wrapper.udpAddress = address = InetAddress.getByName(serverAddress);
            wrapper.udpPort = port;
            wrapper.udpSocket = new DatagramSocket();
            return wrapper;
        }

        public void close() throws IOException {
            if (this.tcpSocket != null) {
                this.tcpSocket.close();
            }
            if (this.udpSocket != null) {
                this.udpSocket.close();
            }
        }

        public Protocol socketType() {
            if (this.tcpSocket != null) {
                return Protocol.TCP;
            }
            if (this.udpSocket != null) {
                return Protocol.UDP;
            }
            return null;
        }

        public boolean sendMessage(String message) throws IOException {
            byte[] bytes = message.getBytes();
            if (this.tcpSocket != null) {
                OutputStream outStream = this.tcpSocket.getOutputStream();
                outStream.write(bytes);
                outStream.flush();
                return true;
            }
            if (this.udpSocket != null) {
                DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.udpAddress, this.udpPort);
                this.udpSocket.send(packet);
                return true;
            }
            return false;
        }
    }
}

