/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.extension;

import java.util.Date;
import java.util.Hashtable;
import net.lukemurphey.nsia.extension.ArgumentFieldsInvalidException;
import net.lukemurphey.nsia.extension.ExtensionInstallationException;
import net.lukemurphey.nsia.extension.ExtensionRemovalException;
import net.lukemurphey.nsia.extension.ExtensionType;
import net.lukemurphey.nsia.extension.FieldLayout;
import net.lukemurphey.nsia.extension.PrototypeField;
import org.apache.commons.lang.StringUtils;

public abstract class Extension {
    private String name;
    private String description;
    private ExtensionType extensionType;
    protected int versionMajor;
    protected int versionMinor;
    protected int revision;
    protected Date lastUpdated;

    protected Extension(String name, String description, ExtensionType extensionType) {
        if (extensionType == null) {
            throw new IllegalArgumentException("The ExtensionType must not be null");
        }
        this.setName(name);
        this.setDescription(description);
        this.extensionType = extensionType;
    }

    protected void setName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException("The name must not be null");
        }
        if (StringUtils.isBlank((String)newName)) {
            throw new IllegalArgumentException("The name must not be blank");
        }
        this.name = newName;
    }

    protected void setDescription(String desc) {
        if (desc == null) {
            throw new IllegalArgumentException("The name must not be null");
        }
        if (StringUtils.isBlank((String)desc)) {
            throw new IllegalArgumentException("The description must not be blank");
        }
        this.description = desc;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMajorVersion() {
        return this.versionMajor;
    }

    public int getMinorVersion() {
        return this.versionMinor;
    }

    public int getRevision() {
        return this.revision;
    }

    public Date getDateLastUpdated() {
        return (Date)this.lastUpdated.clone();
    }

    public abstract void install() throws ExtensionInstallationException;

    public abstract void uninstall() throws ExtensionRemovalException;

    public ExtensionType getExtensionType() {
        return this.extensionType;
    }

    public abstract Object createInstance(Hashtable<String, String> var1) throws ArgumentFieldsInvalidException;

    public abstract FieldLayout getFieldLayout();

    public abstract PrototypeField[] getFields();
}

