/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.extension;

import java.util.Hashtable;
import java.util.Vector;
import net.lukemurphey.nsia.extension.PrototypeField;

public class FieldLayout {
    private Vector<PrototypeField> fields = new Vector();
    private Hashtable<String, String> fieldValueList = null;
    private int width;

    public FieldLayout(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException("The width cannot be less than zero");
        }
        this.width = width;
    }

    public boolean addField(PrototypeField field) {
        return this.fields.add(field);
    }

    public PrototypeField[] getFields() {
        if (this.fieldValueList != null) {
            return this.getFields(this.fieldValueList);
        }
        return this.getFields(null);
    }

    public void setFieldsValues(Hashtable<String, String> fieldValueList) {
        this.fieldValueList = (Hashtable)fieldValueList.clone();
    }

    public PrototypeField[] getFields(Hashtable<String, String> fieldValues) {
        Vector<PrototypeField> fields = fieldValues != null ? this.getFieldsWithValues(fieldValues) : this.fields;
        PrototypeField[] fieldsArray = new PrototypeField[fields.size()];
        fields.toArray(fieldsArray);
        return fieldsArray;
    }

    private Vector<PrototypeField> getFieldsWithValues(Hashtable<String, String> fieldValues) {
        Vector<PrototypeField> newFields = new Vector<PrototypeField>(this.fields.size());
        for (PrototypeField field : this.fields) {
            if (fieldValues.containsKey(field.getName())) {
                try {
                    PrototypeField addField = (PrototypeField)field.clone();
                    addField.setDefaultValue(fieldValues.get(field.getName()));
                    newFields.add(addField);
                }
                catch (CloneNotSupportedException e) {
                    newFields.add(field);
                }
                continue;
            }
            newFields.add(field);
        }
        return newFields;
    }

    public Vector<FieldRow> getLayout() {
        if (this.fieldValueList != null) {
            return this.getLayout(this.fieldValueList);
        }
        return this.getLayout(null);
    }

    public Vector<FieldRow> getLayout(Hashtable<String, String> fieldValues) {
        Vector<FieldRow> fieldRows = new Vector<FieldRow>();
        Vector<PrototypeField> fields = fieldValues != null ? this.getFieldsWithValues(fieldValues) : this.fields;
        FieldRow current = null;
        int c = 0;
        while (c < fields.size()) {
            if (fieldRows.size() == 0) {
                current = new FieldRow();
                fieldRows.add(current);
                current.addField(fields.get(c));
            } else if (current != null && current.getLayoutWidth() == 0) {
                current.addField(fields.get(c));
            } else if (current != null && current.getLayoutWidth() + fields.get(c).getLayoutWidth() > this.width) {
                current = new FieldRow();
                fieldRows.add(current);
                current.addField(fields.get(c));
            } else if (current != null) {
                current.addField(fields.get(c));
            }
            ++c;
        }
        return fieldRows;
    }

    public static class FieldRow {
        private Vector<PrototypeField> columns = new Vector();
        private int width = -1;

        protected boolean addField(PrototypeField field) {
            if (this.width < 0) {
                this.width = 0;
            }
            this.width += field.getLayoutWidth();
            return this.columns.add(field);
        }

        public int getLayoutWidth() {
            if (this.width < 0) {
                for (PrototypeField field : this.columns) {
                    this.width += field.getLayoutWidth();
                }
                return this.width;
            }
            return this.width;
        }

        public PrototypeField[] getFields() {
            PrototypeField[] fields = new PrototypeField[this.columns.size()];
            this.columns.toArray(fields);
            return fields;
        }
    }
}

