/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.response;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.extension.ArgumentFieldsInvalidException;
import net.lukemurphey.nsia.extension.FieldLayout;
import net.lukemurphey.nsia.extension.FieldValidator;
import net.lukemurphey.nsia.extension.PrototypeField;
import net.lukemurphey.nsia.response.ActionFailedException;
import net.lukemurphey.nsia.response.ActionInstantiationException;
import net.lukemurphey.nsia.scan.ScanResult;
import org.apache.commons.lang.StringUtils;

public abstract class Action
implements Serializable {
    private static final long serialVersionUID = -5095063314974282138L;
    protected String description;
    protected String extendedDescription;
    private int actionID = -1;

    public abstract void execute(EventLogMessage var1) throws ActionFailedException;

    public abstract void execute(ScanResult var1) throws ActionFailedException;

    protected String getMessage(String templateString, ScanResult scanResult) throws ActionFailedException {
        try {
            Configuration cfg = new Configuration();
            cfg.setTagSyntax(0);
            StringReader reader = new StringReader(templateString);
            Template template = new Template("default_template", (Reader)reader, cfg);
            HashMap<String, ScanResult> data = new HashMap<String, ScanResult>();
            data.put("scan_result", scanResult);
            StringWriter writer = new StringWriter();
            template.process(data, (Writer)writer);
            return writer.toString();
        }
        catch (IOException e) {
            throw new ActionFailedException("Exception generated while rendering message field", e);
        }
        catch (TemplateException e) {
            throw new ActionFailedException("Exception generated while rendering message field", e);
        }
    }

    protected Action(String description, String extendedDescription) {
        if (description == null) {
            throw new IllegalArgumentException("The description of the action cannot be null");
        }
        this.description = description;
        this.extendedDescription = extendedDescription;
    }

    public String getUserLongDescription() {
        return this.extendedDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public int getActionID() {
        return this.actionID;
    }

    public abstract Hashtable<String, String> getValues();

    public abstract FieldLayout getLayoutWithValues();

    public void configure(Hashtable<String, String> arguments) throws ArgumentFieldsInvalidException {
        PrototypeField[] fields;
        FieldLayout layout = this.getLayoutWithValues();
        PrototypeField[] prototypeFieldArray = fields = layout.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            PrototypeField field = prototypeFieldArray[n2];
            String value = arguments.get(field.getName());
            if (value == null) {
                throw new ArgumentFieldsInvalidException("The " + field.getName() + " field was not provided", field);
            }
            FieldValidator.FieldValidatorResult result = field.validate(value);
            if (!result.validated()) {
                if (result.getMessage() == null) {
                    throw new ArgumentFieldsInvalidException("The " + field.getName() + " field is invalid", field);
                }
                throw new ArgumentFieldsInvalidException(result.getMessage(), field);
            }
            this.setField(field.getName(), value);
            ++n2;
        }
    }

    protected abstract void setField(String var1, String var2);

    public void save() throws NoDatabaseConnectionException, SQLException, IOException {
        byte[] bytes;
        block32: {
            bytes = null;
            ByteArrayOutputStream byteOutStream = null;
            ObjectOutputStream outStream = null;
            IOException cause = null;
            try {
                try {
                    byteOutStream = new ByteArrayOutputStream();
                    outStream = new ObjectOutputStream(byteOutStream);
                    outStream.writeObject(this);
                    bytes = byteOutStream.toByteArray();
                }
                catch (IOException e) {
                    cause = e;
                    try {
                        if (byteOutStream != null) {
                            byteOutStream.close();
                        }
                        if (outStream != null) {
                            outStream.close();
                        }
                        break block32;
                    }
                    catch (IOException e2) {
                        if (e2.getCause() == null && cause != null) {
                            e2.initCause(cause);
                            throw e2;
                        }
                        if (e2.getCause() != null && cause != null) {
                            throw cause;
                        }
                        throw e2;
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    if (byteOutStream != null) {
                        byteOutStream.close();
                    }
                    if (outStream != null) {
                        outStream.close();
                    }
                }
                catch (IOException e) {
                    if (e.getCause() == null && cause != null) {
                        e.initCause(cause);
                        throw e;
                    }
                    if (e.getCause() != null && cause != null) {
                        throw cause;
                    }
                    throw e;
                }
                throw throwable;
            }
            try {
                if (byteOutStream != null) {
                    byteOutStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                if (e.getCause() == null && cause != null) {
                    e.initCause(cause);
                    throw e;
                }
                if (e.getCause() != null && cause != null) {
                    throw cause;
                }
                throw e;
            }
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet keys = null;
        try {
            connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.ACTION);
            if (this.actionID >= 0) {
                statement = connection.prepareStatement("Update Action set State = ? where ActionID = ?");
                statement.setBytes(1, bytes);
                statement.setInt(2, this.actionID);
                statement.executeUpdate();
            } else {
                statement = connection.prepareStatement("Insert into Action (State) values (?)", 1);
                statement.setBytes(1, bytes);
                statement.executeUpdate();
                keys = statement.getGeneratedKeys();
                if (keys.next()) {
                    this.actionID = keys.getInt(1);
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (keys != null) {
                keys.close();
            }
        }
    }

    public static Action loadFromDatabase(Connection connection, int actionID) throws SQLException, ActionInstantiationException {
        if (connection == null) {
            throw new IllegalArgumentException("The database connection cannot be null");
        }
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            statement = connection.prepareStatement("Select * from Action where ActionID = ?");
            statement.setInt(1, actionID);
            result = statement.executeQuery();
            if (result.next()) {
                byte[] bytes = result.getBytes("State");
                ByteArrayInputStream byteInStream = new ByteArrayInputStream(bytes);
                ObjectInputStream inStream = new ObjectInputStream(byteInStream);
                Action action = (Action)inStream.readObject();
                action.actionID = actionID;
                Action action2 = action;
                return action2;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ActionInstantiationException(e);
        }
        catch (IOException e) {
            throw new ActionInstantiationException(e);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
        }
        return null;
    }

    public abstract String getConfigDescription();

    public static class MessageVariable {
        private String name;
        private String value;
        public static final String ARGUMENT_NAME = "\\$[a-zA-Z0-9_]+";

        public MessageVariable(String name, String value) {
            if (name == null) {
                throw new IllegalArgumentException("The name cannot be null");
            }
            if (!Pattern.matches(ARGUMENT_NAME, name)) {
                throw new IllegalArgumentException("The name is not valid");
            }
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.getName()) + "::" + this.getValue();
        }

        public static Vector<MessageVariable> getMessageVariables(EventLogMessage logMessage) {
            Vector<MessageVariable> vars = new Vector<MessageVariable>();
            EventLogField[] eventLogFieldArray = logMessage.getFields();
            int n = eventLogFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                EventLogField field = eventLogFieldArray[n2];
                vars.add(new MessageVariable("$" + field.getName().getSimpleNameFormat(), field.getValue()));
                ++n2;
            }
            vars.add(new MessageVariable("$EventType", logMessage.getEventType().getName()));
            vars.add(new MessageVariable("$EventTypeID", Integer.toString(logMessage.getEventType().ordinal())));
            vars.add(new MessageVariable("$event_type", logMessage.getEventType().getName()));
            vars.add(new MessageVariable("$event_type_id", Integer.toString(logMessage.getEventType().ordinal())));
            vars.add(new MessageVariable("$SeverityID", Integer.toString(logMessage.getSeverity().getSyslogEquivalent())));
            vars.add(new MessageVariable("$Severity", logMessage.getSeverity().toString()));
            vars.add(new MessageVariable("$severity_id", Integer.toString(logMessage.getSeverity().getSyslogEquivalent())));
            vars.add(new MessageVariable("$Date", logMessage.getDate().toString()));
            vars.add(new MessageVariable("$Message", logMessage.getMessageName()));
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                vars.add(new MessageVariable("$scanner_host_name", localhost.getHostName()));
                vars.add(new MessageVariable("$scanner_ip", localhost.getHostAddress()));
                int port = Application.getApplication().getApplicationConfiguration().getServerPort();
                boolean encryption_enabled = Application.getApplication().getApplicationConfiguration().isSslEnabled();
                vars.add(new MessageVariable("$scanner_port", String.valueOf(port)));
                if (encryption_enabled) {
                    vars.add(new MessageVariable("$scanner_protocol", "https"));
                } else {
                    vars.add(new MessageVariable("$scanner_protocol", "http"));
                }
                if (encryption_enabled && port == 443) {
                    vars.add(new MessageVariable("$scanner_url", "https://" + localhost.getHostName()));
                    vars.add(new MessageVariable("$scanner_url_ip", "https://" + localhost.getHostAddress()));
                } else if (!encryption_enabled && port == 80) {
                    vars.add(new MessageVariable("$scanner_url", "http://" + localhost.getHostName()));
                    vars.add(new MessageVariable("$scanner_url_ip", "http://" + localhost.getHostAddress()));
                } else if (encryption_enabled) {
                    vars.add(new MessageVariable("$scanner_url", "https://" + localhost.getHostName() + ":" + port));
                    vars.add(new MessageVariable("$scanner_url_ip", "https://" + localhost.getHostAddress() + ":" + port));
                } else {
                    vars.add(new MessageVariable("$scanner_url", "http://" + localhost.getHostName() + ":" + port));
                    vars.add(new MessageVariable("$scanner_url_ip", "http://" + localhost.getHostAddress() + ":" + port));
                }
            }
            catch (UnknownHostException e) {
                Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to obtain the address of the local scanner")), (Throwable)e);
            }
            catch (NoDatabaseConnectionException e) {
                Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to obtain the address of the local scanner")), (Throwable)e);
            }
            catch (SQLException e) {
                Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to obtain the address of the local scanner")), (Throwable)e);
            }
            catch (InputValidationException e) {
                Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to obtain the address of the local scanner")), (Throwable)e);
            }
            return vars;
        }

        public static Vector<MessageVariable> getMessageVariablesFreemarker(EventLogMessage logMessage) {
            Vector<MessageVariable> vars = new Vector<MessageVariable>();
            EventLogField[] eventLogFieldArray = logMessage.getFields();
            int n = eventLogFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                EventLogField field = eventLogFieldArray[n2];
                vars.add(new MessageVariable("${" + field.getName().getSimpleNameFormat() + "}", field.getValue()));
                ++n2;
            }
            vars.add(new MessageVariable("${EventType}", logMessage.getEventType().getName()));
            vars.add(new MessageVariable("${EventTypeID}", Integer.toString(logMessage.getEventType().ordinal())));
            vars.add(new MessageVariable("${event_type}", logMessage.getEventType().getName()));
            vars.add(new MessageVariable("${event_type_id}", Integer.toString(logMessage.getEventType().ordinal())));
            vars.add(new MessageVariable("${SeverityID}", Integer.toString(logMessage.getSeverity().getSyslogEquivalent())));
            vars.add(new MessageVariable("${Severity}", logMessage.getSeverity().toString()));
            vars.add(new MessageVariable("${severity_id}", Integer.toString(logMessage.getSeverity().getSyslogEquivalent())));
            vars.add(new MessageVariable("${Date}", logMessage.getDate().toString()));
            vars.add(new MessageVariable("${Message}", logMessage.getMessageName()));
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                vars.add(new MessageVariable("${scanner_host_name}", localhost.getHostName()));
                vars.add(new MessageVariable("${scanner_ip}", localhost.getHostAddress()));
                int port = Application.getApplication().getApplicationConfiguration().getServerPort();
                boolean encryption_enabled = Application.getApplication().getApplicationConfiguration().isSslEnabled();
                vars.add(new MessageVariable("${scanner_port}", String.valueOf(port)));
                if (encryption_enabled) {
                    vars.add(new MessageVariable("${scanner_protocol}", "https"));
                } else {
                    vars.add(new MessageVariable("${scanner_protocol}", "http"));
                }
                if (encryption_enabled && port == 443) {
                    vars.add(new MessageVariable("${scanner_url}", "https://" + localhost.getHostName()));
                    vars.add(new MessageVariable("${scanner_url_ip}", "https://" + localhost.getHostAddress()));
                } else if (!encryption_enabled && port == 80) {
                    vars.add(new MessageVariable("${scanner_url}", "http://" + localhost.getHostName()));
                    vars.add(new MessageVariable("${scanner_url_ip}", "http://" + localhost.getHostAddress()));
                } else if (encryption_enabled) {
                    vars.add(new MessageVariable("${scanner_url}", "https://" + localhost.getHostName() + ":" + port));
                    vars.add(new MessageVariable("${scanner_url_ip}", "https://" + localhost.getHostAddress() + ":" + port));
                } else {
                    vars.add(new MessageVariable("${scanner_url}", "http://" + localhost.getHostName() + ":" + port));
                    vars.add(new MessageVariable("${scanner_url_ip}", "http://" + localhost.getHostAddress() + ":" + port));
                }
            }
            catch (UnknownHostException e) {
                Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to obtain the address of the local scanner")), (Throwable)e);
            }
            catch (NoDatabaseConnectionException e) {
                Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to obtain the address of the local scanner")), (Throwable)e);
            }
            catch (SQLException e) {
                Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to obtain the address of the local scanner")), (Throwable)e);
            }
            catch (InputValidationException e) {
                Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to obtain the address of the local scanner")), (Throwable)e);
            }
            return vars;
        }

        public String processMessageTemplate(String templateStr, HashMap<String, Object> vars) {
            StringReader reader = new StringReader(templateStr);
            Configuration cfg = new Configuration();
            cfg.setStrictSyntaxMode(false);
            cfg.setTagSyntax(0);
            try {
                Template template = new Template("email_template", (Reader)reader, cfg);
                StringWriter writer = new StringWriter();
                template.process(vars, (Writer)writer);
                writer.flush();
                return writer.getBuffer().toString();
            }
            catch (IOException e) {
                Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.RESPONSE_ACTION_FAILED), (Throwable)e);
            }
            catch (TemplateException e) {
                Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.RESPONSE_ACTION_FAILED), (Throwable)e);
            }
            return null;
        }

        public static String processMessageTemplate(String template, Vector<MessageVariable> vars) {
            Pattern pattern = Pattern.compile(ARGUMENT_NAME, 2);
            Matcher matcher = pattern.matcher(template);
            Vector<String> varsWithinTemplate = new Vector<String>();
            while (matcher.find()) {
                varsWithinTemplate.add(matcher.group(0));
            }
            Collections.sort(varsWithinTemplate, new LengthComparator());
            int c = 0;
            while (c < varsWithinTemplate.size()) {
                String value = null;
                int d = 0;
                while (d < vars.size()) {
                    if (StringUtils.equalsIgnoreCase((String)vars.get(d).getName(), (String)((String)varsWithinTemplate.get(c)))) {
                        value = vars.get(d).getValue();
                    }
                    ++d;
                }
                template = value != null ? StringUtils.replace((String)template, (String)((String)varsWithinTemplate.get(c)), value) : StringUtils.replace((String)template, (String)((String)varsWithinTemplate.get(c)), (String)("[" + ((String)varsWithinTemplate.get(c)).substring(1) + " was undefined]"));
                ++c;
            }
            return template;
        }

        private static class LengthComparator
        implements Comparator<String> {
            private LengthComparator() {
            }

            @Override
            public int compare(String arg1, String arg0) {
                if (arg0 == null && arg1 == null) {
                    return 0;
                }
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                if (arg0.length() < arg1.length()) {
                    return -1;
                }
                if (arg0.length() > arg1.length()) {
                    return 1;
                }
                return 0;
            }
        }
    }
}

