/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.rest;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import net.lukemurphey.nsia.rest.RESTEndpointClient;
import net.lukemurphey.nsia.rest.RESTRequestFailedException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EndpointIndex
extends RESTEndpointClient {
    public static final String DEFAULT_ENDPOINT = "https://threatfactor.com/rest/NSIA/";

    public EndpointIndex() {
        try {
            this.url = new URL(DEFAULT_ENDPOINT);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The default endpoint URL is malformed");
        }
    }

    public EndpointIndex(URL endPointURL) {
        this.setEndpointURL(endPointURL);
    }

    public Endpoint[] getEndpoints() throws RESTRequestFailedException {
        Document doc = this.doGet();
        try {
            Vector<Endpoint> endpoints = this.parseMethods(doc);
            Endpoint[] endpoints_array = new Endpoint[endpoints.size()];
            endpoints.toArray(endpoints_array);
            return endpoints_array;
        }
        catch (MalformedURLException e) {
            throw new RESTRequestFailedException("Unable to parse URL form list of endpoints", e);
        }
    }

    private Vector<Endpoint> parseMethods(Document doc) throws MalformedURLException {
        Vector<Endpoint> endpoints = new Vector<Endpoint>();
        Element root = doc.getDocumentElement();
        NodeList nl = root.getElementsByTagName("Endpoint");
        if (nl != null && nl.getLength() > 0) {
            int i = 0;
            while (i < nl.getLength()) {
                Element el = (Element)nl.item(i);
                String href = el.getAttribute("URL");
                String methodName = el.getAttribute("Name");
                String requiresLicenseString = el.getAttribute("RequiresLicense");
                boolean requiresLicense = false;
                if (requiresLicenseString == null || requiresLicenseString.length() == 0) {
                    requiresLicense = false;
                } else if (requiresLicenseString.equalsIgnoreCase("True")) {
                    requiresLicense = true;
                }
                endpoints.add(new Endpoint(new URL(this.url, href), methodName, requiresLicense));
                ++i;
            }
        }
        return endpoints;
    }

    public static Endpoint[] getEndpoints(URL url) throws RESTRequestFailedException {
        EndpointIndex getEndpoints = new EndpointIndex(url);
        return getEndpoints.getEndpoints();
    }

    public static Endpoint getEndpoint(URL url, String name) throws RESTRequestFailedException {
        Endpoint[] endpoints;
        EndpointIndex getEndpoints = new EndpointIndex(url);
        Endpoint[] endpointArray = endpoints = getEndpoints.getEndpoints();
        int n = endpoints.length;
        int n2 = 0;
        while (n2 < n) {
            Endpoint endpoint = endpointArray[n2];
            if (endpoint.getName().equalsIgnoreCase(name)) {
                return endpoint;
            }
            ++n2;
        }
        return null;
    }

    public static Endpoint getEndpoint(String name) throws RESTRequestFailedException {
        try {
            return EndpointIndex.getEndpoint(new URL(DEFAULT_ENDPOINT), name);
        }
        catch (MalformedURLException e) {
            throw new RESTRequestFailedException("Default endpoint is not a valid URL");
        }
    }

    public static class Endpoint {
        private URL url;
        private String name;
        private boolean requiresLicense = false;

        public Endpoint(URL url, String name) {
            this.name = name;
            this.url = url;
        }

        public Endpoint(URL url, String name, boolean requiresLicense) {
            this.name = name;
            this.url = url;
            this.requiresLicense = requiresLicense;
        }

        public String getName() {
            return this.name;
        }

        public URL getURL() {
            return this.url;
        }

        public boolean requiresLicense() {
            return this.requiresLicense;
        }
    }
}

