/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.lukemurphey.nsia.rest.RESTRequestAuthFailedException;
import net.lukemurphey.nsia.rest.RESTRequestFailedException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RESTEndpointClient {
    public final int SOCKET_TIMEOUT = 300000;
    public final int CONNECTION_TIMEOUT = 30000;
    public final int REQUEST_TIMEOUT = 60000;
    protected HttpConnectionManager manager = null;
    protected URL url = null;
    String id = null;
    String password = null;
    Object timeoutMutex = new Object();
    boolean timeoutReached = false;
    HttpMethod method = null;
    public static final SimpleDateFormat ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public HttpClient getHttpClient() {
        HttpClient client = new HttpClient(this.getConnectionManager());
        if (this.password != null) {
            String id = this.id;
            if (id == null) {
                id = "";
            }
            client.getState().setCredentials(new AuthScope(this.url.getHost(), this.url.getPort(), "threatfactor_nsia"), (Credentials)new UsernamePasswordCredentials(id, this.password));
            client.getParams().setAuthenticationPreemptive(true);
        }
        return client;
    }

    protected boolean isResultSuccess(Document doc) {
        Element root = doc.getDocumentElement();
        String success = root.getAttribute("success");
        return success.equalsIgnoreCase("1") || success.equalsIgnoreCase("true");
    }

    protected String documentToString(Document doc) throws TransformerFactoryConfigurationError, TransformerException {
        StringWriter stw = new StringWriter();
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.transform(new DOMSource(doc), new StreamResult(stw));
        return stw.toString();
    }

    HttpConnectionManager getConnectionManager() {
        return this.getConnectionManager(300000, 30000);
    }

    synchronized HttpConnectionManager getConnectionManager(int socketTimeout, int connectionTimeout) {
        if (this.manager == null) {
            HttpConnectionManagerParams params = new HttpConnectionManagerParams();
            params.setSoTimeout(socketTimeout);
            params.setConnectionTimeout(connectionTimeout);
            params.setStaleCheckingEnabled(true);
            HostConfiguration host = new HostConfiguration();
            host.setHost(this.url.getHost());
            params.setMaxConnectionsPerHost(host, 3);
            this.manager = new SimpleHttpConnectionManager();
            this.manager.setParams(params);
        }
        return this.manager;
    }

    public void setEndpointURL(URL endpointURL) {
        if (endpointURL == null) {
            throw new IllegalArgumentException("The endpoint URL cannot be null");
        }
        this.url = endpointURL;
    }

    protected Document doGet() throws RESTRequestFailedException {
        GetMethod get = null;
        try {
            get = new GetMethod(this.url.toExternalForm());
            Document document = this.doHTTP((HttpMethod)get);
            return document;
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
    }

    protected String doGetToString() throws RESTRequestFailedException {
        GetMethod get = null;
        try {
            get = new GetMethod(this.url.toExternalForm());
            String string = this.doHTTPToString((HttpMethod)get);
            return string;
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
    }

    protected Document doHTTP(HttpMethod method) throws RESTRequestFailedException {
        RESTHelper helper = new RESTHelper();
        this.method = method;
        try {
            helper.startStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            Document doc = null;
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = doc = db.parse(helper.is);
            return document;
        }
        catch (IOException e) {
            throw new RESTRequestFailedException("REST request failed due to an IO exception", e);
        }
        catch (ParserConfigurationException e) {
            throw new RESTRequestFailedException("REST request failed since the response could not parsed due to a parser configuration problem", e);
        }
        catch (SAXException e) {
            throw new RESTRequestFailedException("REST request failed since the response could not parsed", e);
        }
        finally {
            if (helper != null) {
                helper.streamDone();
            }
        }
    }

    protected String doHTTPToString(HttpMethod method) throws RESTRequestFailedException {
        RESTHelper helper = new RESTHelper();
        this.method = method;
        try {
            int n;
            helper.startStream();
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            BufferedReader reader = new BufferedReader(new InputStreamReader(helper.is, "UTF-8"));
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
            String string = ((Object)writer).toString();
            return string;
        }
        catch (IOException e) {
            throw new RESTRequestFailedException("REST request failed due to an IO exception", e);
        }
        finally {
            if (helper != null) {
                helper.streamDone();
            }
        }
    }

    public static Date parseStandardDateFormat(String date) throws ParseException {
        return ISO8601FORMAT.parse(date);
    }

    public static String getDateAsISO8601String(Date date) {
        String result = ISO8601FORMAT.format(date);
        result = String.valueOf(result.substring(0, result.length() - 2)) + ":" + result.substring(result.length() - 2);
        return result;
    }

    class RESTHelper {
        public InputStream is = null;
        public HttpClient client = null;
        public TimeoutThread timeoutThread;

        public RESTHelper() {
            this.timeoutThread = new TimeoutThread();
        }

        public InputStream startStream() throws RESTRequestFailedException {
            if (RESTEndpointClient.this.id != null) {
                RESTEndpointClient.this.method.setDoAuthentication(true);
            }
            HttpClient client = null;
            TimeoutThread timeoutThread = new TimeoutThread();
            timeoutThread.start();
            try {
                client = RESTEndpointClient.this.getHttpClient();
                int status = client.executeMethod(RESTEndpointClient.this.method);
                if (RESTEndpointClient.this.timeoutReached) {
                    throw new RESTRequestFailedException("REST request timed out");
                }
                if (status == 401) {
                    throw new RESTRequestAuthFailedException();
                }
                if (status != 200) {
                    throw new RESTRequestFailedException("HTTP request failed (returned HTTP code " + status + " for " + RESTEndpointClient.this.method.getURI() + ")", status);
                }
                this.is = RESTEndpointClient.this.method.getResponseBodyAsStream();
                return this.is;
            }
            catch (HttpException e) {
                throw new RESTRequestFailedException("REST request failed due to an HTTP exception", e);
            }
            catch (IOException e) {
                throw new RESTRequestFailedException("REST request failed due to an IO exception", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void streamDone() throws RESTRequestFailedException {
            RESTEndpointClient.this.method.releaseConnection();
            Object object = RESTEndpointClient.this.timeoutMutex;
            synchronized (object) {
                this.timeoutThread.terminate();
                RESTEndpointClient.this.timeoutMutex.notify();
            }
            if (RESTEndpointClient.this.manager != null) {
                RESTEndpointClient.this.manager.closeIdleConnections(0L);
            }
            try {
                if (this.is != null) {
                    this.is.close();
                }
            }
            catch (IOException e) {
                throw new RESTRequestFailedException("REST request failed due to an IO exception", e);
            }
        }
    }

    private class TimeoutThread
    extends Thread {
        private boolean stop = false;

        public TimeoutThread() {
            this.setName("REST operation timeout monitor: " + RESTEndpointClient.this.method);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            long delayTime = 60000L;
            try {
                Object object = RESTEndpointClient.this.timeoutMutex;
                synchronized (object) {
                    if (!this.stop) {
                        RESTEndpointClient.this.timeoutMutex.wait(delayTime);
                    }
                    if (System.currentTimeMillis() - startTime >= delayTime) {
                        RESTEndpointClient.this.method.abort();
                        RESTEndpointClient.this.timeoutReached = false;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void terminate() {
            this.stop = true;
            this.interrupt();
        }
    }
}

