/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.scan.DataSpecimen;
import net.lukemurphey.nsia.scan.Evaluator;

public class ByteEvaluator
extends Evaluator {
    private byte[] rule;
    private static final Pattern BYTE_FORMAT = Pattern.compile("[ ]?([A-Fa-f0-9]{2})[ ]?");

    public ByteEvaluator(byte[] rule) {
        if (rule == null) {
            throw new IllegalArgumentException("The rule must not be null");
        }
        if (rule.length <= 0) {
            throw new IllegalArgumentException("The rule must not be empty");
        }
        this.rule = new byte[rule.length];
        System.arraycopy(rule, 0, this.rule, 0, rule.length);
    }

    public static ByteEvaluator parse(String rule) {
        Matcher matcher = BYTE_FORMAT.matcher(rule);
        byte[] bytes = new byte[128];
        int c = 0;
        while (matcher.find() && c < 128) {
            String hexChars = matcher.group(1);
            bytes[c] = ByteEvaluator.getIntFromHexChars(hexChars.charAt(1), hexChars.charAt(0));
            ++c;
        }
        byte[] bytesFinal = new byte[c];
        System.arraycopy(bytes, 0, bytesFinal, 0, c);
        return new ByteEvaluator(bytesFinal);
    }

    private static int charToNibble(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid hex character: " + c);
    }

    private static byte getIntFromHexChars(char hexCharLow, char hexCharHigh) {
        int high = ByteEvaluator.charToNibble(hexCharHigh);
        int low = ByteEvaluator.charToNibble(hexCharLow);
        return (byte)(high << 4 | low);
    }

    public byte[] getBytesToMatch() {
        byte[] copy = new byte[this.rule.length];
        System.arraycopy(this.rule, 0, copy, 0, this.rule.length);
        return copy;
    }

    @Override
    public int evaluate(DataSpecimen content, int lastMatch, boolean useBasicEncoding) {
        int startLocation = this.computeStartLocation(lastMatch);
        byte[] bytes = content.getBytes();
        int maxDepth = this.depth > 0 && this.within <= 0 ? this.depth + startLocation : (this.within > 0 && this.depth <= 0 ? this.within + startLocation + this.rule.length : (this.within > 0 && this.depth > 0 ? Math.min(this.within + startLocation + this.rule.length, this.depth + startLocation) : bytes.length));
        return ByteEvaluator.locationOf(bytes, this.rule, startLocation, maxDepth);
    }

    private static int locationOf(byte[] searchIn, byte[] searchFor, int startLocation, int maximumDepth) {
        if (searchFor == null) {
            throw new IllegalArgumentException("The byte array to search for must not be null");
        }
        if (searchFor.length == 0) {
            throw new IllegalArgumentException("The byte array to search for must not be empty");
        }
        if (searchIn == null) {
            throw new IllegalArgumentException("The byte array to search in must not be null");
        }
        if (searchFor.length == 0) {
            throw new IllegalArgumentException("The byte array to search in must not be empty");
        }
        int offsetIntoSample = 0;
        int c = startLocation;
        while (c < searchIn.length) {
            if (maximumDepth > 0 && c >= maximumDepth) {
                return -1;
            }
            if (searchFor[offsetIntoSample] == searchIn[c]) {
                if (offsetIntoSample >= searchFor.length - 1) {
                    return c;
                }
                ++offsetIntoSample;
            } else {
                offsetIntoSample = 0;
            }
            ++c;
        }
        return -1;
    }

    @Override
    public Evaluator.ReturnType getReturnType() {
        return Evaluator.ReturnType.BYTE_LOCATION;
    }
}

