/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.scan.DataSpecimen;
import net.lukemurphey.nsia.scan.Evaluator;
import net.lukemurphey.nsia.scan.InvalidEvaluatorException;

public class ByteJumpEvaluator
extends Evaluator {
    private int length = 0;
    private int alignment = 1;
    private int base = 10;
    private DataType dataType;
    private boolean bigEndian = true;
    private int multiplier = 1;
    private static final Pattern BYTE_JUMP_REGEX = Pattern.compile("[ ]*([0-9]+)[ ]+(digits|bytes|byte|digit)\\s*(\\(([-A-Za-z0-9, ]*)\\))?\\s*(\\s*x\\s*([0-9]+)\\s*)?", 8);

    public static ByteJumpEvaluator parse(String value) throws InvalidEvaluatorException {
        if (value == null) {
            throw new IllegalArgumentException("The ByteJump evaluator rule cannot be null");
        }
        if (value.isEmpty()) {
            throw new IllegalArgumentException("The ByteJump evaluator rule cannot be empty");
        }
        ByteJumpEvaluator byteJump = new ByteJumpEvaluator();
        Matcher matcher = BYTE_JUMP_REGEX.matcher(value);
        if (!matcher.find()) {
            throw new InvalidEvaluatorException("The ByteJump evaluator rule does not appear to be valid");
        }
        try {
            byteJump.length = Integer.parseInt(matcher.group(1));
        }
        catch (NumberFormatException e) {
            throw new InvalidEvaluatorException("The ByteJump evaluator rule does not appear to be valid (number format of byte count is not valid)");
        }
        if (matcher.group(2) == null) {
            throw new InvalidEvaluatorException("The ByteJump evaluator rule does not appear to be valid (missing data type)");
        }
        if (matcher.group(2).equalsIgnoreCase("bytes")) {
            byteJump.dataType = DataType.BYTES;
        } else if (matcher.group(2).equalsIgnoreCase("digits")) {
            byteJump.dataType = DataType.STRING;
        } else if (matcher.group(2).equalsIgnoreCase("byte")) {
            byteJump.dataType = DataType.BYTES;
        } else if (matcher.group(2).equalsIgnoreCase("digit")) {
            byteJump.dataType = DataType.STRING;
        } else {
            throw new InvalidEvaluatorException("The ByteJump evaluator rule does not appear to be valid (data type is not valid)");
        }
        if (matcher.group(4) != null) {
            String[] otherOptions = matcher.group(4).split(",");
            int c = 0;
            while (c < otherOptions.length) {
                if (otherOptions[c].trim().equalsIgnoreCase("big-endian") || otherOptions[c].trim().equalsIgnoreCase("bigendian")) {
                    byteJump.bigEndian = true;
                } else if (otherOptions[c].trim().equalsIgnoreCase("little-endian") || otherOptions[c].trim().equalsIgnoreCase("littleendian")) {
                    byteJump.bigEndian = false;
                } else if (otherOptions[c].trim().equalsIgnoreCase("hex") || otherOptions[c].trim().equalsIgnoreCase("hexadecimal")) {
                    byteJump.base = 16;
                } else if (otherOptions[c].trim().equalsIgnoreCase("oct") || otherOptions[c].trim().equalsIgnoreCase("octal")) {
                    byteJump.base = 8;
                } else if (otherOptions[c].trim().equalsIgnoreCase("align") || otherOptions[c].trim().equalsIgnoreCase("align-4") || otherOptions[c].trim().equalsIgnoreCase("align4")) {
                    byteJump.alignment = 4;
                } else if (otherOptions[c].trim().equalsIgnoreCase("align8") || otherOptions[c].trim().equalsIgnoreCase("align-8")) {
                    byteJump.alignment = 8;
                } else {
                    throw new InvalidEvaluatorException("The ByteJump evaluator has an invalid option (" + otherOptions[c].trim() + ")");
                }
                ++c;
            }
        }
        if (matcher.group(6) != null) {
            try {
                byteJump.multiplier = Integer.valueOf(matcher.group(6));
            }
            catch (NumberFormatException e) {
                throw new InvalidEvaluatorException("The ByteJump evaluator has an invalid multiplier (" + matcher.group(6) + ")");
            }
        }
        byteJump.checkConfiguration();
        return byteJump;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getBase() {
        return this.base;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    private void checkConfiguration() throws InvalidEvaluatorException {
    }

    @Override
    public int evaluate(DataSpecimen data, int lastMatch, boolean useBasicEncoding) {
        double value;
        int endLocation;
        block8: {
            int start = this.computeStartLocation(lastMatch);
            if (this.dataType == DataType.STRING) {
                String dataString = useBasicEncoding ? data.getBasicEncodedString() : data.getString();
                endLocation = Math.min(dataString.length(), start + this.length);
                String number = dataString.substring(start, endLocation);
                try {
                    value = this.base == 16 ? (double)Integer.valueOf(number, 16).intValue() : (this.base == 8 ? (double)Integer.valueOf(number, 8).intValue() : Double.parseDouble(number));
                    if (value < 0.0) {
                        return -1;
                    }
                    break block8;
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
            byte[] bytes = data.getBytes();
            if (start >= bytes.length) {
                return -1;
            }
            endLocation = start + this.length;
            if (endLocation >= bytes.length) {
                return -1;
            }
            byte[] bytesToBeAnalyzed = new byte[endLocation - start];
            System.arraycopy(bytes, start, bytesToBeAnalyzed, 0, endLocation - start);
            value = this.bigEndian ? ByteJumpEvaluator.getBigEndianValue(bytesToBeAnalyzed) : ByteJumpEvaluator.getLittleEndianValue(bytesToBeAnalyzed);
        }
        int jumpToValue = 0;
        jumpToValue = (int)((double)this.multiplier * value + (double)endLocation);
        if (this.alignment > 1) {
            int add = this.alignment - jumpToValue % this.alignment;
            jumpToValue += add;
        }
        if (jumpToValue > data.getBytesLength()) {
            return -1;
        }
        return jumpToValue;
    }

    @Override
    public Evaluator.ReturnType getReturnType() {
        return Evaluator.ReturnType.BYTE_LOCATION;
    }

    public static enum DataType {
        STRING,
        BYTES;

    }
}

