/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.nio.charset.Charset;
import net.lukemurphey.nsia.MimeType;
import net.lukemurphey.nsia.scan.CharsetDetector;
import net.lukemurphey.nsia.scan.EncodingDetectionFailedException;

public class DataSpecimen {
    private byte[] bytes = null;
    private String string = null;
    private Charset encoding = null;
    private String basicEncodedString = null;
    private String contentType = null;
    private String filename;
    private static byte[] BIGEND_BOM = new byte[]{-2, -1};
    private static byte[] LITTLEEND_BOM = new byte[]{-1, -2};

    public DataSpecimen(byte[] data, String encoding, String filename, String suggestedContentType) {
        Charset encodingCharset;
        if (data == null) {
            throw new IllegalArgumentException("The data cannot be null");
        }
        Charset iso88591 = (Charset)Charset.availableCharsets().get("ISO-8859-1");
        if (encoding == null) {
            try {
                encoding = DataSpecimen.detectedCharacterSet(data);
                encodingCharset = (Charset)Charset.availableCharsets().get(encoding);
                if (encodingCharset == null) {
                    encodingCharset = iso88591;
                }
            }
            catch (EncodingDetectionFailedException e1) {
                encodingCharset = iso88591;
            }
        } else {
            encodingCharset = (Charset)Charset.availableCharsets().get(encoding);
            if (encodingCharset == null) {
                encodingCharset = iso88591;
            }
        }
        this.initialize(data, encodingCharset, filename, suggestedContentType);
        this.contentType = this.computeContentType(filename, data, suggestedContentType);
    }

    public DataSpecimen(byte[] data, String encoding, String filename) {
        Charset encodingCharset;
        if (data == null) {
            throw new IllegalArgumentException("The data cannot be null");
        }
        Charset iso88591 = (Charset)Charset.availableCharsets().get("ISO-8859-1");
        if (encoding == null) {
            try {
                encoding = DataSpecimen.detectedCharacterSet(data);
                encodingCharset = (Charset)Charset.availableCharsets().get(encoding);
                if (encodingCharset == null) {
                    encodingCharset = iso88591;
                }
            }
            catch (EncodingDetectionFailedException e1) {
                encodingCharset = iso88591;
            }
        } else {
            encodingCharset = (Charset)Charset.availableCharsets().get(encoding);
            if (encodingCharset == null) {
                encodingCharset = iso88591;
            }
        }
        this.initialize(data, encodingCharset, filename, null);
        this.contentType = this.computeContentType(filename, data, null);
    }

    public DataSpecimen(byte[] data, String encoding) {
        Charset encodingCharset;
        if (data == null) {
            throw new IllegalArgumentException("The data cannot be null");
        }
        Charset iso88591 = (Charset)Charset.availableCharsets().get("ISO-8859-1");
        if (encoding == null) {
            try {
                encoding = DataSpecimen.detectedCharacterSet(data);
                encodingCharset = (Charset)Charset.availableCharsets().get(encoding);
                if (encodingCharset == null) {
                    encodingCharset = iso88591;
                }
            }
            catch (EncodingDetectionFailedException e1) {
                encodingCharset = iso88591;
            }
        } else {
            encodingCharset = (Charset)Charset.availableCharsets().get(encoding);
            if (encodingCharset == null) {
                encodingCharset = iso88591;
            }
        }
        this.initialize(data, encodingCharset, null, null);
        this.contentType = this.computeContentType(this.filename, data, null);
    }

    public DataSpecimen(byte[] data, boolean rawBytes) {
        if (data == null) {
            throw new IllegalArgumentException("The data cannot be null");
        }
        Charset iso88591 = (Charset)Charset.availableCharsets().get("ISO-8859-1");
        if (rawBytes) {
            this.initialize(data, iso88591, null, null);
        } else {
            Charset encodingCharset;
            try {
                String encoding = DataSpecimen.detectedCharacterSet(data);
                encodingCharset = (Charset)Charset.availableCharsets().get(encoding);
                if (encodingCharset == null) {
                    encodingCharset = iso88591;
                }
            }
            catch (EncodingDetectionFailedException e1) {
                encodingCharset = iso88591;
            }
            this.initialize(data, encodingCharset, null, null);
        }
        this.contentType = this.computeContentType(this.filename, data, null);
    }

    public DataSpecimen(byte[] data) {
        this(data, null);
    }

    public DataSpecimen(String data) {
        Charset encodingCharset;
        if (data == null) {
            throw new IllegalArgumentException("The data cannot be null");
        }
        Charset iso88591 = (Charset)Charset.availableCharsets().get("ISO-8859-1");
        this.string = data;
        this.bytes = data.getBytes();
        try {
            String encoding = DataSpecimen.detectedCharacterSet(this.bytes);
            encodingCharset = (Charset)Charset.availableCharsets().get(encoding);
            if (encodingCharset == null) {
                encodingCharset = iso88591;
            }
        }
        catch (EncodingDetectionFailedException e) {
            encodingCharset = iso88591;
        }
        this.initialize(data, encodingCharset);
        this.contentType = this.computeContentType(null, this.bytes, null);
    }

    private void initialize(byte[] data, Charset encoding, String filename, String contentType) {
        if (data == null) {
            throw new IllegalArgumentException("The data cannot be null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("The character set encoding cannot be null");
        }
        this.bytes = new byte[data.length];
        System.arraycopy(data, 0, this.bytes, 0, Math.min(this.bytes.length, data.length));
        this.string = new String(this.bytes, encoding);
        this.encoding = encoding;
        this.filename = filename;
    }

    private void initialize(String data, Charset encoding) {
        if (data == null) {
            throw new IllegalArgumentException("The data cannot be null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("The character set encoding cannot be null");
        }
        this.string = new String(this.bytes, encoding);
        this.bytes = this.string.getBytes();
        this.encoding = encoding;
    }

    private String computeContentType(String filename, byte[] contents, String suggestedContentType) {
        return MimeType.getMimeType(contents, filename, suggestedContentType);
    }

    public String getString() {
        return this.string;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            this.bytes = this.string.getBytes();
            return (byte[])this.bytes.clone();
        }
        return (byte[])this.bytes.clone();
    }

    public static String detectedCharacterSet(byte[] sample) throws EncodingDetectionFailedException {
        return CharsetDetector.detectCharset(sample);
    }

    public static byte[] subArray(byte[] bytes, int start) {
        return DataSpecimen.subArray(bytes, start, -1);
    }

    public int getStringLength() {
        return this.string.length();
    }

    public int getBytesLength() {
        return this.bytes.length;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public static byte[] subArray(byte[] bytes, int start, int end) {
        if (bytes == null) {
            throw new IllegalArgumentException("The byte array cannot be null");
        }
        if (start < 0) {
            throw new IllegalArgumentException("The start position in the array cannot be 0");
        }
        if (end > -1 && start > end) {
            throw new IllegalArgumentException("The start position must not be greater than the end value");
        }
        if (end > bytes.length - 1) {
            throw new IllegalArgumentException("The end position must not be greater than the number of bytes");
        }
        if (end < 0) {
            end = bytes.length - 1;
        }
        byte[] subset = new byte[end - start + 1];
        System.arraycopy(bytes, start, subset, 0, end - start + 1);
        return subset;
    }

    protected String getSubString(int startAfterByte) {
        if (startAfterByte < 0) {
            throw new IllegalArgumentException("The byte position must be greater than zero");
        }
        BomType bomChars = DataSpecimen.bomCharsType(this.bytes);
        byte[] newBytes = DataSpecimen.subArray(this.getBytes(), startAfterByte + 1);
        if (bomChars == BomType.BIG) {
            byte[] newBytesCorrected = new byte[newBytes.length + 2];
            newBytesCorrected[0] = BIGEND_BOM[0];
            newBytesCorrected[1] = BIGEND_BOM[1];
            System.arraycopy(newBytes, 0, newBytesCorrected, 2, newBytes.length);
            newBytes = newBytesCorrected;
        } else if (bomChars == BomType.LITTLE) {
            byte[] newBytesCorrected = new byte[newBytes.length + 2];
            newBytesCorrected[0] = LITTLEEND_BOM[0];
            newBytesCorrected[1] = LITTLEEND_BOM[1];
            System.arraycopy(newBytes, 0, newBytesCorrected, 2, newBytes.length);
            newBytes = newBytesCorrected;
        } else {
            newBytes = DataSpecimen.subArray(this.getBytes(), startAfterByte + 1);
        }
        if (this.encoding != null) {
            return new String(newBytes, this.encoding);
        }
        return new String(newBytes);
    }

    private static BomType bomCharsType(byte[] bytes) {
        if (bytes[0] == BIGEND_BOM[0] && bytes[1] == BIGEND_BOM[1]) {
            return BomType.BIG;
        }
        if (bytes[0] == LITTLEEND_BOM[0] && bytes[1] == LITTLEEND_BOM[1]) {
            return BomType.LITTLE;
        }
        return BomType.NONE;
    }

    public String getBasicEncodedString() {
        if (this.basicEncodedString == null) {
            Charset iso88591 = (Charset)Charset.availableCharsets().get("ISO-8859-1");
            if (this.encoding == iso88591) {
                this.basicEncodedString = this.string;
                return this.basicEncodedString;
            }
            this.basicEncodedString = new String(this.bytes, iso88591);
            return this.basicEncodedString;
        }
        return this.basicEncodedString;
    }

    public int getByteIndex(int charPosition) {
        return this.getByteIndex(charPosition, false);
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    private int getByteIndex(int charPosition, boolean valueExcludesBom) {
        BomType bomType = DataSpecimen.bomCharsType(this.getBytes());
        if (valueExcludesBom && (bomType == BomType.BIG || bomType == BomType.LITTLE)) {
            ++charPosition;
        }
        String temp = this.getString().substring(0, charPosition + 1);
        byte[] tempBytes = this.encoding != null ? temp.getBytes(this.encoding) : temp.getBytes();
        return tempBytes.length - 1;
    }

    private static enum BomType {
        NONE,
        LITTLE,
        BIG;

    }
}

