/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.script.ScriptException;
import javax.xml.parsers.ParserConfigurationException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.DisallowedOperationException;
import net.lukemurphey.nsia.DuplicateEntryException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.rest.DefinitionsDownload;
import net.lukemurphey.nsia.rest.DefinitionsInfo;
import net.lukemurphey.nsia.rest.RESTRequestFailedException;
import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.DefinitionArchiveException;
import net.lukemurphey.nsia.scan.DefinitionErrorList;
import net.lukemurphey.nsia.scan.DefinitionSet;
import net.lukemurphey.nsia.scan.DefinitionSetLoadException;
import net.lukemurphey.nsia.scan.DefinitionUpdateFailedException;
import net.lukemurphey.nsia.scan.HttpResponseData;
import net.lukemurphey.nsia.scan.InvalidDefinitionException;
import net.lukemurphey.nsia.scan.MetaDefinition;
import net.lukemurphey.nsia.scan.PatternDefinition;
import net.lukemurphey.nsia.scan.ScriptDefinition;
import net.lukemurphey.nsia.scan.UnpurposedDefinitionException;
import org.xml.sax.SAXException;

public class DefinitionArchive {
    public static final int DEFINITION_VERSION = 1;
    private Application application = null;
    private DefinitionSet definitionSet = null;
    private static DefinitionArchive archive = null;

    public static DefinitionArchive getArchive() throws DefinitionSetLoadException, SQLException, NoDatabaseConnectionException, InputValidationException {
        return DefinitionArchive.getArchive(false);
    }

    public static synchronized DefinitionArchive getArchive(boolean ignoreErrors) throws DefinitionSetLoadException, SQLException, NoDatabaseConnectionException, InputValidationException {
        if (archive == null) {
            archive = new DefinitionArchive(Application.getApplication(), ignoreErrors);
        }
        return archive;
    }

    private DefinitionArchive(Application app, boolean ignoreLoadErrors) throws DefinitionSetLoadException, SQLException, NoDatabaseConnectionException, InputValidationException {
        if (app == null) {
            throw new IllegalArgumentException("The application object cannot be null");
        }
        this.application = app;
        if (ignoreLoadErrors) {
            try {
                this.definitionSet = DefinitionArchive.loadDefinitionSet(app);
            }
            catch (DefinitionSetLoadException e) {
                this.definitionSet = new DefinitionSet(new Date(), new Definition[0], null);
            }
        } else {
            this.definitionSet = DefinitionArchive.loadDefinitionSet(app);
        }
    }

    public int getCustomDefinitionsCount() {
        return this.definitionSet.getCustomDefinitionsCount();
    }

    public int getOfficialDefinitionsCount() {
        return this.definitionSet.getOfficialDefinitionsCount();
    }

    public Definition[] getDefinitions() {
        return this.definitionSet.getDefinitions();
    }

    public int getNextOpenID(boolean returnNextOfficial) {
        return this.definitionSet.getNextOpenID(returnNextOfficial);
    }

    public Definition[] getDefinitionsSorted() {
        return this.definitionSet.getDefinitionsSorted();
    }

    public Definition getDefinitionByLocalID(int localId) throws NotFoundException {
        MetaDefinition[] metaDefinitionArray = MetaDefinition.DEFAULT_META_DEFINITIONS;
        int n = MetaDefinition.DEFAULT_META_DEFINITIONS.length;
        int n2 = 0;
        while (n2 < n) {
            MetaDefinition metaSig = metaDefinitionArray[n2];
            if (metaSig.getLocalID() == localId) {
                return metaSig;
            }
            ++n2;
        }
        return this.definitionSet.getDefinitionByLocalID(localId);
    }

    public Definition getDefinition(int officialID) throws NotFoundException {
        MetaDefinition[] metaDefinitionArray = MetaDefinition.DEFAULT_META_DEFINITIONS;
        int n = MetaDefinition.DEFAULT_META_DEFINITIONS.length;
        int n2 = 0;
        while (n2 < n) {
            MetaDefinition metaSig = metaDefinitionArray[n2];
            if (metaSig.getID() == officialID) {
                return metaSig;
            }
            ++n2;
        }
        return this.definitionSet.getDefinition(officialID);
    }

    public Definition getDefinition(String name) throws NotFoundException {
        MetaDefinition[] metaDefinitionArray = MetaDefinition.DEFAULT_META_DEFINITIONS;
        int n = MetaDefinition.DEFAULT_META_DEFINITIONS.length;
        int n2 = 0;
        while (n2 < n) {
            MetaDefinition metaSig = metaDefinitionArray[n2];
            if (metaSig.getFullName().equalsIgnoreCase(name)) {
                return metaSig;
            }
            ++n2;
        }
        return this.definitionSet.getDefinition(name);
    }

    public String getAsXML(boolean includeCustomDefinitionsOnly) {
        return this.definitionSet.getAsXML(includeCustomDefinitionsOnly);
    }

    public String getAsXML() {
        return this.definitionSet.getAsXML();
    }

    public int size() {
        return this.definitionSet.size();
    }

    public DefinitionSet.DefinitionVersionID getVersionID() {
        return this.definitionSet.getVersionID();
    }

    public Date getDefinitionSetDate() {
        return this.definitionSet.getDefinitionSetDate();
    }

    public DefinitionSet getDefinitionSet() {
        return this.definitionSet;
    }

    private static Vector<Definition> loadDefinitions(Connection connection) throws DefinitionSetLoadException, SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Vector<Definition> definitionsVector = new Vector<Definition>();
        try {
            try {
                preparedStatement = connection.prepareStatement("Select * from Definitions order by DefinitionID ASC");
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    int type = resultSet.getInt("Type");
                    Definition contentDefinition = null;
                    try {
                        if (DefinitionSet.DefinitionType.SCRIPT.ordinal() == type) {
                            contentDefinition = ScriptDefinition.parse(resultSet.getString("Code"), resultSet.getInt("DefinitionID"));
                        } else if (DefinitionSet.DefinitionType.PATTERN.ordinal() == type) {
                            contentDefinition = PatternDefinition.parse(resultSet.getString("Code"), resultSet.getInt("DefinitionID"));
                        }
                        definitionsVector.add(contentDefinition);
                    }
                    catch (InvalidDefinitionException e) {
                        throw new DefinitionSetLoadException("Definition is invalid", e);
                    }
                    catch (UnpurposedDefinitionException e) {
                        throw new DefinitionSetLoadException("Definition is invalid (has no purpose)", e);
                    }
                }
            }
            catch (SQLException e) {
                throw new DefinitionSetLoadException("Definition set could not be loaded, SQL exception occured", e);
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return definitionsVector;
    }

    private static DefinitionSet loadDefinitionSet(Application application) throws DefinitionSetLoadException, SQLException, NoDatabaseConnectionException, InputValidationException {
        Connection connection = null;
        try {
            connection = application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            Vector<Definition> definitions = DefinitionArchive.loadDefinitions(connection);
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss Z yyyy");
            DefinitionSet definitionSet = null;
            try {
                definitionSet = !application.getApplicationParameters().doesParameterExist("_DefinitionDate") || !application.getApplicationParameters().doesParameterExist("_DefinitionVersion") || definitions.size() == 0 ? new DefinitionSet(null, definitions, null) : new DefinitionSet(dateFormat.parse(application.getApplicationParameters().getParameter("_DefinitionDate", "")), definitions, application.getApplicationParameters().getParameter("_DefinitionVersion", ""));
            }
            catch (ParseException e) {
                definitionSet = new DefinitionSet(null, definitions, null);
            }
            DefinitionSet definitionSet2 = definitionSet;
            return definitionSet2;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private void saveToDatabase(DefinitionSet definitionSet) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        try {
            connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            int c = 0;
            while (c < definitionSet.size()) {
                this.saveToDatabase(connection, definitionSet.get(c));
                ++c;
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        DefinitionErrorList errors = DefinitionErrorList.load(this.application);
        errors.clearOutdatedErrors(this.definitionSet);
    }

    public int addDefinition(Definition newDefinition) throws SQLException, NoDatabaseConnectionException, DisallowedOperationException, DuplicateEntryException {
        if (newDefinition == null) {
            throw new IllegalArgumentException("The definition to add cannot be null");
        }
        if (newDefinition.getID() <= 0) {
            throw new DisallowedOperationException("The definition must have a valid ID (greater than zero)");
        }
        if (newDefinition.isOfficial()) {
            throw new DisallowedOperationException("A custom definition must have an ID field greater than 1,000,000; IDs less than 1000000 are reserved for definitions from the official set");
        }
        DefinitionArchive definitionArchive = archive;
        synchronized (definitionArchive) {
            int n;
            block11: {
                this.definitionSet.add(newDefinition);
                Connection connection = null;
                try {
                    int localId = -1;
                    if (this.application != null) {
                        connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
                        localId = this.saveToDatabase(connection, newDefinition);
                        DefinitionErrorList errors = DefinitionErrorList.load(this.application);
                        errors.clearOutdatedErrors(this.definitionSet);
                    }
                    newDefinition.localId = localId;
                    n = localId;
                    if (connection == null) break block11;
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        connection.close();
                    }
                    throw throwable;
                }
                connection.close();
            }
            return n;
        }
    }

    public static Date getLatestAvailableDefinitionSetDate() throws IOException, ParseException, RESTRequestFailedException {
        DefinitionsInfo info = new DefinitionsInfo();
        DefinitionSet.DefinitionVersionID version = info.getCurrentDefinitionsVersion();
        if (version != null && version.getRevisionDate() != null) {
            return version.getRevisionDate();
        }
        return null;
    }

    public boolean isNewDefinitionSetAvailable() {
        DefinitionSet.DefinitionVersionID versionID;
        block4: {
            versionID = DefinitionArchive.getLatestAvailableDefinitionSetID();
            if (this.definitionSet.getVersionID() != null) break block4;
            return true;
        }
        try {
            return versionID.revisionID() != this.definitionSet.getVersionID().revisionID();
        }
        catch (RESTRequestFailedException e) {
            Application.getApplication().getEventLog().logEvent(new EventLogMessage(EventLogMessage.EventType.DEFINITION_UPDATE_REQUEST_FAILED));
        }
        catch (IOException e) {
            Application.getApplication().getEventLog().logEvent(new EventLogMessage(EventLogMessage.EventType.DEFINITION_UPDATE_REQUEST_FAILED));
        }
        return false;
    }

    public static String getCurrentDefinitionsAsString(String key) throws DefinitionUpdateFailedException {
        String uniqueInstallID = null;
        try {
            Application.getApplication().getApplicationConfiguration().getUniqueInstallationID();
        }
        catch (InputValidationException e) {
            uniqueInstallID = "";
            Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to get unique installation identifier")), (Throwable)e);
        }
        catch (NoDatabaseConnectionException e) {
            uniqueInstallID = "";
            Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to get unique installation identifier")), (Throwable)e);
        }
        catch (SQLException e) {
            uniqueInstallID = "";
            Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to get unique installation identifier")), (Throwable)e);
        }
        try {
            DefinitionsDownload definitionsDownload = new DefinitionsDownload(uniqueInstallID, key);
            return definitionsDownload.getDefinitionsAsString();
        }
        catch (RESTRequestFailedException e) {
            throw new DefinitionUpdateFailedException(e);
        }
    }

    public DefinitionSet.DefinitionVersionID loadDefaultDefinitions() throws DefinitionUpdateFailedException {
        return this.loadDefaultDefinitions(false);
    }

    public DefinitionSet.DefinitionVersionID loadDefaultDefinitions(boolean loadEvenIfDefsExists) throws DefinitionUpdateFailedException {
        BufferedReader br;
        InputStreamReader isr;
        InputStream in;
        block9: {
            if (!loadEvenIfDefsExists && this.getOfficialDefinitionsCount() > 0) {
                return null;
            }
            in = null;
            isr = null;
            br = null;
            in = DefinitionArchive.class.getResourceAsStream("default_definitions.xml");
            if (in != null) break block9;
            return null;
        }
        try {
            String line;
            isr = new InputStreamReader(in);
            br = new BufferedReader(isr);
            StringBuffer definitionsXmlBuffer = new StringBuffer();
            while ((line = br.readLine()) != null) {
                definitionsXmlBuffer.append(line);
                definitionsXmlBuffer.append("\n");
            }
            DefinitionSet definitionSet = DefinitionSet.loadFromString(definitionsXmlBuffer.toString());
            archive.updateDefinitions(definitionSet, true);
            return definitionSet.getVersionID();
        }
        catch (ParserConfigurationException e) {
            throw new DefinitionUpdateFailedException("Definitions loaded from local resource are corrupted", e);
        }
        catch (SAXException e) {
            throw new DefinitionUpdateFailedException("Error when attempting to parse definitions", e);
        }
        catch (IOException e) {
            throw new DefinitionUpdateFailedException("Error when attempting to load definitions", e);
        }
        catch (DefinitionSetLoadException e) {
            throw new DefinitionUpdateFailedException("Error when attempting to load local definitions", e);
        }
        catch (DefinitionArchiveException e) {
            throw new DefinitionUpdateFailedException("Error when attempting to load local definitions", e);
        }
    }

    public DefinitionSet.DefinitionVersionID updateDefinitions() throws DefinitionUpdateFailedException {
        String definitionsXml;
        block12: {
            String key;
            block11: {
                key = this.application.getApplicationConfiguration().getLicenseKey();
                if (key != null) break block11;
                return null;
            }
            definitionsXml = DefinitionArchive.getCurrentDefinitionsAsString(key);
            if (definitionsXml != null) break block12;
            return null;
        }
        try {
            DefinitionSet definitionSet = DefinitionSet.loadFromString(definitionsXml);
            archive.updateDefinitions(definitionSet, true);
            return definitionSet.getVersionID();
        }
        catch (ParserConfigurationException e) {
            throw new DefinitionUpdateFailedException("Definitions loaded from server are corrupted", e);
        }
        catch (SAXException e) {
            throw new DefinitionUpdateFailedException("Error when attempting to retrieve definition updates from server", e);
        }
        catch (IOException e) {
            throw new DefinitionUpdateFailedException("Error when attempting to retrieve definition updates from server", e);
        }
        catch (DefinitionSetLoadException e) {
            throw new DefinitionUpdateFailedException("Error when attempting to load definition updates from server", e);
        }
        catch (DefinitionArchiveException e) {
            throw new DefinitionUpdateFailedException("Error when attempting to load definition updates from server", e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new DefinitionUpdateFailedException("Could not retrieve license key", e);
        }
        catch (SQLException e) {
            throw new DefinitionUpdateFailedException("Could not retrieve license key", e);
        }
        catch (InputValidationException e) {
            throw new DefinitionUpdateFailedException("License is invalid, load definition updates from server", e);
        }
    }

    public static DefinitionSet.DefinitionVersionID getLatestAvailableDefinitionSetID() throws RESTRequestFailedException, UnknownHostException, IOException {
        DefinitionsInfo info = new DefinitionsInfo();
        DefinitionSet.DefinitionVersionID version = info.getCurrentDefinitionsVersion();
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDefinition(Definition definition, int localId) throws NoDatabaseConnectionException, SQLException, DisallowedOperationException {
        if (definition == null) {
            throw new IllegalArgumentException("The definition to update cannot be null");
        }
        if (definition.isOfficial()) {
            throw new DisallowedOperationException("A custom definition must have an ID field greater than 1,000,000; IDs less than 1000000 are reserved for definitions from the official set");
        }
        Connection connection = null;
        Statement installDefinition = null;
        DefinitionArchive definitionArchive = archive;
        synchronized (definitionArchive) {
            try {
                connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
                installDefinition = connection.prepareStatement("Update Definitions set Category=?, SubCategory=?, Name=?, DefaultMessage=?, AssignedID=?, Version=?, Code=?, Type=? where DefinitionID = ?");
                installDefinition.setString(1, definition.getCategoryName());
                installDefinition.setString(2, definition.getSubCategoryName());
                installDefinition.setString(3, definition.getName());
                installDefinition.setString(4, definition.getMessage());
                installDefinition.setInt(5, definition.getID());
                installDefinition.setInt(6, definition.getRevision());
                if (definition instanceof ScriptDefinition) {
                    ScriptDefinition script = (ScriptDefinition)definition;
                    installDefinition.setString(7, script.getScript());
                    installDefinition.setInt(8, DefinitionSet.DefinitionType.SCRIPT.ordinal());
                } else if (definition instanceof PatternDefinition) {
                    PatternDefinition threatSig = (PatternDefinition)definition;
                    installDefinition.setString(7, threatSig.getRuleCode());
                    installDefinition.setInt(8, DefinitionSet.DefinitionType.PATTERN.ordinal());
                }
                installDefinition.setInt(9, localId);
                if (installDefinition.executeUpdate() > 0) {
                    this.definitionSet.replaceDefinition(definition, localId);
                }
            }
            finally {
                if (installDefinition != null) {
                    installDefinition.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            DefinitionErrorList errors = DefinitionErrorList.load(this.application);
            errors.clearOutdatedErrors(this.definitionSet);
        }
    }

    public void updateDefinition(Definition definition) throws NoDatabaseConnectionException, SQLException, DisallowedOperationException {
        if (definition == null) {
            throw new IllegalArgumentException("The definition to update cannot be null");
        }
        if (definition.localId < 0) {
            throw new IllegalArgumentException("The definition local ID is not valid");
        }
        this.updateDefinition(definition, definition.localId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByID(int ID) throws SQLException, NoDatabaseConnectionException, DisallowedOperationException {
        if (this.application == null) {
            throw new IllegalStateException("The definition set does not have an instance of an application object");
        }
        Connection connection = null;
        Statement deleteStatement = null;
        DefinitionArchive definitionArchive = archive;
        synchronized (definitionArchive) {
            Definition definition = null;
            try {
                definition = archive.getDefinition(ID);
            }
            catch (NotFoundException e) {
                return;
            }
            if (definition != null && definition.isOfficial()) {
                throw new DisallowedOperationException("Definitions from the official set cannot be deleted");
            }
            try {
                connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
                deleteStatement = connection.prepareStatement("Delete from Definitions where DefinitionID = ?");
                deleteStatement.setInt(1, definition.getLocalID());
                deleteStatement.execute();
                if (definition != null) {
                    this.definitionSet.remove(definition);
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
                if (deleteStatement != null) {
                    deleteStatement.close();
                }
            }
            DefinitionErrorList errors = DefinitionErrorList.load(this.application);
            errors.clearOutdatedErrors(this.definitionSet);
        }
    }

    private int saveToDatabase(Connection connection, Definition definition) throws SQLException {
        PreparedStatement installDefinition = null;
        ResultSet resultSet = null;
        int localId = -1;
        try {
            installDefinition = connection.prepareStatement("Insert into Definitions (Category, SubCategory, Name, DefaultMessage, AssignedID, Version, Code, Type) values(?, ?, ?, ?, ?, ?, ?, ?)", 1);
            installDefinition.setString(1, definition.getCategoryName());
            installDefinition.setString(2, definition.getSubCategoryName());
            installDefinition.setString(3, definition.getName());
            installDefinition.setString(4, definition.getMessage());
            installDefinition.setInt(5, definition.getID());
            installDefinition.setInt(6, definition.getRevision());
            if (definition instanceof ScriptDefinition) {
                ScriptDefinition script = (ScriptDefinition)definition;
                installDefinition.setString(7, script.getScript());
                installDefinition.setInt(8, DefinitionSet.DefinitionType.SCRIPT.ordinal());
            } else if (definition instanceof PatternDefinition) {
                PatternDefinition threatSig = (PatternDefinition)definition;
                installDefinition.setString(7, threatSig.getRuleCode());
                installDefinition.setInt(8, DefinitionSet.DefinitionType.PATTERN.ordinal());
            }
            installDefinition.executeUpdate();
            resultSet = installDefinition.getGeneratedKeys();
            if (resultSet.next()) {
                localId = resultSet.getInt(1);
            }
        }
        finally {
            if (installDefinition != null) {
                installDefinition.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return localId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(boolean removeOfficialOnly) throws SQLException, NoDatabaseConnectionException {
        if (this.application == null) {
            throw new IllegalStateException("The definition set does not have an instance of an application object");
        }
        Connection connection = null;
        Statement deleteStatement = null;
        DefinitionArchive definitionArchive = archive;
        synchronized (definitionArchive) {
            try {
                connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
                deleteStatement = removeOfficialOnly ? connection.prepareStatement("Delete from Definitions where AssignedID > -1 and AssignedID < 1000000") : connection.prepareStatement("Delete from Definitions");
                deleteStatement.execute();
                if (removeOfficialOnly) {
                    Iterator<Definition> i = this.definitionSet.iterator();
                    while (i.hasNext()) {
                        Definition definition = i.next();
                        if (definition.getID() <= -1) continue;
                        i.remove();
                    }
                } else {
                    this.definitionSet.clear();
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
                if (deleteStatement != null) {
                    deleteStatement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDefinitions(DefinitionSet definitionSet, boolean replaceOfficialOnly) throws DefinitionArchiveException {
        try {
            if (definitionSet == null) {
                throw new IllegalArgumentException("The definition set to replace the current one cannot be null");
            }
            DefinitionArchive definitionArchive = archive;
            synchronized (definitionArchive) {
                this.application.getApplicationParameters().setParameter("_DefinitionUpdateInProgress", "true");
                SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss Z yyyy");
                if (definitionSet.getDefinitionSetDate() == null) {
                    throw new DefinitionArchiveException("Definition set date is invalid");
                }
                this.application.getApplicationParameters().setParameter("_DefinitionDate", dateFormat.format(definitionSet.getDefinitionSetDate()));
                if (definitionSet.getVersionID() == null) {
                    throw new DefinitionArchiveException("Definition set version identifier is invalid");
                }
                this.application.getApplicationParameters().setParameter("_DefinitionVersion", definitionSet.getVersionID().toString());
                if (definitionSet.size() == 0) {
                    throw new DefinitionArchiveException("Downloaded definition set is invalid (contains no definitions)");
                }
                this.clear(replaceOfficialOnly);
                this.saveToDatabase(definitionSet);
                this.application.getApplicationParameters().setParameter("_DefinitionUpdateInProgress", "false");
                this.definitionSet = DefinitionArchive.loadDefinitionSet(this.application);
            }
        }
        catch (SQLException e) {
            throw new DefinitionArchiveException("Failed to update of definitions", e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new DefinitionArchiveException("Failed to update of definitions", e);
        }
        catch (InputValidationException e) {
            throw new DefinitionArchiveException("Failed to update of definitions", e);
        }
        catch (DefinitionSetLoadException e) {
            throw new DefinitionArchiveException("Failed to update of definitions", e);
        }
    }

    public DefinitionSet.DefinitionMatchResultSet evaluate(HttpResponseData response, Date scanStartTime) throws ScriptException, NoDatabaseConnectionException, SQLException, NoSuchMethodException, InvalidDefinitionException {
        return this.definitionSet.scan(response, scanStartTime);
    }

    public void updateDefinitions(String xmlString, boolean replaceOfficialOnly) throws DefinitionArchiveException {
        try {
            DefinitionSet definitionSet = DefinitionSet.loadFromString(xmlString);
            this.updateDefinitions(definitionSet, replaceOfficialOnly);
        }
        catch (DefinitionSetLoadException e) {
            throw new DefinitionArchiveException("Failed to update the definitions (definitions could not be parsed and loaded)", e);
        }
        catch (SAXException e) {
            throw new DefinitionArchiveException("Failed to update the definitions (definitions could not be parsed and loaded)", e);
        }
        catch (IOException e) {
            throw new DefinitionArchiveException("Failed to update the definitions (definitions could not be parsed and loaded)", e);
        }
        catch (ParserConfigurationException e) {
            throw new DefinitionArchiveException("Failed to update the definitions (definitions could not be parsed and loaded)", e);
        }
    }
}

