/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.MetaDefinition;

public class DefinitionMatch {
    private String definitionName;
    private String message;
    private int definitionID;
    private int detectStart;
    private int detectLength;
    private Definition.Severity severity;

    public DefinitionMatch(String definitionName, String message, Definition.Severity severity, int definitionID, int detectStart, int detectLength) {
        if (definitionName == null) {
            throw new IllegalArgumentException("The definition name cannot be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("The definition message cannot be null");
        }
        this.definitionName = definitionName;
        this.message = message;
        this.definitionID = definitionID;
        this.detectLength = detectLength;
        this.detectStart = detectStart;
        this.severity = severity;
    }

    public DefinitionMatch(String definitionName, String message, Definition.Severity severity, int definitionID) {
        this(definitionName, message, severity, definitionID, -1, -1);
    }

    public DefinitionMatch(MetaDefinition definition) {
        this(definition.getFullName(), definition.getMessage(), definition.getSeverity(), definition.getID(), -1, -1);
    }

    public DefinitionMatch(MetaDefinition definition, String message) {
        this(definition.getFullName(), message, definition.getSeverity(), definition.getID(), -1, -1);
    }

    protected DefinitionMatch(String definitionName, Definition.Severity severity, int definitionID) {
        this.definitionName = definitionName;
        this.definitionID = definitionID;
        this.severity = severity;
    }

    public String getDefinitionName() {
        return this.definitionName;
    }

    public String getMessage() {
        return this.message;
    }

    public Definition.Severity getSeverity() {
        return this.severity;
    }

    public int getDefinitionID() {
        return this.definitionID;
    }

    public int getDetectStart() {
        return this.detectStart;
    }

    public int getDetectLength() {
        return this.detectLength;
    }
}

