/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.MaxMinCount;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.scan.DefinitionPolicyDescriptor;
import net.lukemurphey.nsia.scan.DefinitionPolicySet;
import org.apache.commons.lang.StringEscapeUtils;

public class DefinitionPolicyManagement {
    private Application application = null;

    public DefinitionPolicyManagement(Application application) {
        if (application == null) {
            throw new IllegalArgumentException("The application instance must not be null");
        }
        this.application = application;
    }

    public DefinitionPolicySet getPolicySet() throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
        try {
            DefinitionPolicySet definitionPolicySet = DefinitionPolicySet.getPolicySet(connection);
            return definitionPolicySet;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public DefinitionPolicySet getPolicySet(long siteGroupID) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
        try {
            DefinitionPolicySet definitionPolicySet = DefinitionPolicySet.getPolicySetForSiteGroup(connection, siteGroupID);
            return definitionPolicySet;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public MaxMinCount getScanPolicyInfoForRule(int ruleID, String searchText) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
        try {
            MaxMinCount maxMinCount = DefinitionPolicySet.getScanPolicyInfoForRule(connection, ruleID, searchText);
            return maxMinCount;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public DefinitionPolicySet getPolicySetForRule(int ruleID, int recordCount, int page, String searchText) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
        try {
            DefinitionPolicySet definitionPolicySet = DefinitionPolicySet.getPolicySetForRule(connection, ruleID, recordCount, page, searchText);
            return definitionPolicySet;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public DefinitionPolicySet getPolicySetForRule(int ruleID, int recordCount, int page) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
        try {
            DefinitionPolicySet definitionPolicySet = DefinitionPolicySet.getPolicySetForRule(connection, ruleID, recordCount, page);
            return definitionPolicySet;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public DefinitionPolicySet getPolicySetForRule(int ruleID) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
        try {
            DefinitionPolicySet definitionPolicySet = DefinitionPolicySet.getPolicySetForRule(connection, ruleID);
            return definitionPolicySet;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public DefinitionPolicyDescriptor getPolicy(int policyID) throws SQLException, MalformedURLException, NoDatabaseConnectionException {
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        DefinitionPolicyDescriptor sigException = null;
        try {
            connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Select * from DefinitionPolicy where DefinitionPolicyID = ?");
            statement.setLong(1, policyID);
            result = statement.executeQuery();
            if (result.next()) {
                sigException = DefinitionPolicyDescriptor.loadFromResult(result);
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
            if (result != null) {
                result.close();
            }
        }
        return sigException;
    }

    public int clearCategoryDescriptors(int siteGroupID, String categoryName) throws NoDatabaseConnectionException, SQLException {
        return this.clearEntries(siteGroupID, -1, null, null, null, categoryName);
    }

    public int clearCategoryDescriptors(SiteGroupManagement.SiteGroupDescriptor siteGroup, String categoryName) throws NoDatabaseConnectionException, SQLException {
        return this.clearEntries(siteGroup.getGroupId(), -1, null, null, null, categoryName);
    }

    public int clearSubCategoryDescriptors(String categoryName, String subCategoryName) throws NoDatabaseConnectionException, SQLException {
        return this.clearEntries(-1, -1, null, subCategoryName, null, categoryName);
    }

    public int clearSubCategoryDescriptors(int siteGroupID, String categoryName, String subCategoryName) throws NoDatabaseConnectionException, SQLException {
        return this.clearEntries(siteGroupID, -1, null, subCategoryName, null, categoryName);
    }

    public int clearSubCategoryDescriptors(SiteGroupManagement.SiteGroupDescriptor siteGroup, String categoryName, String subCategoryName) throws NoDatabaseConnectionException, SQLException {
        return this.clearEntries(siteGroup.getGroupId(), -1, null, subCategoryName, null, categoryName);
    }

    private int clearEntries(int siteGroupId, int ruleID, String definitionName, String definitionSubCategory, URL url, String definitionCategory) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            StringBuffer whereClause = new StringBuffer();
            if (siteGroupId < 0) {
                whereClause.append(" (SiteGroupID is null or SiteGroupID = -1) and ");
            } else {
                whereClause.append(" SiteGroupID = ");
                whereClause.append(siteGroupId);
                whereClause.append(" and");
            }
            if (ruleID < 0) {
                whereClause.append(" (RuleID = -1 or RuleID is null) and ");
            } else {
                whereClause.append(" RuleID = ");
                whereClause.append(ruleID);
                whereClause.append(" and");
            }
            if (definitionName == null) {
                whereClause.append(" DefinitionName is null and ");
            } else {
                whereClause.append(" DefinitionName = '");
                whereClause.append(StringEscapeUtils.escapeSql((String)definitionName));
                whereClause.append("' and");
            }
            if (definitionSubCategory == null) {
                whereClause.append(" DefinitionSubCategory is null and ");
            } else {
                whereClause.append(" DefinitionSubCategory = '");
                whereClause.append(StringEscapeUtils.escapeSql((String)definitionSubCategory));
                whereClause.append("' and");
            }
            if (definitionCategory == null) {
                whereClause.append(" DefinitionCategory is null and ");
            } else {
                whereClause.append(" DefinitionCategory = '");
                whereClause.append(StringEscapeUtils.escapeSql((String)definitionCategory));
                whereClause.append("' and");
            }
            if (url == null) {
                whereClause.append(" URL is null ");
            } else {
                whereClause.append(" URL = '");
                whereClause.append(StringEscapeUtils.escapeSql((String)url.toExternalForm()));
                whereClause.append("'");
            }
            statement = connection.prepareStatement("delete from DefinitionPolicy where " + whereClause.toString());
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public boolean deletePolicy(int policyID) throws NoDatabaseConnectionException, SQLException {
        if (policyID < 1) {
            throw new IllegalArgumentException("The exception ID must be greater than 0");
        }
        Connection conn = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement("Delete from DefinitionPolicy where DefinitionPolicyID = ?");
            preparedStatement.setLong(1, policyID);
            return preparedStatement.executeUpdate() == 1;
            {
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }
}

