/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.util.Vector;
import net.lukemurphey.nsia.scan.DataSpecimen;

public abstract class Evaluator {
    public static final int UNDEFINED = -1;
    protected int depth = -1;
    protected int position = -1;
    protected int offset = -1;
    protected int within = -1;
    protected boolean negation = false;
    protected boolean nocase = false;
    protected boolean rawbytes = false;
    protected OffsetRelativity offsetRelativity = OffsetRelativity.UNDEFINED;

    public void setDepth(int maxDepth) {
        this.depth = maxDepth;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setOffset(int offset) {
        this.setOffset(offset, OffsetRelativity.UNDEFINED);
    }

    public void setOffset(int offset, OffsetRelativity offsetType) {
        if (offsetType == null) {
            this.offsetRelativity = OffsetRelativity.UNDEFINED;
        }
        this.offsetRelativity = offsetType;
        this.offset = offset;
    }

    public abstract ReturnType getReturnType();

    public void setWithin(int within) {
        this.within = within;
    }

    public void setNegation(boolean negate) {
        this.negation = negate;
    }

    protected void setIgnoreCase(boolean ignoreCase) {
        this.nocase = ignoreCase;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getWithin() {
        return this.within;
    }

    public boolean matchWhenNotFound() {
        return this.negation;
    }

    protected boolean getIgnoreCase() {
        return this.nocase;
    }

    protected int computeStartLocation(int lastMatch) {
        if (this.offsetRelativity == OffsetRelativity.ABSOLUTE) {
            return this.offset;
        }
        int startLocation = 0;
        if (this.offset > 0) {
            startLocation += this.offset;
        }
        if (lastMatch >= 0) {
            startLocation += lastMatch + 1;
        }
        return startLocation;
    }

    public int evaluate(byte[] data) {
        return this.evaluate(new DataSpecimen(data), -1);
    }

    public int evaluate(String data) {
        return this.evaluate(new DataSpecimen(data), -1);
    }

    public int evaluate(byte[] data, int lastMatch) {
        return this.evaluate(new DataSpecimen(data), lastMatch);
    }

    public int evaluate(String data, int lastMatch) {
        return this.evaluate(new DataSpecimen(data), lastMatch);
    }

    public int evaluate(DataSpecimen data) {
        return this.evaluate(data, -1);
    }

    public abstract int evaluate(DataSpecimen var1, int var2, boolean var3);

    public int evaluate(DataSpecimen data, int lastMatch) {
        return this.evaluate(data, lastMatch, false);
    }

    public boolean isRelative() {
        return this.offsetRelativity != OffsetRelativity.ABSOLUTE && (this.getOffset() != -1 || this.getWithin() != -1);
    }

    protected static boolean isSequenceStart(int location, Evaluator[] evaluators) {
        if (evaluators == null) {
            throw new IllegalArgumentException("The list of evaluators must not be null");
        }
        if (location >= evaluators.length) {
            return false;
        }
        return evaluators[location + 1].isRelative();
    }

    protected static boolean isSequenceStart(int location, Vector<Evaluator> evaluators) {
        if (evaluators == null) {
            throw new IllegalArgumentException("The list of evaluators must not be null");
        }
        if (location >= evaluators.size()) {
            return false;
        }
        return evaluators.get(location + 1).isRelative() && (!evaluators.get(location).isRelative() || location == 0);
    }

    protected static boolean isRelative(int c, Evaluator[] evaluators) {
        if (evaluators == null) {
            throw new IllegalArgumentException("The list of evaluators must not be null");
        }
        if (c >= evaluators.length) {
            return false;
        }
        Evaluator evaluator = evaluators[c + 1];
        return evaluator.getOffset() != -1 || evaluator.getWithin() != -1;
    }

    public static double getBigEndianValue(byte[] bytes) {
        double value = 0.0;
        int c = 0;
        while (c < bytes.length) {
            value += (double)Evaluator.getUnsignedValue(bytes[c]) * Math.pow(256.0, bytes.length - c - 1);
            ++c;
        }
        return value;
    }

    public static double getLittleEndianValue(byte[] bytes) {
        double value = 0.0;
        int c = 0;
        while (c < bytes.length) {
            value += (double)Evaluator.getUnsignedValue(bytes[c]) * Math.pow(256.0, c);
            ++c;
        }
        return value;
    }

    public static int getUnsignedValue(byte value) {
        if (value >= 0) {
            return value;
        }
        return 383 + value;
    }

    public static enum OffsetRelativity {
        ABSOLUTE,
        RELATIVE,
        UNDEFINED;

    }

    public static enum ReturnType {
        BYTE_LOCATION,
        CHARACTER_LOCATION;

    }
}

