/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.DefinitionMatch;
import net.lukemurphey.nsia.scan.DefinitionPolicyManagement;
import net.lukemurphey.nsia.scan.DefinitionPolicySet;
import net.lukemurphey.nsia.scan.DefinitionSet;
import net.lukemurphey.nsia.scan.HttpDefinitionScanResult;
import net.lukemurphey.nsia.scan.HttpResponseData;
import net.lukemurphey.nsia.scan.InvalidDefinitionException;
import net.lukemurphey.nsia.scan.MetaDefinition;
import net.lukemurphey.nsia.scan.ScanException;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanResultCode;
import net.lukemurphey.nsia.scan.ScanRule;
import net.lukemurphey.nsia.scan.URLToScan;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.lang.StringUtils;
import org.htmlparser.Parser;
import org.htmlparser.util.ParserException;

public class HttpDefinitionScanRule
extends ScanRule {
    private URL url = null;
    private DefinitionSet signatureSet = null;
    public static final String RULE_TYPE = "HTTP/SignatureScan";
    private static MultiThreadedHttpConnectionManager connectionManager = null;
    private HttpClient httpClient = null;
    private boolean waitToLogCompletion = false;
    private HttpMethod httpMethod = null;
    private boolean terminated = false;
    private Object httpMethodMutex = new Object();

    HttpDefinitionScanRule(Application applicationResources, DefinitionSet signatureSet, URL url) {
        super(applicationResources);
        this.url = url;
        this.signatureSet = signatureSet;
    }

    HttpDefinitionScanRule(Application applicationResources, DefinitionSet signatureSet, URL url, HttpClient client) {
        super(applicationResources);
        this.url = url;
        this.signatureSet = signatureSet;
        this.httpClient = client;
    }

    @Override
    public void delete() throws SQLException, NoDatabaseConnectionException {
        HttpDefinitionScanRule.deleteRule(this.scanRuleId);
    }

    protected void suppressLoggingToEventLog(boolean suppress) {
        this.waitToLogCompletion = suppress;
    }

    public static synchronized MultiThreadedHttpConnectionManager getConnectionManager() {
        if (connectionManager == null) {
            connectionManager = new MultiThreadedHttpConnectionManager();
            HttpConnectionManagerParams params = new HttpConnectionManagerParams();
            params.setMaxTotalConnections(100);
            params.setConnectionTimeout(60000);
            params.setSoTimeout(60000);
            connectionManager.setParams(params);
        }
        return connectionManager;
    }

    private String escapeURL(String url) {
        String result = url;
        result = StringUtils.replace((String)result, (String)" ", (String)"%20");
        result = StringUtils.replace((String)result, (String)"<", (String)"%3C");
        result = StringUtils.replace((String)result, (String)">", (String)"%3E");
        result = StringUtils.replace((String)result, (String)"\"", (String)"%22");
        result = StringUtils.replace((String)result, (String)"'", (String)"%27");
        result = StringUtils.replace((String)result, (String)",", (String)"%2C");
        result = StringUtils.replace((String)result, (String)":", (String)"%3A");
        result = StringUtils.replace((String)result, (String)"\\", (String)"/");
        return result;
    }

    public HttpSignatureScanResultWithParser doScanAndReturnParser(HttpDefinitionScanResult parentScanResult, Date parentRuleScanStartDate) throws ScanException {
        return this.doScanInternal(parentScanResult, parentRuleScanStartDate);
    }

    @Override
    public ScanResult doScan() throws ScanException {
        HttpSignatureScanResultWithParser result = this.doScanInternal(null, new Date());
        return result.scanResult;
    }

    private DefinitionPolicySet loadSignatureExceptions(long siteGroupID) throws SQLException, NoDatabaseConnectionException {
        DefinitionPolicyManagement signatureManagement = new DefinitionPolicyManagement(this.appRes);
        if (this.scanRuleId > -1L) {
            try {
                siteGroupID = ScanRule.getAssociatedSiteGroupID(this.scanRuleId);
                return signatureManagement.getPolicySet(siteGroupID);
            }
            catch (NotFoundException e) {
                return signatureManagement.getPolicySet();
            }
        }
        return signatureManagement.getPolicySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponseData getResponseData(URL url, HttpClient client) throws HttpException, IOException {
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost(url.getHost(), url.getPort(), url.getProtocol());
        try {
            HttpClient httpClient;
            Object object = this.httpMethodMutex;
            synchronized (object) {
                this.httpMethod = new GetMethod(this.escapeURL(url.getPath()));
                this.httpMethod.setFollowRedirects(true);
                httpClient = client == null ? new HttpClient() : client;
            }
            httpClient.executeMethod(hostConfig, this.httpMethod);
            HttpResponseData httpResponse = new HttpResponseData(this.httpMethod, url.toString());
            this.httpMethod.releaseConnection();
            HttpResponseData httpResponseData = httpResponse;
            return httpResponseData;
        }
        finally {
            if (this.httpMethod != null) {
                this.httpMethod.releaseConnection();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private HttpSignatureScanResultWithParser doScanInternal(HttpDefinitionScanResult parentResult, Date ruleScanStartDate) throws ScanException {
        DefinitionPolicySet signatureExceptions = null;
        long siteGroupID = -1L;
        try {
            Vector<URLToScan> extractedURLs;
            Vector<Object> results;
            block31: {
                if (this.scanRuleId > -1L) {
                    try {
                        siteGroupID = ScanRule.getAssociatedSiteGroupID(this.scanRuleId);
                    }
                    catch (NotFoundException e) {
                        siteGroupID = -1L;
                    }
                }
                signatureExceptions = this.loadSignatureExceptions(siteGroupID);
                results = new Vector<DefinitionMatch>();
                extractedURLs = null;
                try {
                    HttpResponseData httpResponse;
                    try {
                        httpResponse = this.getResponseData(this.url, this.httpClient);
                    }
                    catch (IllegalArgumentException e) {
                        if (signatureExceptions != null && signatureExceptions.isFiltered(siteGroupID, this.scanRuleId, (Definition)MetaDefinition.INVALID_URI, this.url)) {
                            return new HttpSignatureScanResultWithParser(new HttpDefinitionScanResult(ScanResultCode.SCAN_COMPLETED, new Timestamp(System.currentTimeMillis()), this.url, this.scanRuleId), null);
                        }
                        if (parentResult != null && parentResult.getSpecimenDescription() != null) {
                            this.logDefinitionMatch(MetaDefinition.INVALID_URI.getFullName(), MetaDefinition.INVALID_URI.getID(), this.getSpecimenDescription(), this.scanRuleId, MetaDefinition.INVALID_URI.getSeverity(), String.valueOf(MetaDefinition.INVALID_URI.getMessage()) + "; URI loaded from " + parentResult.getSpecimenDescription());
                            return new HttpSignatureScanResultWithParser(new HttpDefinitionScanResult(ScanResultCode.SCAN_FAILED, new Timestamp(System.currentTimeMillis()), this.url, new DefinitionMatch(MetaDefinition.INVALID_URI, String.valueOf(MetaDefinition.INVALID_URI.getMessage()) + "; URI loaded from " + parentResult.getSpecimenDescription()), this.scanRuleId), null);
                        }
                        this.logDefinitionMatch(MetaDefinition.INVALID_URI.getFullName(), MetaDefinition.INVALID_URI.getID(), this.getSpecimenDescription(), this.scanRuleId, MetaDefinition.INVALID_URI.getSeverity(), MetaDefinition.INVALID_URI.getMessage());
                        return new HttpSignatureScanResultWithParser(new HttpDefinitionScanResult(ScanResultCode.SCAN_FAILED, new Timestamp(System.currentTimeMillis()), this.url, new DefinitionMatch(MetaDefinition.INVALID_URI, MetaDefinition.INVALID_URI.getMessage()), this.scanRuleId), null);
                    }
                    if (this.terminated) {
                        return new HttpSignatureScanResultWithParser(new HttpDefinitionScanResult(ScanResultCode.SCAN_COMPLETED, new Timestamp(System.currentTimeMillis()), this.url, this.scanRuleId), null);
                    }
                    Parser parser = null;
                    try {
                        parser = httpResponse.getDocumentParser();
                    }
                    catch (ParserException e) {
                        parser = null;
                    }
                    DefinitionSet.DefinitionMatchResultSet resultSet = this.signatureSet.scan(httpResponse, signatureExceptions, siteGroupID, this.scanRuleId, ruleScanStartDate);
                    results = resultSet.getDefinitionMatches();
                    extractedURLs = resultSet.getExtractedURLs();
                    if (results == null) {
                        results = new Vector();
                    } else {
                        for (DefinitionMatch definitionMatch : results) {
                            this.logDefinitionMatch(definitionMatch.getDefinitionName(), definitionMatch.getDefinitionID(), this.getSpecimenDescription(), this.scanRuleId, definitionMatch.getSeverity(), definitionMatch.getMessage());
                        }
                    }
                    MetaDefinition metaDefinition = this.getMetaSignatureFromResponseCode(httpResponse.getResponseCode());
                    if (!(metaDefinition == null || signatureExceptions != null && signatureExceptions.isFiltered(siteGroupID, this.scanRuleId, (Definition)metaDefinition, this.url))) {
                        void var11_28;
                        if (parentResult != null) {
                            MetaDefinition metaDefinition2 = metaDefinition.createNewWithMessage("; referenced from " + parentResult.getSpecimenDescription());
                            if (metaDefinition2.localId == MetaDefinition.CONNECTION_FAILED.localId || metaDefinition2.localId == MetaDefinition.CONNECTION_REFUSED.localId || metaDefinition2.localId == MetaDefinition.CONNECTION_TIMEOUT.localId || metaDefinition2.localId == MetaDefinition.NO_DATA.localId || metaDefinition2.localId == MetaDefinition.RESPONSE_CODE_404.localId || metaDefinition2.localId == MetaDefinition.RESPONSE_CODE_405.localId || metaDefinition2.localId == MetaDefinition.RESPONSE_CODE_406.localId || metaDefinition2.localId == MetaDefinition.RESPONSE_CODE_409.localId || metaDefinition2.localId == MetaDefinition.RESPONSE_CODE_410.localId || metaDefinition2.localId == MetaDefinition.RESPONSE_CODE_414.localId || metaDefinition2.localId == MetaDefinition.RESPONSE_CODE_415.localId) {
                                parentResult.addBrokenLink(this.getSpecimenDescription());
                            }
                        }
                        this.logDefinitionMatch((Definition)var11_28, this.getSpecimenDescription(), this.scanRuleId);
                        results.add(new DefinitionMatch((MetaDefinition)var11_28));
                    }
                    if (results.size() > 0) {
                        this.logScanResult(ScanResultCode.SCAN_COMPLETED, results.size(), "HTTP/Autodiscovery", this.url.toString(), String.valueOf(results.size()) + " definitions matched", !this.waitToLogCompletion);
                        return new HttpSignatureScanResultWithParser(new HttpDefinitionScanResult(ScanResultCode.SCAN_COMPLETED, new Timestamp(System.currentTimeMillis()), this.url, results, this.scanRuleId, httpResponse.getContentType()), parser, httpResponse.getResponseCode(), resultSet.getExtractedURLs());
                    }
                    this.logScanResult(ScanResultCode.SCAN_COMPLETED, 0, "HTTP/Autodiscovery", this.url.toString(), "0 definitions matched", !this.waitToLogCompletion);
                    return new HttpSignatureScanResultWithParser(new HttpDefinitionScanResult(ScanResultCode.SCAN_COMPLETED, new Timestamp(System.currentTimeMillis()), this.url, results, this.scanRuleId, httpResponse.getContentType()), parser, httpResponse.getResponseCode(), resultSet.getExtractedURLs());
                }
                catch (InvalidDefinitionException e) {
                    this.appRes.logExceptionEvent(EventLogMessage.EventType.SCAN_ENGINE_EXCEPTION, (Throwable)e);
                    throw new ScanException("Scan failed: InvalidSignatureException (" + e.getMessage() + ")", e);
                }
                catch (HttpException e) {
                    boolean isRedirectLoop = e.getMessage().startsWith("Circular redirect");
                    boolean maxRedirects = e.getMessage().startsWith("Maximum redirects");
                    if (isRedirectLoop && (signatureExceptions == null || !signatureExceptions.isFiltered(siteGroupID, this.scanRuleId, (Definition)MetaDefinition.REDIRECT_LOOP, this.url))) {
                        results.add(new DefinitionMatch(MetaDefinition.REDIRECT_LOOP, e.getMessage()));
                    } else if (maxRedirects && (signatureExceptions == null || !signatureExceptions.isFiltered(siteGroupID, this.scanRuleId, (Definition)MetaDefinition.REDIRECT_LIMIT_EXCEEDED, this.url))) {
                        results.add(new DefinitionMatch(MetaDefinition.REDIRECT_LIMIT_EXCEEDED, e.getMessage()));
                    } else if (!(isRedirectLoop || signatureExceptions != null && signatureExceptions.isFiltered(siteGroupID, this.scanRuleId, (Definition)MetaDefinition.HTTP_EXCEPTION, this.url))) {
                        results.add(new DefinitionMatch(MetaDefinition.HTTP_EXCEPTION, e.getMessage()));
                    }
                }
                catch (IOException e) {
                    Pattern isTimeoutRegex = Pattern.compile(".*time.*out.*", 2);
                    Matcher isTimeoutMatcher = isTimeoutRegex.matcher(e.getMessage());
                    boolean bl = isTimeoutMatcher.matches();
                    Pattern isRefusedRegex = Pattern.compile("(refuse)|(reject)", 2);
                    Matcher isRefusedMatcher = isRefusedRegex.matcher(e.getMessage());
                    boolean isRefused = isRefusedMatcher.matches();
                    if (bl && (signatureExceptions == null || !signatureExceptions.isFiltered(siteGroupID, this.scanRuleId, (Definition)MetaDefinition.CONNECTION_TIMEOUT, this.url))) {
                        results.add(new DefinitionMatch(MetaDefinition.CONNECTION_TIMEOUT, String.valueOf(MetaDefinition.CONNECTION_TIMEOUT.getMessage()) + ":" + e.getMessage()));
                    }
                    if (isRefused && (signatureExceptions == null || !signatureExceptions.isFiltered(siteGroupID, this.scanRuleId, (Definition)MetaDefinition.CONNECTION_REFUSED, this.url))) {
                        results.add(new DefinitionMatch(MetaDefinition.CONNECTION_REFUSED, String.valueOf(MetaDefinition.CONNECTION_TIMEOUT.getMessage()) + ":" + e.getMessage()));
                    }
                    if (isRefused || bl || signatureExceptions != null && signatureExceptions.isFiltered(siteGroupID, this.scanRuleId, (Definition)MetaDefinition.CONNECTION_FAILED, this.url)) break block31;
                    results.add(new DefinitionMatch(MetaDefinition.CONNECTION_FAILED, String.valueOf(MetaDefinition.CONNECTION_TIMEOUT.getMessage()) + ":" + e.getMessage()));
                }
            }
            this.logScanResult(ScanResultCode.SCAN_COMPLETED, results.size(), "HTTP/Autodiscovery", this.url.toString());
            HttpDefinitionScanResult httpDefScanResult = new HttpDefinitionScanResult(ScanResultCode.SCAN_COMPLETED, new Timestamp(System.currentTimeMillis()), this.url, results, this.scanRuleId);
            return new HttpSignatureScanResultWithParser(httpDefScanResult, null, extractedURLs);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new ScanException("Scan failed: NoDatabaseConnectionException", e);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new ScanException("Scan failed: SQLException", e);
        }
    }

    private void logDefinitionMatch(String signatureName, int signatureID, String url, long ruleID, Definition.Severity severity) {
        this.logDefinitionMatch(signatureName, signatureID, url, ruleID, severity, null);
    }

    private void logDefinitionMatch(String signatureName, int signatureID, String url, long ruleID, Definition.Severity severity, String definitionOutput) {
        if (this.appRes != null) {
            EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.DEFINITION_MATCH);
            message.addField(new EventLogField(EventLogField.FieldName.DEFINITION_NAME, signatureName));
            if (signatureID > -1) {
                message.addField(new EventLogField(EventLogField.FieldName.DEFINITION_ID, signatureID));
            }
            message.addField(new EventLogField(EventLogField.FieldName.SEVERITY, severity.toString()));
            message.addField(new EventLogField(EventLogField.FieldName.URL, url));
            if (definitionOutput != null) {
                message.addField(new EventLogField(EventLogField.FieldName.DEFINITION_MESSAGE, definitionOutput));
            }
            if (ruleID > -1L) {
                message.addField(new EventLogField(EventLogField.FieldName.RULE_ID, ruleID));
            }
            this.appRes.logEvent(message);
        }
    }

    private void logDefinitionMatch(Definition sig, String url, long ruleID) {
        this.logDefinitionMatch(sig.getFullName(), sig.id, url, ruleID, sig.getSeverity());
    }

    private MetaDefinition getMetaSignatureFromResponseCode(int responseCode) {
        switch (responseCode) {
            case 400: {
                return MetaDefinition.RESPONSE_CODE_400;
            }
            case 401: {
                return MetaDefinition.RESPONSE_CODE_401;
            }
            case 402: {
                return MetaDefinition.RESPONSE_CODE_402;
            }
            case 403: {
                return MetaDefinition.RESPONSE_CODE_403;
            }
            case 404: {
                return MetaDefinition.RESPONSE_CODE_404;
            }
            case 405: {
                return MetaDefinition.RESPONSE_CODE_405;
            }
            case 406: {
                return MetaDefinition.RESPONSE_CODE_406;
            }
            case 407: {
                return MetaDefinition.RESPONSE_CODE_407;
            }
            case 408: {
                return MetaDefinition.RESPONSE_CODE_408;
            }
            case 409: {
                return MetaDefinition.RESPONSE_CODE_409;
            }
            case 410: {
                return MetaDefinition.RESPONSE_CODE_410;
            }
            case 411: {
                return MetaDefinition.RESPONSE_CODE_411;
            }
            case 412: {
                return MetaDefinition.RESPONSE_CODE_412;
            }
            case 413: {
                return MetaDefinition.RESPONSE_CODE_413;
            }
            case 414: {
                return MetaDefinition.RESPONSE_CODE_414;
            }
            case 415: {
                return MetaDefinition.RESPONSE_CODE_415;
            }
            case 416: {
                return MetaDefinition.RESPONSE_CODE_416;
            }
            case 417: {
                return MetaDefinition.RESPONSE_CODE_417;
            }
            case 500: {
                return MetaDefinition.RESPONSE_CODE_500;
            }
            case 501: {
                return MetaDefinition.RESPONSE_CODE_501;
            }
            case 502: {
                return MetaDefinition.RESPONSE_CODE_502;
            }
            case 503: {
                return MetaDefinition.RESPONSE_CODE_503;
            }
            case 504: {
                return MetaDefinition.RESPONSE_CODE_504;
            }
            case 505: {
                return MetaDefinition.RESPONSE_CODE_505;
            }
        }
        return null;
    }

    @Override
    public String getRuleType() {
        return RULE_TYPE;
    }

    @Override
    public String getSpecimenDescription() {
        return this.url.toExternalForm();
    }

    @Override
    public boolean loadFromDatabase(long scanRuleId) throws NotFoundException, NoDatabaseConnectionException, SQLException, ScanRule.ScanRuleLoadFailureException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.terminated = true;
        if (this.httpMethod != null) {
            Object object = this.httpMethodMutex;
            synchronized (object) {
                this.httpMethod.abort();
            }
        }
    }

    @Override
    public ScanResult loadScanResult(long scanResultId) throws NotFoundException, NoDatabaseConnectionException, SQLException, ScanRule.ScanResultLoadFailureException {
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Select * from ScanResult where ScanResultID = ?");
            statement.setLong(1, scanResultId);
            result = statement.executeQuery();
            if (!result.next()) {
                return null;
            }
            ScanResultCode resultCode = ScanResultCode.getScanResultCodeById(result.getInt("ScanResultCode"));
            if (resultCode == null) {
                return null;
            }
            Timestamp scanDate = result.getTimestamp("ScanDate");
            long ruleId = result.getLong("ScanRuleID");
            statement.close();
            result.close();
            statement = null;
            result = null;
            statement = connection.prepareStatement("Select * from SignatureScanResult where ScanResultID = ?");
            statement.setLong(1, scanResultId);
            result = statement.executeQuery();
            if (result.next()) {
                String url = result.getString("URL");
                this.url = new URL(url);
                String contentType = result.getString("ContentType");
                Vector<DefinitionMatch> sigMatchesVector = HttpDefinitionScanResult.loadSignatureMatches(scanResultId, Application.getApplication());
                HttpDefinitionScanResult httpDefinitionScanResult = new HttpDefinitionScanResult(resultCode, scanDate, new URL(url), sigMatchesVector, ruleId, contentType);
                return httpDefinitionScanResult;
            }
            return null;
        }
        catch (MalformedURLException e) {
            throw new ScanRule.ScanResultLoadFailureException("The scan result could not be loaded because the URL is malformed", e);
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    protected static class HttpSignatureScanResultWithParser {
        private HttpDefinitionScanResult scanResult;
        private Parser parser;
        private int httpResponseCode = -1;
        private Vector<URLToScan> extractedURLs = new Vector();

        public HttpSignatureScanResultWithParser(HttpDefinitionScanResult scanResult, Parser parser) {
            this.scanResult = scanResult;
            this.parser = parser;
        }

        public HttpSignatureScanResultWithParser(HttpDefinitionScanResult scanResult, Parser parser, int httpResponseCode) {
            this.scanResult = scanResult;
            this.parser = parser;
            this.httpResponseCode = httpResponseCode;
        }

        public HttpSignatureScanResultWithParser(HttpDefinitionScanResult scanResult, Parser parser, Vector<URLToScan> extractedURLs) {
            this.scanResult = scanResult;
            this.parser = parser;
            this.addExtractedURLs(extractedURLs);
        }

        public HttpSignatureScanResultWithParser(HttpDefinitionScanResult scanResult, Parser parser, int httpResponseCode, Vector<URLToScan> extractedURLs) {
            this.scanResult = scanResult;
            this.parser = parser;
            this.httpResponseCode = httpResponseCode;
            this.addExtractedURLs(extractedURLs);
        }

        private void addExtractedURLs(Vector<URLToScan> extractedURLs) {
            if (extractedURLs != null) {
                this.extractedURLs.addAll(extractedURLs);
            }
        }

        public HttpDefinitionScanResult getScanResult() {
            return this.scanResult;
        }

        public Parser getParser() {
            return this.parser;
        }

        public int getHttpResponseCode() {
            return this.httpResponseCode;
        }

        public Vector<URLToScan> getExtractedURLs(boolean urlsThatApplyToDomainLimitOnly) {
            return this.extractedURLs;
        }

        public Vector<URL> getExtractedURLsDomainUnlimited() {
            Vector<URL> urls = new Vector<URL>();
            for (URLToScan url : this.extractedURLs) {
                if (!url.ignoreDomainRestriction()) continue;
                urls.add(url.getURL());
            }
            return urls;
        }

        public Vector<URL> getExtractedURLsDomainLimited() {
            Vector<URL> urls = new Vector<URL>();
            for (URLToScan url : this.extractedURLs) {
                if (url.ignoreDomainRestriction()) continue;
                urls.add(url.getURL());
            }
            return urls;
        }
    }
}

