/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.Wildcard;

public class HttpHeaderRule {
    public static final int VALUE_NOT_SET = -1;
    public static final int RULE_TYPE_REGEX = 0;
    public static final int RULE_TYPE_STRING = 1;
    public static final int RULE_TYPE_WILDCARD = 2;
    private Pattern headerNamePattern = null;
    private Pattern headerValuePattern = null;
    private String headerNameString = null;
    private String headerValueString = null;
    private long ruleId = -1L;
    private int matchAction = 0;
    private int ruleNameType = 1;
    private int ruleValueType = 1;

    protected HttpHeaderRule() {
    }

    public HttpHeaderRule(Pattern headerName, Pattern headerValue, int matchAction) {
        this.setHeaderName(headerName);
        this.setHeaderValue(headerValue);
        this.setRuleType(matchAction);
    }

    public HttpHeaderRule(String headerName, Pattern headerValue, int matchAction) {
        this.setHeaderName(headerName);
        this.setHeaderValue(headerValue);
        this.setRuleType(matchAction);
    }

    public HttpHeaderRule(String headerName, String headerValue, int matchAction) {
        this.setHeaderName(headerName);
        this.setHeaderValue(headerValue);
        this.setRuleType(matchAction);
    }

    public HttpHeaderRule(Wildcard headerName, String headerValue, int matchAction) {
        this.setHeaderName(headerName);
        this.setHeaderValue(headerValue);
        this.setRuleType(matchAction);
    }

    public HttpHeaderRule(Pattern headerName, Wildcard headerValue, int matchAction) {
        this.setHeaderName(headerName);
        this.setHeaderValue(headerValue);
        this.setRuleType(matchAction);
    }

    public HttpHeaderRule(Wildcard headerName, Pattern headerValue, int matchAction) {
        this.setHeaderName(headerName);
        this.setHeaderValue(headerValue);
        this.setRuleType(matchAction);
    }

    public HttpHeaderRule(Wildcard headerName, Wildcard headerValue, int matchAction) {
        this.setHeaderName(headerName);
        this.setHeaderValue(headerValue);
        this.setRuleType(matchAction);
    }

    public HttpHeaderRule(String headerName, Wildcard headerValue, int matchAction) {
        this.setHeaderName(headerName);
        this.setHeaderValue(headerValue);
        this.setRuleType(matchAction);
    }

    public HttpHeaderRule(Pattern headerName, String headerValue, int matchAction) {
        this.setHeaderName(headerName);
        this.setHeaderValue(headerValue);
        this.setRuleType(matchAction);
    }

    public void setHeaderName(String headerName) {
        if (headerName == null) {
            throw new IllegalArgumentException("Header name cannot be null");
        }
        this.ruleNameType = 1;
        this.headerNameString = headerName;
        this.headerNamePattern = null;
    }

    public void setHeaderValue(String headerValue) {
        if (headerValue == null) {
            throw new IllegalArgumentException("Header value cannot be null");
        }
        this.ruleValueType = 1;
        this.headerValuePattern = null;
        this.headerValueString = headerValue;
    }

    public void setHeaderName(Pattern headerName) {
        if (headerName == null) {
            throw new IllegalArgumentException("Header name cannot be null");
        }
        this.ruleNameType = 0;
        this.headerNamePattern = headerName;
        this.headerNameString = null;
    }

    public void setHeaderValue(Pattern headerValue) {
        if (headerValue == null) {
            throw new IllegalArgumentException("Header value cannot be null");
        }
        this.ruleValueType = 0;
        this.headerValuePattern = headerValue;
        this.headerValueString = headerValue.pattern();
    }

    public void setHeaderName(Wildcard headerName) {
        if (headerName == null) {
            throw new IllegalArgumentException("Header name cannot be null");
        }
        this.ruleNameType = 2;
        this.headerNamePattern = headerName.getPattern();
        this.headerNameString = headerName.wildcard();
    }

    public void setHeaderValue(Wildcard headerValue) {
        if (headerValue == null) {
            throw new IllegalArgumentException("Header value cannot be null");
        }
        this.ruleValueType = 2;
        this.headerValuePattern = headerValue.getPattern();
        this.headerValueString = headerValue.wildcard();
    }

    public int getNameRuleType() {
        return this.ruleNameType;
    }

    public int getValueRuleType() {
        return this.ruleValueType;
    }

    public Pattern getHeaderNameRegex() {
        return this.headerNamePattern;
    }

    public Pattern getHeaderValueRegex() {
        return this.headerValuePattern;
    }

    public String getHeaderNameString() {
        return this.headerNameString;
    }

    public String getHeaderValueString() {
        return this.headerValueString;
    }

    public long getRuleId() {
        return this.ruleId;
    }

    private void setRuleId(long newRuleId) {
        if (newRuleId < -1L) {
            throw new IllegalArgumentException("The header rule identifier is invalid");
        }
        this.ruleId = newRuleId;
    }

    public boolean isRuleIdSet() {
        return this.ruleId >= -1L;
    }

    public int getRuleType() {
        return this.matchAction;
    }

    public boolean doesNameMatch(String headerName) {
        Matcher matcher;
        return this.getNameRuleType() == 0 || this.getNameRuleType() == 2 ? (matcher = this.headerNamePattern.matcher(headerName)).matches() : this.headerNameString.equals(headerName);
    }

    public boolean doesValueMatch(String headerValue) {
        Matcher matcher;
        return this.getValueRuleType() == 0 || this.getValueRuleType() == 2 ? (matcher = this.headerValuePattern.matcher(headerValue)).matches() : this.headerValueString.equals(headerValue);
    }

    public void setRuleType(int matchAction) {
        if (matchAction != 0 && matchAction != 1) {
            throw new IllegalArgumentException("The match action is not valid");
        }
        this.matchAction = matchAction;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long saveToDatabase(Connection connection, long scanRuleId) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException("The database connection cannot be null");
        }
        Statement statement = null;
        ResultSet keys = null;
        try {
            if (this.ruleId == -1L) {
                statement = connection.prepareStatement("Insert into HttpHeaderScanRule (ScanRuleID, MatchAction, HeaderName, HeaderNameType, HeaderValue, HeaderValueType) values(?, ?, ?, ?, ?, ?)", 1);
                statement.setLong(1, scanRuleId);
                statement.setInt(2, this.matchAction);
                statement.setString(3, this.headerNameString);
                statement.setInt(4, this.ruleNameType);
                statement.setString(5, this.headerValueString);
                statement.setInt(6, this.ruleValueType);
                if (statement.executeUpdate() < 1) {
                    return -1L;
                }
                keys = statement.getGeneratedKeys();
                if (!keys.next()) return -1L;
                long l = this.ruleId = keys.getLong(1);
                return l;
            }
            statement = connection.prepareStatement("Update HttpHeaderScanRule set MatchAction = ?, HeaderName = ?, HeaderNameType =?, HeaderValue = ?, HeaderValueType = ? where HttpHeaderScanRuleID = ?");
            statement.setInt(1, this.matchAction);
            statement.setString(2, this.headerNameString);
            statement.setInt(3, this.ruleNameType);
            statement.setString(4, this.headerValueString);
            statement.setInt(5, this.ruleValueType);
            statement.setLong(6, this.ruleId);
            if (statement.executeUpdate() <= 0) return -1L;
            long l = this.ruleId;
            return l;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (keys != null) {
                keys.close();
            }
        }
    }

    public Hashtable<String, Object> toHashtable() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("Class", this.getClass().getName());
        hashtable.put("NameRule", this.headerNameString);
        hashtable.put("NameRuleType", this.ruleNameType);
        hashtable.put("ValueRule", this.headerValueString);
        hashtable.put("ValueRuleType", this.ruleValueType);
        hashtable.put("RuleAction", this.matchAction);
        hashtable.put("RuleID", this.ruleId);
        return hashtable;
    }

    public static HttpHeaderRule getFromHashtable(Hashtable<String, Object> hashtable) {
        String className = (String)hashtable.get("Class");
        String nameRule = (String)hashtable.get("NameRule");
        Integer nameRuleType = (Integer)hashtable.get("NameRuleType");
        String valueRule = (String)hashtable.get("ValueRule");
        Integer valueRuleType = (Integer)hashtable.get("ValueRuleType");
        Integer ruleId = (Integer)hashtable.get("RuleID");
        Integer ruleType = (Integer)hashtable.get("RuleAction");
        if (className == null || !className.matches("net.lukemurphey.siteSentry.HttpHeaderRule")) {
            throw new IllegalArgumentException("Class type invalid");
        }
        HttpHeaderRule httpHeaderRule = new HttpHeaderRule();
        httpHeaderRule.setRuleType(ruleType);
        httpHeaderRule.setHeaderName(nameRuleType, nameRule);
        httpHeaderRule.setHeaderValue(valueRuleType, valueRule);
        httpHeaderRule.setRuleId(ruleId.intValue());
        return httpHeaderRule;
    }

    protected void setHeaderName(int type, String value) {
        if (type == 0) {
            this.setHeaderName(Pattern.compile(value));
        } else if (type == 1) {
            this.setHeaderName(value);
        } else {
            this.setHeaderName(new Wildcard(value));
        }
    }

    protected void setHeaderValue(int type, String value) {
        if (type == 0) {
            this.setHeaderValue(Pattern.compile(value));
        } else if (type == 1) {
            this.setHeaderValue(value);
        } else {
            this.setHeaderValue(new Wildcard(value));
        }
    }

    protected static HttpHeaderRule getFromResultSet(ResultSet resultSet) throws SQLException {
        String headerName = resultSet.getString("HeaderName");
        String headerValue = resultSet.getString("HeaderValue");
        int headerValueType = resultSet.getInt("HeaderValueType");
        int headerNameType = resultSet.getInt("HeaderNameType");
        int matchAction = resultSet.getInt("MatchAction");
        long httpHeaderRuleId = resultSet.getInt("HttpHeaderScanRuleID");
        HttpHeaderRule headerRule = new HttpHeaderRule();
        headerRule.setRuleType(matchAction);
        headerRule.setHeaderName(headerNameType, headerName);
        headerRule.setHeaderValue(headerValueType, headerValue);
        headerRule.setRuleId(httpHeaderRuleId);
        return headerRule;
    }
}

