/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.GenericUtils;
import net.lukemurphey.nsia.scan.DataSpecimen;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.htmlparser.Parser;
import org.htmlparser.util.ParserException;

public class HttpResponseData {
    private DataSpecimen responseBody;
    private Header[] headers;
    private int responseCode;
    private String queryString;
    private StatusLine statusLine;
    private Method method;
    private Parser parser = null;
    private String originalLocation;
    private String finalLocation;
    private int sizeLimit = 0x100000;
    private boolean hitDownloadLimit = false;
    private static final int DEFAULT_LENGTH_LIMIT = 0x100000;
    private static final Pattern REGEX_GET_ENCODING = Pattern.compile("[-a-zA-Z_ 0-9/;]*charset=[ ]*([-a-zA-Z_0-9]*)");
    private static final Pattern REGEX_CONTENT_TYPE = Pattern.compile("[-.+a-zA-Z0-9]+/[-.+a-zA-Z0-9]+");

    public HttpResponseData(HttpMethod httpMethod) throws URIException {
        this(httpMethod, httpMethod.getURI().toString());
    }

    public HttpResponseData(HttpMethod httpMethod, int downloadSizeLimit) throws URIException {
        this(httpMethod, httpMethod.getURI().toString(), downloadSizeLimit);
    }

    public HttpResponseData(HttpMethod httpMethod, String serverAddress) throws URIException {
        this(httpMethod, serverAddress, 0x100000);
    }

    public HttpResponseData(HttpMethod httpMethod, String serverAddress, int downloadSizeLimit) throws URIException {
        if (httpMethod == null) {
            throw new IllegalArgumentException("The HTTP method must not be null");
        }
        this.setSizeLimit(downloadSizeLimit);
        this.headers = httpMethod.getResponseHeaders();
        try {
            Matcher matcher;
            String contentType = null;
            if (httpMethod.getResponseHeader("Content-Type") != null && httpMethod.getResponseHeader("Content-Type").getValue() != null && (matcher = REGEX_CONTENT_TYPE.matcher(httpMethod.getResponseHeader("Content-Type").getValue())).find()) {
                contentType = matcher.group(0);
            }
            InputStream responseBodyStream = httpMethod.getResponseBodyAsStream();
            byte[] responseBodyBytes = new byte[this.sizeLimit];
            int bytesRead = 0;
            int bytesReadTotal = 0;
            boolean downloadComplete = false;
            while (!downloadComplete) {
                if (responseBodyStream == null) {
                    downloadComplete = true;
                    continue;
                }
                bytesRead = responseBodyStream.read(responseBodyBytes, bytesReadTotal, Math.min(1024, responseBodyBytes.length - bytesReadTotal));
                if (bytesRead <= 0) {
                    downloadComplete = true;
                }
                if (bytesRead == responseBodyBytes.length) {
                    downloadComplete = true;
                    this.hitDownloadLimit = true;
                }
                bytesReadTotal += bytesRead;
            }
            responseBodyBytes = bytesReadTotal > 0 ? (byte[])GenericUtils.resizeArray(responseBodyBytes, bytesReadTotal) : new byte[]{};
            this.finalLocation = new URL(new URL(serverAddress), httpMethod.getURI().toString()).toString();
            this.responseBody = new DataSpecimen(responseBodyBytes, null, this.finalLocation, contentType);
            this.autoSetEncoding();
        }
        catch (IOException e) {
            this.responseBody = null;
        }
        this.responseCode = httpMethod.getStatusCode();
        this.queryString = httpMethod.getQueryString();
        this.statusLine = httpMethod.getStatusLine();
        this.originalLocation = serverAddress;
        if (httpMethod instanceof GetMethod) {
            this.method = Method.GET;
        } else if (httpMethod instanceof PutMethod) {
            this.method = Method.PUT;
        } else if (httpMethod instanceof DeleteMethod) {
            this.method = Method.DELETE;
        } else if (httpMethod instanceof HeadMethod) {
            this.method = Method.HEAD;
        } else if (httpMethod instanceof PostMethod) {
            this.method = Method.POST;
        } else if (httpMethod instanceof TraceMethod) {
            this.method = Method.TRACE;
        }
    }

    private void autoSetEncoding() {
        Matcher matcher;
        String encodingHeader = this.getHeaderValue("Content-Type");
        if (encodingHeader != null && (matcher = REGEX_GET_ENCODING.matcher(encodingHeader)).find()) {
            Charset charset;
            String encodingFromServer = null;
            encodingFromServer = matcher.group(1);
            if (this.responseBody.getEncoding() == null && (charset = (Charset)Charset.availableCharsets().get(encodingFromServer)) != null) {
                this.responseBody.setEncoding(charset);
            }
        }
    }

    private void setSizeLimit(int sizeLimit) {
        if (sizeLimit < 0) {
            throw new IllegalArgumentException("The maximum download size limit must be greater than zero");
        }
        this.sizeLimit = sizeLimit;
    }

    public boolean wasDownloadLimitReached() {
        return this.hitDownloadLimit;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public DataSpecimen getDataSpecimen() {
        return this.responseBody;
    }

    public Parser getDocumentParser() throws ParserException {
        this.parser = new Parser();
        if (this.responseBody != null) {
            this.parser.setEncoding(this.responseBody.getEncoding().toString());
            this.parser.setInputHTML(this.getResponseAsString());
        }
        return this.parser;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestedLocation() {
        return this.originalLocation;
    }

    public String getLocation() {
        return this.finalLocation;
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public byte[] getResponseAsBytes() {
        if (this.responseBody != null) {
            return this.responseBody.getBytes();
        }
        return null;
    }

    public String getHeaderValue(String headerName) {
        int c = 0;
        while (c < this.headers.length) {
            if (this.headers[c].getName().matches(headerName)) {
                return this.headers[c].getValue();
            }
            ++c;
        }
        return null;
    }

    public String getResponseAsString() {
        if (this.responseBody != null) {
            return this.responseBody.getString();
        }
        return null;
    }

    public String getContentType() {
        if (this.responseBody != null) {
            return this.responseBody.getContentType();
        }
        return null;
    }

    public Method getMethod() {
        return this.method;
    }

    public static enum Method {
        GET,
        POST,
        DELETE,
        HEAD,
        PUT,
        TRACE;

    }
}

