/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.MaxMinCount;
import net.lukemurphey.nsia.NameIntPair;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.HttpDefinitionScanResult;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanResultCode;
import net.lukemurphey.nsia.scan.ScanResultLoader;
import net.lukemurphey.nsia.scan.ScanRule;

public class HttpSeekingScanResult
extends ScanResult {
    private HttpDefinitionScanResult[] findings;
    private String domain;
    private boolean partialResults = false;
    private Vector<NameIntPair> contentTypes = null;

    protected HttpSeekingScanResult(ScanResultCode scanResultCode, Timestamp timeOfScan) {
        super(scanResultCode, timeOfScan);
    }

    public HttpSeekingScanResult(Vector<HttpDefinitionScanResult> matches, String domainWildcard, long scanRuleId, ScanResultCode resultCode, Timestamp timeOfScan) {
        super(resultCode, timeOfScan);
        this.findings = new HttpDefinitionScanResult[matches.size()];
        matches.toArray(this.findings);
        this.ruleId = scanRuleId;
        this.domain = domainWildcard;
    }

    public HttpDefinitionScanResult[] getFindings() {
        this.loadFindings();
        HttpDefinitionScanResult[] tempResults = new HttpDefinitionScanResult[this.findings.length];
        System.arraycopy(this.findings, 0, tempResults, 0, this.findings.length);
        return tempResults;
    }

    public Hashtable<Definition.Severity, Integer> getSignatureMatchSeverities() throws SQLException, NoDatabaseConnectionException {
        return HttpDefinitionScanResult.getSignatureMatchSeverities(this.scanResultId);
    }

    @Override
    public String getRuleType() {
        return "HTTP/Autodiscovery";
    }

    @Override
    public String getSpecimenDescription() {
        return this.domain;
    }

    @Override
    public int getDeviations() {
        int devs = 0;
        if (this.findings == null) {
            return this.deviations;
        }
        int c = 0;
        while (c < this.findings.length) {
            if (this.findings[c].deviations > 0) {
                ++devs;
            }
            ++c;
        }
        this.deviations = devs;
        return devs;
    }

    private void updateCounts() {
        if (this.deviations >= 0 || this.incompletes >= 0 || this.accepts >= 0) {
            return;
        }
        this.deviations = 0;
        this.accepts = 0;
        this.incompletes = 0;
        int c = 0;
        while (c < this.findings.length) {
            if (this.findings[c].getDeviations() > 0) {
                ++this.deviations;
            } else if (this.findings[c].getResultCode() == ScanResultCode.SCAN_COMPLETED) {
                ++this.accepts;
            } else {
                ++this.incompletes;
            }
            ++c;
        }
    }

    protected static HttpSeekingScanResult loadFromDatabase(long scanRuleId, long scanResultId, ScanResultCode resultCode, Timestamp scanTime, int deviations, int incompletes, int accepts) throws SQLException, NoDatabaseConnectionException, ScanRule.ScanResultLoadFailureException {
        return HttpSeekingScanResult.loadFromDatabase(Application.getApplication(), scanRuleId, scanResultId, resultCode, scanTime, deviations, incompletes, accepts);
    }

    protected static HttpSeekingScanResult loadFromDatabase(Application application, long scanRuleId, long scanResultId, ScanResultCode resultCode, Timestamp scanTime, int deviations, int incompletes, int accepts) throws SQLException, NoDatabaseConnectionException, ScanRule.ScanResultLoadFailureException {
        Connection connection = null;
        HttpSeekingScanResult scanResult = new HttpSeekingScanResult(resultCode, scanTime);
        scanResult.deviations = deviations;
        scanResult.incompletes = incompletes;
        scanResult.accepts = accepts;
        scanResult.ruleId = scanRuleId;
        scanResult.scanResultId = scanResultId;
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            connection = application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Select * from HttpDiscoveryResult where ScanResultID = ?");
            statement.setLong(1, scanResultId);
            result = statement.executeQuery();
            if (result.next()) {
                scanResult.domain = result.getString("Domain");
            }
            scanResult.partialResults = true;
            HttpSeekingScanResult httpSeekingScanResult = scanResult;
            return httpSeekingScanResult;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
        }
    }

    public Vector<NameIntPair> getDiscoveredContentTypes() {
        if (this.contentTypes != null) {
            return this.contentTypes;
        }
        if (!this.partialResults) {
            Vector<NameIntPair> contentTypesTemp = new Vector<NameIntPair>();
            HttpDefinitionScanResult[] httpDefinitionScanResultArray = this.findings;
            int n = this.findings.length;
            int n2 = 0;
            while (n2 < n) {
                HttpDefinitionScanResult sigResult = httpDefinitionScanResultArray[n2];
                boolean found = false;
                for (NameIntPair pair : contentTypesTemp) {
                    if ((pair.getName() != null || sigResult.getContentType() != null) && (pair.getName() == null || !pair.getName().equalsIgnoreCase(sigResult.getContentType()))) continue;
                    pair.setValue(pair.getValue() + 1);
                    found = true;
                }
                if (!found) {
                    contentTypesTemp.add(new NameIntPair(sigResult.getContentType(), 1));
                }
                ++n2;
            }
            this.contentTypes = contentTypesTemp;
            return this.contentTypes;
        }
        Connection connection = null;
        try {
            connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            Vector<NameIntPair> vector = this.contentTypes = HttpSeekingScanResult.getDiscoveredContentTypesInternal(this.scanResultId, connection);
            return vector;
        }
        catch (SQLException e) {
            Application.getApplication().logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            return null;
        }
        catch (NoDatabaseConnectionException e) {
            Application.getApplication().logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            return null;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                Application.getApplication().logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            }
        }
    }

    public static Vector<NameIntPair> getDiscoveredContentTypes(long scanResultID) throws NoDatabaseConnectionException, SQLException {
        if (scanResultID < 0L) {
            throw new IllegalArgumentException("The scan result identifier must be zero or greater");
        }
        Vector<NameIntPair> contentTypes = null;
        Connection connection = null;
        try {
            connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            Vector<NameIntPair> vector = contentTypes = HttpSeekingScanResult.getDiscoveredContentTypesInternal(scanResultID, connection);
            return vector;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public static MaxMinCount getScanResultInfo(long scanResultID, HttpDefinitionScanResult.SignatureScanResultFilter filter, Application application) throws SQLException, NoDatabaseConnectionException {
        return HttpDefinitionScanResult.getScanResultInfo(scanResultID, filter, application);
    }

    public MaxMinCount getScanResultInfo(HttpDefinitionScanResult.SignatureScanResultFilter filter, Application application) throws ScanRule.ScanResultLoadFailureException, SQLException, NoDatabaseConnectionException {
        return HttpDefinitionScanResult.getScanResultInfo(this.scanResultId, filter, application);
    }

    private static Vector<NameIntPair> getDiscoveredContentTypesInternal(long scanResultID, Connection connection) throws SQLException, NoDatabaseConnectionException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("select ContentType, count(*) as ContentTypeCount from SignatureScanResult inner join ScanResult on ScanResult.ScanResultID = SignatureScanResult.ScanResultID where ParentScanResultID = ? group by ContentType order by count(*) desc");
            statement.setLong(1, scanResultID);
            resultSet = statement.executeQuery();
            Vector<NameIntPair> contentTypes = new Vector<NameIntPair>();
            while (resultSet.next()) {
                String contentType = resultSet.getString("ContentType");
                int count = resultSet.getInt("ContentTypeCount");
                if (contentType == null) {
                    contentTypes.add(new NameIntPair("[unknown]", count));
                    continue;
                }
                contentTypes.add(new NameIntPair(contentType, count));
            }
            Vector<NameIntPair> vector = contentTypes;
            return vector;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    public HttpDefinitionScanResult[] getFindings(long start, int count, HttpDefinitionScanResult.SignatureScanResultFilter filter, boolean getResultsBefore) throws ScanRule.ScanResultLoadFailureException, SQLException, NoDatabaseConnectionException {
        HttpDefinitionScanResult[] linkedResults = HttpDefinitionScanResult.loadScanResults(this.scanResultId, start, getResultsBefore, filter, count, Application.getApplication());
        return linkedResults;
    }

    public HttpDefinitionScanResult[] getFindings(int count, boolean getResultsBefore) throws ScanRule.ScanResultLoadFailureException, SQLException, NoDatabaseConnectionException {
        HttpDefinitionScanResult[] linkedResults = HttpDefinitionScanResult.loadScanResults(this.scanResultId, getResultsBefore, new HttpDefinitionScanResult.SignatureScanResultFilter(), count, Application.getApplication());
        return linkedResults;
    }

    public HttpDefinitionScanResult[] getFindings(long start, int count, boolean getResultsBefore) throws ScanRule.ScanResultLoadFailureException, SQLException, NoDatabaseConnectionException {
        HttpDefinitionScanResult[] linkedResults = HttpDefinitionScanResult.loadScanResults(this.scanResultId, start, getResultsBefore, new HttpDefinitionScanResult.SignatureScanResultFilter(), count, Application.getApplication());
        return linkedResults;
    }

    private void loadFindings() {
        if (this.partialResults) {
            try {
                ScanResult[] linkedResults = ScanResultLoader.getLinkedScanResults(this.scanResultId);
                this.findings = new HttpDefinitionScanResult[linkedResults.length];
                int c = 0;
                while (c < linkedResults.length) {
                    this.findings[c] = (HttpDefinitionScanResult)linkedResults[c];
                    ++c;
                }
                this.partialResults = false;
            }
            catch (ScanRule.ScanResultLoadFailureException e) {
                Application.getApplication().logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
                this.partialResults = false;
            }
        }
    }

    @Override
    public long saveToDatabase(Connection connection, long scanRuleId) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException("The database connection cannot be null");
        }
        long scanResultId = this.saveToDatabaseInitial(connection, scanRuleId, "HTTP/Autodiscovery");
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("Insert into HttpDiscoveryResult (ScanResultID, Domain) values(?, ?)");
            statement.setLong(1, scanResultId);
            statement.setString(2, this.domain);
            statement.execute();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        int c = 0;
        while (c < this.findings.length) {
            HttpDefinitionScanResult result = this.findings[c];
            result.parentScanResultId = scanResultId;
            result.saveToDatabase(connection, -1L);
            ++c;
        }
        this.updateCounts();
        this.saveToDatabaseFinalize(connection, scanResultId, this.getDeviations(), this.accepts, this.incompletes, scanRuleId);
        return scanResultId;
    }
}

