/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.Wildcard;
import net.lukemurphey.nsia.WorkerThread;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.DefinitionArchive;
import net.lukemurphey.nsia.scan.DefinitionEvaluationException;
import net.lukemurphey.nsia.scan.DefinitionMatch;
import net.lukemurphey.nsia.scan.DefinitionPolicyDescriptor;
import net.lukemurphey.nsia.scan.DefinitionPolicySet;
import net.lukemurphey.nsia.scan.DefinitionSet;
import net.lukemurphey.nsia.scan.DefinitionSetLoadException;
import net.lukemurphey.nsia.scan.HttpDefinitionScanResult;
import net.lukemurphey.nsia.scan.HttpDefinitionScanRule;
import net.lukemurphey.nsia.scan.HttpSeekingScanResult;
import net.lukemurphey.nsia.scan.InvalidDefinitionException;
import net.lukemurphey.nsia.scan.RuleBaselineException;
import net.lukemurphey.nsia.scan.ScanException;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanResultCode;
import net.lukemurphey.nsia.scan.ScanResultLoader;
import net.lukemurphey.nsia.scan.ScanRule;
import net.lukemurphey.nsia.scan.ScriptDefinition;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;

public class HttpSeekingScanRule
extends ScanRule
implements WorkerThread {
    private Vector<URL> seedUrls = new Vector();
    private Wildcard restrictToDomain = null;
    private boolean scanExternalLinks = false;
    private int scanCountLimit = 1000;
    private int recursionLevels = 10;
    private static final int DEPTH_LIMIT = 100;
    private static final int SCAN_LIMIT = 50000;
    private int resourcesScanned = 0;
    private boolean terminate = false;
    private boolean inScan = false;
    private String currentlyScanning;
    private HttpSeekingScanResult lastScanResult = null;
    private Exception exceptionThrown = null;
    private boolean stopRecursingOn404 = true;
    Vector<ScanRunner> runningThreads = new Vector();
    int maxScanThreads = 10;
    public static final String RULE_TYPE = "HTTP/Autodiscovery";
    public static final int SUBCATEGORY_EXCEPTION_THRESHOLD = 5;

    public HttpSeekingScanRule(Application appRes) {
        super(appRes);
        try {
            this.setMaxScanThreads(appRes.getApplicationConfiguration().getMaxHTTPScanThreads());
        }
        catch (NoDatabaseConnectionException e) {
            appRes.getEventLog().logEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR));
        }
        catch (SQLException e) {
            appRes.getEventLog().logEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR));
        }
        catch (InputValidationException e) {
            appRes.getEventLog().logEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR));
        }
    }

    public HttpSeekingScanRule(Application appRes, Wildcard restrictTo, int scanFrequency, boolean includeFirstLevelOfExternalLinks) {
        super(appRes);
        this.setDomainRestriction(restrictTo);
        this.setScanFrequency(scanFrequency);
        try {
            this.setMaxScanThreads(appRes.getApplicationConfiguration().getMaxHTTPScanThreads());
        }
        catch (NoDatabaseConnectionException e) {
            appRes.getEventLog().logEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR));
        }
        catch (SQLException e) {
            appRes.getEventLog().logEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR));
        }
        catch (InputValidationException e) {
            appRes.getEventLog().logEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR));
        }
    }

    public HttpSeekingScanRule(Application appRes, Wildcard restrictTo, boolean includeFirstLevelOfExternalLinks) {
        super(appRes);
        this.setDomainRestriction(restrictTo);
        this.setScanFrequency(3600);
        try {
            this.setMaxScanThreads(appRes.getApplicationConfiguration().getMaxHTTPScanThreads());
        }
        catch (NoDatabaseConnectionException e) {
            appRes.getEventLog().logEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR));
        }
        catch (SQLException e) {
            appRes.getEventLog().logEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR));
        }
        catch (InputValidationException e) {
            appRes.getEventLog().logEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR));
        }
    }

    public void scanExternalLinks(boolean includeFirstLevelOfExternalLinks) {
        this.scanExternalLinks = includeFirstLevelOfExternalLinks;
    }

    public boolean getScansExternalLinks() {
        return this.scanExternalLinks;
    }

    public Wildcard getDomainRestriction() {
        return this.restrictToDomain;
    }

    public void setDomainRestriction(Wildcard restrictTo) {
        if (restrictTo == null) {
            throw new IllegalArgumentException("The domain restriction wildcard cannot be null");
        }
        this.restrictToDomain = restrictTo;
    }

    private Vector<URL> extractUrls(URL url, Parser parser) throws UnsupportedEncodingException {
        Vector<URL> urls = new Vector<URL>();
        Vector<URL> urlsTemp = this.getUrlAttrs("a", "href", url, parser, false);
        if (urlsTemp != null) {
            urls.addAll(urlsTemp);
        }
        if ((urlsTemp = this.getUrlAttrs("img", "src", url, parser, true)) != null) {
            urls.addAll(urlsTemp);
        }
        if ((urlsTemp = this.getUrlAttrs("applet", "code", url, parser, true)) != null) {
            urls.addAll(urlsTemp);
        }
        if ((urlsTemp = this.getUrlAttrs("object", "codebase", url, parser, true)) != null) {
            urls.addAll(urlsTemp);
        }
        if ((urlsTemp = this.getUrlAttrs("link", "href", url, parser, true)) != null) {
            urls.addAll(urlsTemp);
        }
        if ((urlsTemp = this.getUrlAttrs("script", "src", url, parser, true)) != null) {
            urls.addAll(urlsTemp);
        }
        if ((urlsTemp = this.getUrlAttrs("iframe", "src", url, parser, true)) != null) {
            urls.addAll(urlsTemp);
        }
        if ((urlsTemp = this.getUrlAttrs("frame", "src", url, parser, true)) != null) {
            urls.addAll(urlsTemp);
        }
        if ((urlsTemp = this.getUrlAttrs("embed", "code", url, parser, true)) != null) {
            urls.addAll(urlsTemp);
        }
        return urls;
    }

    private Vector<URL> filterExternalURLs(Vector<URL> urls) {
        Vector<URL> filteredURLs = new Vector<URL>();
        if (urls == null) {
            return filteredURLs;
        }
        for (URL newURL : urls) {
            if (newURL == null || newURL.getHost() == null || !this.hostnameIsValid(newURL.getHost()) || !this.domainMatches(newURL)) continue;
            filteredURLs.add(newURL);
        }
        return filteredURLs;
    }

    private void multiThreadedScan(DefinitionSet sigs, int maxThreads, Vector<HttpDefinitionScanResult> findings) throws UnsupportedEncodingException {
        HttpDefinitionScanRule.HttpSignatureScanResultWithParser result;
        ScanRunner runner;
        Iterator<ScanRunner> it;
        Vector<ScanRecord> pending = new Vector<ScanRecord>();
        Vector<String> urls = new Vector<String>();
        HttpClient client = new HttpClient((HttpConnectionManager)HttpDefinitionScanRule.getConnectionManager());
        Date scanStartDate = new Date();
        for (URL url : this.seedUrls) {
            urls.add(URLDecoder.decode(url.toString(), "UTF-8"));
            pending.add(new ScanRecord(url));
        }
        while (findings.size() + this.runningThreads.size() < this.scanCountLimit && !this.terminate) {
            if (this.runningThreads.size() == 0 && pending.size() == 0) break;
            it = this.runningThreads.iterator();
            block6: while (it.hasNext()) {
                runner = it.next();
                if (!runner.done()) continue;
                it.remove();
                result = runner.getResult();
                if (this.terminate || result == null) continue;
                findings.add(result.getScanResult());
                ++this.resourcesScanned;
                if (runner.getLevel() >= this.recursionLevels || result.getParser() == null || result.getScanResult() == null) continue;
                Vector<URL> extractedUrls = null;
                extractedUrls = result.getScanResult().getContentType() == null || result.getScanResult().getContentType().contains("html") || result.getScanResult().getContentType().contains("xml") ? this.extractUrls(result.getScanResult().getUrl(), result.getParser()) : new Vector();
                extractedUrls.addAll(this.filterExternalURLs(result.getExtractedURLsDomainLimited()));
                extractedUrls.addAll(result.getExtractedURLsDomainUnlimited());
                for (URL newURL : extractedUrls) {
                    if (findings.size() >= this.scanCountLimit) continue block6;
                    String str = newURL.toString();
                    boolean found = false;
                    for (String oldURL : urls) {
                        if (!oldURL.equalsIgnoreCase(str)) continue;
                        found = true;
                    }
                    if (found) continue;
                    urls.add(str);
                    if (result.getHttpResponseCode() == 404 && this.stopRecursingOn404) {
                        pending.add(new ScanRecord(newURL, result.getScanResult(), this.recursionLevels));
                        continue;
                    }
                    pending.add(new ScanRecord(newURL, result.getScanResult(), runner.getLevel() + 1));
                }
            }
            if (this.runningThreads.size() >= maxThreads || pending.size() == 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException runner2) {}
                continue;
            }
            if (this.terminate || pending.size() <= 0) continue;
            ScanRecord record = (ScanRecord)pending.remove(0);
            ScanRunner runner3 = new ScanRunner(record, sigs, record.getLevel(), client, scanStartDate);
            this.runningThreads.add(runner3);
            runner3.setUncaughtExceptionHandler(new ScanThreadExceptionHandler(record.getURL()));
            runner3.setPriority(1);
            runner3.start();
        }
        while (this.runningThreads.size() > 0) {
            it = this.runningThreads.iterator();
            while (it.hasNext()) {
                runner = it.next();
                if (runner.done()) {
                    it.remove();
                    result = runner.getResult();
                    if (this.terminate || result == null) continue;
                    findings.add(result.getScanResult());
                    result = null;
                    ++this.resourcesScanned;
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private Vector<URL> getUrlAttrs(String tag, String attribute, URL parentUrl, Parser htmlDocumentParser, boolean alwaysInclude) throws UnsupportedEncodingException {
        try {
            TagNameFilter tagNameFilter = new TagNameFilter(tag);
            NodeList nodesList = htmlDocumentParser.extractAllNodesThatMatch((NodeFilter)tagNameFilter);
            Vector<URL> vector = this.getUrlAttrs(nodesList, attribute, parentUrl, alwaysInclude);
            return vector;
        }
        catch (ParserException e) {
            return null;
        }
        finally {
            if (htmlDocumentParser != null) {
                htmlDocumentParser.reset();
            }
        }
    }

    private boolean domainMatches(URL url) {
        if (this.restrictToDomain.wildcard().contains("?")) {
            return this.restrictToDomain.getPattern().matcher(url.toString()).matches();
        }
        if (Pattern.matches("[0-9a-zA-Z*-.]+", this.restrictToDomain.wildcard())) {
            return this.restrictToDomain.getPattern().matcher(url.getHost()).matches();
        }
        String[] urlNoArgs = url.toString().split("[?]");
        return this.restrictToDomain.getPattern().matcher(urlNoArgs[0]).matches();
    }

    private Vector<URL> getUrlAttrs(NodeList nodesList, String attribute, URL parentUrl, boolean alwaysInclude) throws UnsupportedEncodingException {
        Vector<URL> referenceList = new Vector<URL>();
        int c = 0;
        while (c < nodesList.size()) {
            Tag node = (Tag)nodesList.elementAt(c);
            String currentItem = node.getAttribute(attribute);
            if (currentItem != null) {
                try {
                    URL newURL;
                    int fragmentOffset = currentItem.lastIndexOf("#");
                    if (fragmentOffset >= 0) {
                        currentItem = currentItem.substring(0, fragmentOffset);
                    }
                    if ((newURL = new URL(parentUrl, URLDecoder.decode(currentItem.trim(), "UTF-8"))).getHost() != null && this.hostnameIsValid(newURL.getHost()) && (this.domainMatches(newURL) || this.scanExternalLinks && this.domainMatches(parentUrl) || alwaysInclude)) {
                        referenceList.add(newURL);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            ++c;
        }
        return referenceList;
    }

    private boolean hostnameIsValid(String hostname) {
        return Pattern.matches("[-.0-9a-zA-Z]+", hostname);
    }

    @Override
    public void delete() throws SQLException, NoDatabaseConnectionException {
        Connection connection = null;
        Statement statement = null;
        ScanRule.deleteRule(this.scanRuleId);
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Delete from HttpDiscoveryRule where ScanRuleID = ?");
            statement.setLong(1, this.scanRuleId);
            statement.execute();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    public void setMaxScanThreads(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("The maximum number of threads cannot be less than one");
        }
        this.maxScanThreads = max;
    }

    public int getMaxScanThreads() {
        return this.maxScanThreads;
    }

    @Override
    public ScanResult doScan() throws ScanException {
        try {
            DefinitionSet sigs;
            this.inScan = true;
            Vector<HttpDefinitionScanResult> findings = new Vector<HttpDefinitionScanResult>();
            try {
                sigs = DefinitionArchive.getArchive().getDefinitionSet();
            }
            catch (NoDatabaseConnectionException e) {
                throw new ScanException("Signature set could not be loaded", e);
            }
            catch (DefinitionSetLoadException e) {
                throw new ScanException("Signature set could not be loaded", e);
            }
            catch (SQLException e) {
                throw new ScanException("Signature set could not be loaded", e);
            }
            catch (InputValidationException e) {
                throw new ScanException("Signature set could not be loaded", e);
            }
            try {
                this.multiThreadedScan(sigs, this.maxScanThreads, findings);
            }
            catch (UnsupportedEncodingException e) {
                throw new ScanException("Cannot perform a scan since the encoding required to decode URLs is not-supported by the runtime", e);
            }
            ScanResultCode resultCode = null;
            int c = 0;
            while (c < findings.size()) {
                if (findings.get(c).getResultCode().getId() != ScanResultCode.SCAN_COMPLETED.getId() && resultCode == null) {
                    resultCode = findings.get(c).getResultCode();
                } else if (findings.get(c).getResultCode().getId() != ScanResultCode.SCAN_COMPLETED.getId() && resultCode != null && resultCode.getId() != findings.get(c).getResultCode().getId()) {
                    resultCode = ScanResultCode.SCAN_FAILED;
                    break;
                }
                ++c;
            }
            if (this.terminate) {
                resultCode = ScanResultCode.SCAN_TERMINATED;
            } else if (findings.size() == 0) {
                resultCode = ScanResultCode.SCAN_FAILED;
            }
            c = 0;
            while (c < findings.size()) {
                this.logSignatureScanResult(findings.get((int)c).deviations, findings.get(c).getUrl());
                ++c;
            }
            int devs = 0;
            int c2 = 0;
            while (c2 < findings.size()) {
                if (findings.get((int)c2).deviations > 0) {
                    ++devs;
                }
                ++c2;
            }
            this.logScanResult(resultCode, devs);
            this.inScan = false;
            if (resultCode != null) {
                HttpSeekingScanResult httpSeekingScanResult = new HttpSeekingScanResult(findings, this.restrictToDomain.wildcard(), this.scanRuleId, resultCode, new Timestamp(System.currentTimeMillis()));
                return httpSeekingScanResult;
            }
            HttpSeekingScanResult httpSeekingScanResult = new HttpSeekingScanResult(findings, this.restrictToDomain.wildcard(), this.scanRuleId, ScanResultCode.SCAN_COMPLETED, new Timestamp(System.currentTimeMillis()));
            return httpSeekingScanResult;
        }
        finally {
            this.inScan = false;
        }
    }

    private void logSignatureScanResult(int definitionsMatched, URL url) {
        if (definitionsMatched > 0) {
            this.logScanResult(ScanResultCode.SCAN_COMPLETED, definitionsMatched, RULE_TYPE, url.toString(), String.valueOf(definitionsMatched) + " definitions matched", true, false);
        } else {
            this.logScanResult(ScanResultCode.SCAN_COMPLETED, 0, RULE_TYPE, url.toString(), "0 definitions matched", true, false);
        }
    }

    private void logScanResult(ScanResultCode resultCode, int deviations) {
        this.logScanComplete(resultCode, deviations, RULE_TYPE, this.getSpecimenDescription(), true, false);
    }

    @Override
    public String getRuleType() {
        return RULE_TYPE;
    }

    @Override
    public String getSpecimenDescription() {
        return this.restrictToDomain.wildcard();
    }

    @Override
    public boolean loadFromDatabase(long scanRuleId) throws NotFoundException, NoDatabaseConnectionException, SQLException, ScanRule.ScanRuleLoadFailureException {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        PreparedStatement generalRuleStatement = null;
        ResultSet generalRuleResult = null;
        Statement seedUrlStatement = null;
        ResultSet seedUrlResult = null;
        try {
            int scanFrequency;
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            generalRuleStatement = connection.prepareStatement("Select * from ScanRule where ScanRuleID = ?");
            generalRuleStatement.setLong(1, scanRuleId);
            generalRuleResult = generalRuleStatement.executeQuery();
            if (!generalRuleResult.next()) {
                return false;
            }
            this.scanFrequency = scanFrequency = generalRuleResult.getInt("ScanFrequency");
            this.created = generalRuleResult.getTimestamp("Created");
            this.modified = generalRuleResult.getTimestamp("Modified");
            statement = connection.prepareStatement("Select * from HttpDiscoveryRule where ScanRuleID = ?");
            statement.setLong(1, scanRuleId);
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                return false;
            }
            this.recursionLevels = resultSet.getInt("RecursionDepth");
            this.restrictToDomain = new Wildcard(resultSet.getString("Domain"), true);
            this.scanCountLimit = resultSet.getInt("ResourceScanLimit");
            this.scanExternalLinks = resultSet.getBoolean("ScanFirstExternal");
            this.scanRuleId = scanRuleId;
            seedUrlStatement = connection.prepareStatement("Select * from RuleURL where ScanRuleID = ?");
            seedUrlStatement.setLong(1, scanRuleId);
            seedUrlResult = seedUrlStatement.executeQuery();
            while (seedUrlResult.next()) {
                try {
                    this.addSeedUrl(new URL(seedUrlResult.getString("URL")));
                }
                catch (MalformedURLException e) {
                    throw new ScanRule.ScanRuleLoadFailureException("One of the seed URLs is invalid: " + seedUrlResult.getString("URL"), e);
                }
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
            if (generalRuleStatement != null) {
                generalRuleStatement.close();
            }
            if (generalRuleResult != null) {
                generalRuleResult.close();
            }
            if (seedUrlStatement != null) {
                seedUrlStatement.close();
            }
            if (seedUrlResult != null) {
                seedUrlResult.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return true;
    }

    private boolean isReady() {
        return this.seedUrls.size() != 0;
    }

    public long saveToDatabase() throws IllegalStateException, SQLException, NoDatabaseConnectionException {
        if (this.scanRuleId == -1L) {
            throw new IllegalStateException("Scan rule must not be less than zero");
        }
        return this.saveToDatabaseEx(this.scanRuleId);
    }

    public long saveNewRuleToDatabase(long siteGroupId) throws IllegalStateException, SQLException, NoDatabaseConnectionException {
        if (siteGroupId < 0L) {
            throw new IllegalArgumentException("Site group identifer must not be less than zero");
        }
        return this.saveNewRuleToDatabaseEx(siteGroupId);
    }

    public void saveToDatabase(long scanRuleId) throws IllegalStateException, SQLException, NoDatabaseConnectionException {
        if (scanRuleId < 0L) {
            throw new IllegalArgumentException("Scan rule must not be less than zero");
        }
        this.saveToDatabaseEx(scanRuleId);
    }

    private synchronized long saveNewRuleToDatabaseEx(long siteGroupId) throws IllegalStateException, SQLException, NoDatabaseConnectionException {
        if (siteGroupId < -1L) {
            throw new IllegalArgumentException("Site group ID is invalid (must not be less than zero)");
        }
        if (!this.isReady()) {
            throw new IllegalStateException("HTTP scan class cannot be persisted to database since critical information is missing");
        }
        Connection connection = null;
        Statement statement = null;
        Statement saveSeedUrl = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            this.scanRuleId = this.createRule(siteGroupId, this.getScanFrequency(), RULE_TYPE, 1);
            statement = connection.prepareStatement("Insert into HttpDiscoveryRule(RecursionDepth, ResourceScanLimit, Domain, ScanFirstExternal, ScanRuleID) values(?, ?, ?, ?, ?)");
            statement.setInt(1, this.recursionLevels);
            statement.setInt(2, this.scanCountLimit);
            statement.setString(3, this.restrictToDomain.wildcard());
            statement.setBoolean(4, this.scanExternalLinks);
            statement.setLong(5, this.scanRuleId);
            statement.execute();
            Iterator<URL> iterator = this.seedUrls.iterator();
            while (iterator.hasNext()) {
                saveSeedUrl = connection.prepareStatement("Insert into RuleURL (ScanRuleID, URL) values (?, ?)");
                saveSeedUrl.setLong(1, this.scanRuleId);
                saveSeedUrl.setString(2, iterator.next().toString());
                saveSeedUrl.executeUpdate();
            }
            long l = this.scanRuleId;
            return l;
        }
        finally {
            if (saveSeedUrl != null) {
                saveSeedUrl.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private synchronized long saveToDatabaseEx(long scanRuleId) throws IllegalStateException, SQLException, NoDatabaseConnectionException {
        if (scanRuleId < 0L) {
            throw new IllegalArgumentException("Scan rule ID is invalid (must not be less than zero)");
        }
        if (!this.isReady()) {
            throw new IllegalStateException("HTTP scan class cannot be persisted to database since critical information is missing");
        }
        Connection connection = null;
        Statement statement = null;
        Statement generalStatement = null;
        Statement statementDeleteOldSeedUrls = null;
        Statement saveSeedUrl = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Update HttpDiscoveryRule set RecursionDepth = ?, ResourceScanLimit = ?, Domain = ?, ScanFirstExternal = ? where ScanRuleID = ?");
            statement.setInt(1, this.recursionLevels);
            statement.setInt(2, this.scanCountLimit);
            statement.setString(3, this.restrictToDomain.wildcard());
            statement.setBoolean(4, this.scanExternalLinks);
            statement.setLong(5, scanRuleId);
            statement.executeUpdate();
            this.scanRuleId = scanRuleId;
            statementDeleteOldSeedUrls = connection.prepareStatement("Delete from RuleURL where ScanRuleID = ?");
            statementDeleteOldSeedUrls.setLong(1, scanRuleId);
            statementDeleteOldSeedUrls.executeUpdate();
            Iterator<URL> iterator = this.seedUrls.iterator();
            while (iterator.hasNext()) {
                saveSeedUrl = connection.prepareStatement("Insert into RuleURL (ScanRuleID, URL) values (?, ?)");
                saveSeedUrl.setLong(1, scanRuleId);
                saveSeedUrl.setString(2, iterator.next().toString());
                saveSeedUrl.executeUpdate();
            }
            generalStatement = connection.prepareStatement("Update ScanRule set ScanFrequency = ?, ScanDataObsolete = ?, Modified = ? where ScanRuleID = ?");
            generalStatement.setInt(1, this.getScanFrequency());
            generalStatement.setBoolean(2, true);
            generalStatement.setTimestamp(3, new Timestamp(new Date().getTime()));
            generalStatement.setLong(4, scanRuleId);
            generalStatement.executeUpdate();
            long l = this.scanRuleId;
            return l;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (saveSeedUrl != null) {
                saveSeedUrl.close();
            }
            if (generalStatement != null) {
                generalStatement.close();
            }
            if (statementDeleteOldSeedUrls != null) {
                statementDeleteOldSeedUrls.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Override
    public ScanResult loadScanResult(long scanResultId) throws NotFoundException, NoDatabaseConnectionException, SQLException, ScanRule.ScanResultLoadFailureException {
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        try {
            HttpSeekingScanResult scanResult;
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            if (connection == null) {
                throw new NoDatabaseConnectionException();
            }
            statement = connection.prepareStatement("Select * from ScanResult where ScanResultID = ?");
            statement.setLong(1, scanResultId);
            result = statement.executeQuery();
            if (!result.next()) {
                return null;
            }
            ScanResultCode resultCode = ScanResultCode.getScanResultCodeById(result.getInt("ScanResultCode"));
            if (resultCode == null) {
                return null;
            }
            HttpSeekingScanResult httpSeekingScanResult = scanResult = HttpSeekingScanResult.loadFromDatabase(result.getLong("ScanRuleID"), scanResultId, resultCode, result.getTimestamp("ScanDate"), result.getInt("Deviations"), result.getInt("Incompletes"), result.getInt("Accepts"));
            return httpSeekingScanResult;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    public final void setScanCountLimit(int resourceLimit) {
        if (resourceLimit > 50000) {
            throw new IllegalArgumentException("The resource limit cannot exceed 50000");
        }
        this.scanCountLimit = resourceLimit;
    }

    public int resourcesScanned() {
        return this.resourcesScanned;
    }

    public final int getScanCountLimit() {
        return this.scanCountLimit;
    }

    public final void setRecursionDepth(int depth) {
        if (depth > 100) {
            throw new IllegalArgumentException("The depth limit cannot exceed 100");
        }
        this.recursionLevels = depth;
    }

    public final int getRecursionDepth() {
        return this.recursionLevels;
    }

    public final void addSeedUrl(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("A URL to be added to the list cannot be null");
        }
        this.seedUrls.add(url);
    }

    public URL[] getSeedUrlsNotInDomain() {
        Iterator<URL> iterators = this.seedUrls.iterator();
        Vector<URL> urlsNotInDomain = new Vector<URL>();
        while (iterators.hasNext()) {
            URL url = iterators.next();
            Pattern domainRestriction = this.restrictToDomain.getPattern();
            Matcher matcher = domainRestriction.matcher(url.toExternalForm());
            if (matcher.matches()) continue;
            urlsNotInDomain.add(url);
        }
        URL[] urlsArray = new URL[urlsNotInDomain.size()];
        urlsNotInDomain.toArray(urlsArray);
        return urlsArray;
    }

    public URL[] getSeedUrls() {
        URL[] startAddresses = new URL[this.seedUrls.size()];
        this.seedUrls.toArray(startAddresses);
        return startAddresses;
    }

    public void clearSeedUrls() {
        this.seedUrls.clear();
    }

    public final void setSeedUrls(URL[] urls) {
        this.seedUrls.clear();
        this.addSeedUrls(urls);
    }

    public synchronized boolean baseline() throws RuleBaselineException, SQLException {
        Connection conn = null;
        try {
            if (this.scanRuleId < 0L) {
                return false;
            }
            conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            HttpSeekingScanResult result = (HttpSeekingScanResult)ScanResultLoader.getLastScanResult(this.scanRuleId);
            if (result == null) {
                return false;
            }
            try {
                HttpDefinitionScanResult[] findings = result.getFindings();
                DefinitionPolicySet policySet = DefinitionPolicySet.getPolicySetForSiteGroup(conn, this.scanRuleId);
                DefinitionSet definitions = DefinitionArchive.getArchive().getDefinitionSet();
                HttpDefinitionScanResult[] httpDefinitionScanResultArray = findings;
                int n = findings.length;
                int n2 = 0;
                while (n2 < n) {
                    HttpDefinitionScanResult finding = httpDefinitionScanResultArray[n2];
                    DefinitionMatch[] definitionMatchArray = finding.getDefinitionMatches();
                    int n3 = definitionMatchArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String definitionSubCategory;
                        String definitionCategory;
                        String[] name;
                        String definitionName;
                        DefinitionMatch match = definitionMatchArray[n4];
                        boolean createExceptions = true;
                        ScriptDefinition def = this.getScriptDefinition(match.getDefinitionName(), match.getDefinitionID(), definitions);
                        if (def != null) {
                            finding.ruleId = this.scanRuleId;
                            boolean bl = createExceptions = !def.baseline(finding);
                        }
                        if (createExceptions && !policySet.isFiltered(this.scanRuleId, definitionName = (name = Definition.parseName(match.getDefinitionName()))[2], definitionCategory = name[0], definitionSubCategory = name[1], finding.getUrl())) {
                            DefinitionPolicyDescriptor desc = DefinitionPolicyDescriptor.createDefinitionPolicy((int)this.scanRuleId, match, finding.getUrl(), DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE);
                            desc.saveToDatabase(conn);
                        }
                        ++n4;
                    }
                    ++n2;
                }
                ScanRule.setScanDataObsolete(this.scanRuleId);
            }
            catch (ScanRule.ScanResultLoadFailureException e) {
                return false;
            }
            catch (NoDatabaseConnectionException e) {
                throw new RuleBaselineException("SQL Exception throw while baselining the rule", e);
            }
            catch (InvalidDefinitionException e) {
                throw new RuleBaselineException("Script could not be baselined (script is invalid)", e);
            }
            catch (DefinitionEvaluationException e) {
                throw new RuleBaselineException(e);
            }
            catch (DefinitionSetLoadException e) {
                throw new RuleBaselineException(e);
            }
            catch (InputValidationException e) {
                throw new RuleBaselineException(e);
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return true;
    }

    private ScriptDefinition getScriptDefinition(String name, int localID, DefinitionSet set) {
        Definition def = null;
        try {
            def = set.getDefinitionByLocalID(localID);
        }
        catch (NotFoundException e) {
            try {
                def = set.getDefinition(name);
            }
            catch (NotFoundException ex) {
                return null;
            }
        }
        if (def != null && def instanceof ScriptDefinition) {
            return (ScriptDefinition)def;
        }
        return null;
    }

    public final void addSeedUrls(URL[] urls) {
        if (urls == null) {
            throw new IllegalArgumentException("A URL to be added to the list cannot be null");
        }
        int c = 0;
        while (c < urls.length) {
            this.seedUrls.add(urls[c]);
            ++c;
        }
    }

    @Override
    public boolean canPause() {
        return false;
    }

    @Override
    public int getProgress() {
        if (this.getStatus() == WorkerThread.State.STOPPED) {
            return 0;
        }
        return this.resourcesScanned * 100 / this.scanCountLimit;
    }

    @Override
    public WorkerThread.State getStatus() {
        if (this.inScan && !this.terminate) {
            return WorkerThread.State.STARTED;
        }
        if (this.inScan && this.terminate) {
            return WorkerThread.State.STOPPING;
        }
        if (!this.inScan) {
            return WorkerThread.State.STOPPED;
        }
        return WorkerThread.State.STOPPED;
    }

    @Override
    public String getStatusDescription() {
        WorkerThread.State state = this.getStatus();
        if (state == WorkerThread.State.STARTED) {
            if (this.currentlyScanning == null) {
                return "Scan " + this.getProgress() + "% complete";
            }
            return "Scan " + this.getProgress() + "% complete. Currently scanning: " + this.currentlyScanning;
        }
        if (state == WorkerThread.State.STOPPED) {
            return "Not Scanning";
        }
        if (state == WorkerThread.State.STOPPING) {
            return "Scanner terminating";
        }
        return null;
    }

    @Override
    public String getTaskDescription() {
        return "Website scanner";
    }

    @Override
    public void pause() {
    }

    @Override
    public boolean reportsProgress() {
        return true;
    }

    @Override
    public void terminate() {
        this.terminate = true;
        CopyOnWriteArrayList<ScanRunner> threads = new CopyOnWriteArrayList<ScanRunner>(this.runningThreads);
        if (threads.size() > 0) {
            for (ScanRunner runner : threads) {
                runner.terminate();
            }
        }
    }

    public HttpSeekingScanResult getResult() {
        return this.lastScanResult;
    }

    @Override
    public void run() {
        try {
            this.lastScanResult = (HttpSeekingScanResult)this.doScan();
        }
        catch (ScanException e) {
            this.exceptionThrown = e;
            this.lastScanResult = null;
        }
    }

    @Override
    public Throwable getException() {
        return this.exceptionThrown;
    }

    public static class Finding {
        private URL url;
        private DefinitionMatch[] signatureMatches;
        private long scanRuleId;
        private FindingResult findingResult;

        public Finding(URL url, DefinitionMatch[] matches, long scanRuleId, FindingResult findingResult) {
            this.url = url;
            this.signatureMatches = new DefinitionMatch[matches.length];
            System.arraycopy(matches, 0, this.signatureMatches, 0, matches.length);
            this.scanRuleId = scanRuleId;
            this.findingResult = findingResult;
        }

        public Finding(URL url, Vector<DefinitionMatch> matches, long scanRuleId, FindingResult findingResult) {
            this.url = url;
            this.signatureMatches = new DefinitionMatch[matches.size()];
            matches.toArray(this.signatureMatches);
            this.scanRuleId = scanRuleId;
            this.findingResult = findingResult;
        }

        public Finding(URL url, long scanRuleId, FindingResult findingResult) {
            this(url, new Vector<DefinitionMatch>(), scanRuleId, findingResult);
        }

        public URL getUrl() {
            return this.url;
        }

        public FindingResult result() {
            return this.findingResult;
        }

        public DefinitionMatch[] getSignatureMatches() {
            DefinitionMatch[] matches = new DefinitionMatch[this.signatureMatches.length];
            System.arraycopy(this.signatureMatches, 0, matches, 0, this.signatureMatches.length);
            return matches;
        }

        public long getScanRuleID() {
            return this.scanRuleId;
        }
    }

    public static enum FindingResult {
        PARSE_FAILED,
        CONNECTION_FAILED,
        NOT_FOUND,
        PASSED,
        DEVIATIONS_DETECTED,
        URI_INVALID;

    }

    public static class LinkExtractionVisitor
    extends NodeVisitor {
        private URL parentURL;
        private Vector<URL> urls = new Vector();
        private int nodes = 0;

        public LinkExtractionVisitor(URL parentURL) {
            if (parentURL == null) {
                throw new IllegalArgumentException("The parent URL cannot be null");
            }
            this.parentURL = parentURL;
        }

        public int getNodesVisitedCount() {
            return this.nodes;
        }

        public LinkExtractionVisitor(URL parentURL, boolean shouldRecurseChildren) {
            super(shouldRecurseChildren);
            if (parentURL == null) {
                throw new IllegalArgumentException("The parent URL cannot be null");
            }
            this.parentURL = parentURL;
        }

        public void visitTag(Tag tag) {
            try {
                ++this.nodes;
                if (tag.getTagName().equalsIgnoreCase("a") && tag.getAttribute("href") != null) {
                    this.urls.add(new URL(this.parentURL, tag.getAttribute("href")));
                } else if (tag.getTagName().equalsIgnoreCase("img") && tag.getAttribute("src") != null) {
                    this.urls.add(new URL(this.parentURL, tag.getAttribute("src")));
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }

        public Vector<URL> getExtractedURLs() {
            return this.urls;
        }

        public void visitStringNode(Text string) {
        }
    }

    private static class ScanRecord {
        private URL url;
        private HttpDefinitionScanResult parentScanResult;
        private int currentLevel;

        public ScanRecord(URL url, HttpDefinitionScanResult parentScanResult, int currentLevel) {
            this.url = url;
            this.parentScanResult = parentScanResult;
            this.currentLevel = currentLevel;
        }

        public ScanRecord(URL url) {
            this.url = url;
            this.parentScanResult = null;
            this.currentLevel = 0;
        }

        public URL getURL() {
            return this.url;
        }

        public int getLevel() {
            return this.currentLevel;
        }
    }

    private class ScanRunner
    extends Thread {
        private HttpDefinitionScanRule.HttpSignatureScanResultWithParser result;
        private HttpDefinitionScanRule rule;
        private HttpDefinitionScanResult parentScanResult = null;
        private boolean done = false;
        private int level = 0;
        private Date ruleScanStartDate = null;

        public ScanRunner(ScanRecord record, DefinitionSet signatureSet, int level, HttpClient client, Date ruleScanStartDate) {
            this.rule = new HttpDefinitionScanRule(HttpSeekingScanRule.this.appRes, signatureSet, record.url, client);
            this.level = level;
            this.rule.setCallback(HttpSeekingScanRule.this.callback);
            this.ruleScanStartDate = ruleScanStartDate;
            if (record.parentScanResult != null) {
                this.parentScanResult = record.parentScanResult;
            }
            this.setName("HTTP Seeking Scan Rule: " + record.url.toString());
        }

        public int getLevel() {
            return this.level;
        }

        public HttpDefinitionScanRule.HttpSignatureScanResultWithParser getResult() {
            return this.result;
        }

        @Override
        public void run() {
            try {
                try {
                    this.rule.suppressLoggingToEventLog(true);
                    this.rule.scanRuleId = HttpSeekingScanRule.this.scanRuleId;
                    this.result = this.rule.doScanAndReturnParser(this.parentScanResult, this.ruleScanStartDate);
                }
                catch (IllegalStateException e) {
                    this.result = null;
                    this.done = true;
                }
                catch (Exception e) {
                    if (this.getUncaughtExceptionHandler() != null) {
                        this.getUncaughtExceptionHandler().uncaughtException(this, e);
                    }
                    HttpSeekingScanRule.this.exceptionThrown = e;
                    this.done = true;
                }
            }
            finally {
                this.done = true;
            }
        }

        public void terminate() {
            this.rule.terminate();
        }

        public boolean done() {
            return this.done;
        }
    }

    private class ScanThreadExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private URL url;

        public ScanThreadExceptionHandler(URL url) {
            this.url = url;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.SCAN_ENGINE_EXCEPTION, new EventLogField(EventLogField.FieldName.RULE_ID, HttpSeekingScanRule.this.scanRuleId), new EventLogField(EventLogField.FieldName.URL, this.url.toString()));
            HttpSeekingScanRule.this.appRes.logExceptionEvent(message, e);
        }
    }
}

