/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.SiteGroupScanResult;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.DefinitionMatch;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanResultLoader;
import net.lukemurphey.nsia.scan.ScanRule;

public class ScanData {
    protected Application application;
    protected SiteGroupManagement siteGroupManagement;

    public ScanData(Application app) {
        this.application = app;
        this.siteGroupManagement = new SiteGroupManagement(this.application);
    }

    public SiteGroupScanResult[] getSiteGroupStatus() throws SQLException, NoDatabaseConnectionException, ScanRule.ScanResultLoadFailureException {
        Connection connection = null;
        Statement siteGroupListStatment = null;
        ResultSet siteGroupResultSet = null;
        try {
            connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            siteGroupListStatment = connection.prepareStatement("Select * from SiteGroups");
            siteGroupResultSet = siteGroupListStatment.executeQuery();
            Vector<SiteGroupScanResult> siteGroupResultsVector = new Vector<SiteGroupScanResult>();
            while (siteGroupResultSet.next()) {
                SiteGroupScanResult currentResult;
                try {
                    currentResult = this.getSiteGroupStatus(siteGroupResultSet.getInt("SiteGroupID"));
                }
                catch (InputValidationException e) {
                    Application.getApplication().getEventLog().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR), e);
                    currentResult = null;
                }
                catch (NotFoundException e) {
                    Application.getApplication().getEventLog().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR), e);
                    currentResult = null;
                }
                if (currentResult == null) continue;
                siteGroupResultsVector.add(currentResult);
            }
            SiteGroupScanResult[] siteGroupResultsArray = new SiteGroupScanResult[siteGroupResultsVector.size()];
            int c = 0;
            while (c < siteGroupResultsVector.size()) {
                siteGroupResultsArray[c] = (SiteGroupScanResult)siteGroupResultsVector.get(c);
                ++c;
            }
            SiteGroupScanResult[] siteGroupScanResultArray = siteGroupResultsArray;
            return siteGroupScanResultArray;
        }
        finally {
            if (siteGroupResultSet != null) {
                siteGroupResultSet.close();
            }
            if (siteGroupListStatment != null) {
                siteGroupListStatment.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public DefinitionMatch[] getLastSignaturesMatched(int count) throws NoDatabaseConnectionException, SQLException {
        if (count <= 0) {
            throw new IllegalArgumentException("The count of entries to return must be greater than zero");
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Select RuleName, Severity, RuleID from MatchedRule inner join ScanResult on MatchedRule.ScanResultID = ScanResult.ScanResultID where ScanDate > ? group by RuleName, Severity, RuleID");
            statement.setMaxRows(count);
            Calendar cal = Calendar.getInstance();
            if (cal.get(2) == 1) {
                cal.set(2, 11);
                cal.set(1, cal.get(1) - 1);
            } else {
                cal.set(2, cal.get(2) - 1);
            }
            Date date = new Date(cal.getTime().getTime());
            statement.setDate(1, date);
            resultSet = statement.executeQuery();
            Vector<DefinitionMatch> dataVector = new Vector<DefinitionMatch>();
            while (resultSet.next()) {
                int severityID = resultSet.getInt("Severity");
                Definition.Severity severity = severityID == Definition.Severity.HIGH.ordinal() ? Definition.Severity.HIGH : (severityID == Definition.Severity.MEDIUM.ordinal() ? Definition.Severity.MEDIUM : (severityID == Definition.Severity.LOW.ordinal() ? Definition.Severity.LOW : Definition.Severity.UNDEFINED));
                DefinitionMatch entry = new DefinitionMatch(resultSet.getString("RuleName"), severity, resultSet.getInt("RuleID"));
                dataVector.add(entry);
            }
            DefinitionMatch[] signatureMatchArray = new DefinitionMatch[dataVector.size()];
            dataVector.toArray(signatureMatchArray);
            DefinitionMatch[] definitionMatchArray = signatureMatchArray;
            return definitionMatchArray;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    public SiteGroupScanResult getSiteGroupStatus(int siteGroupId) throws SQLException, InputValidationException, NoDatabaseConnectionException, NotFoundException, ScanRule.ScanResultLoadFailureException {
        SiteGroupManagement.SiteGroupDescriptor siteGroupDesc = this.siteGroupManagement.getGroupDescriptor(siteGroupId);
        ScanResult[] scanResults = this.getSiteGroupScanResults(siteGroupId);
        return new SiteGroupScanResult(siteGroupId, siteGroupDesc, scanResults);
    }

    public ScanResult getLastScanResult(long ruleId) throws SQLException, NoDatabaseConnectionException, ScanRule.ScanResultLoadFailureException {
        ScanResult scanResult = ScanResultLoader.getLastScanResult(ruleId);
        return scanResult;
    }

    public ScanResult getScanResult(long scanResultId) throws SQLException, NoDatabaseConnectionException, ScanRule.ScanResultLoadFailureException {
        ScanResult scanResult = ScanResultLoader.getScanResult(scanResultId);
        return scanResult;
    }

    public ScanResult[] getLastScanResults(long ruleId, int count) throws SQLException, NoDatabaseConnectionException, ScanRule.ScanResultLoadFailureException {
        return ScanResultLoader.getScanResults(ruleId, count);
    }

    public ScanResult[] getScanResults(long ruleId, long scanResultId, int count) throws SQLException, NoDatabaseConnectionException, ScanRule.ScanResultLoadFailureException {
        return ScanResultLoader.getScanResults(ruleId, scanResultId, count);
    }

    public String getRuleType(long ruleId) throws SQLException, NoDatabaseConnectionException {
        Statement statement = null;
        ResultSet result = null;
        Connection connection = null;
        try {
            connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Select * from ScanRule where ScanRuleID = ?");
            statement.setLong(1, ruleId);
            result = statement.executeQuery();
            if (result.next()) {
                String string = result.getString("RuleType");
                return string;
            }
            return null;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public ScanResult[] getSiteGroupScanResults(long siteGroupId) throws SQLException, NoDatabaseConnectionException, ScanRule.ScanResultLoadFailureException {
        Connection connection = null;
        Statement ruleStatement = null;
        ResultSet ruleResult = null;
        try {
            connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            ruleStatement = connection.prepareStatement("Select * from ScanRule where SiteGroupID = ? and State = ?");
            ruleStatement.setLong(1, siteGroupId);
            ruleStatement.setLong(2, 1L);
            ruleResult = ruleStatement.executeQuery();
            Vector<ScanResult> scanResultList = new Vector<ScanResult>();
            while (ruleResult.next()) {
                try {
                    ScanResult result;
                    long scanRuleId = ruleResult.getLong("ScanRuleID");
                    boolean isScanDataObsolete = ruleResult.getBoolean("ScanDataObsolete");
                    if (isScanDataObsolete || (result = ScanResultLoader.getLastScanResult(scanRuleId)) == null) continue;
                    scanResultList.add(result);
                }
                catch (ScanRule.ScanResultLoadFailureException e) {
                    this.application.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
                }
            }
            ScanResult[] scanResultListArray = new ScanResult[scanResultList.size()];
            int c = 0;
            while (c < scanResultList.size()) {
                scanResultListArray[c] = (ScanResult)scanResultList.get(c);
                ++c;
            }
            ScanResult[] scanResultArray = scanResultListArray;
            return scanResultArray;
        }
        finally {
            if (ruleResult != null) {
                ruleResult.close();
            }
            if (ruleStatement != null) {
                ruleStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }
}

