/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Hashtable;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.scan.ScanResultCode;
import net.lukemurphey.nsia.scan.ScanRule;

public abstract class ScanResult {
    protected ScanResultCode resultCode = ScanResultCode.UNREADY;
    protected int deviations = -1;
    protected int incompletes = -1;
    protected int accepts = -1;
    protected Timestamp scanTime;
    protected long ruleId = -1L;
    protected long scanResultId = -1L;
    protected long parentScanResultId = -1L;
    private static final long VALUE_NOT_SET = -1L;

    public int getDeviations() {
        return this.deviations;
    }

    public int getIncompletes() {
        return this.incompletes;
    }

    public int getAccepts() {
        return this.accepts;
    }

    public abstract String getRuleType();

    protected ScanResult(ScanResultCode scanResultCode, Timestamp timeOfScan) {
        this.resultCode = scanResultCode;
        this.scanTime = timeOfScan;
    }

    protected ScanResult(Connection connection, long scanResultId) throws SQLException, NoDatabaseConnectionException, ScanRule.ScanResultLoadFailureException {
        this.loadScanResultParams(connection, scanResultId);
    }

    protected ScanResult(ResultSet result) throws ScanRule.ScanResultLoadFailureException {
        try {
            if (!this.loadScanResult(result)) {
                throw new ScanRule.ScanResultLoadFailureException("Scan result could not be loaded correctly (result set contained no data)");
            }
        }
        catch (SQLException e) {
            throw new ScanRule.ScanResultLoadFailureException("Scan result could not be loaded correctly", e);
        }
    }

    public long getRuleID() {
        return this.ruleId;
    }

    protected void setScanResultID(long scanResultId) {
        if (scanResultId < -1L) {
            throw new IllegalArgumentException("The scan result identifier is invalid");
        }
        this.scanResultId = scanResultId;
    }

    public long getScanResultID() {
        return this.scanResultId;
    }

    public ScanResultCode getResultCode() {
        return this.resultCode;
    }

    public long getParentScanResultID() {
        return this.parentScanResultId;
    }

    public Timestamp getScanTime() {
        return this.scanTime;
    }

    public Hashtable<String, Object> toHashtable() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("ResultCode", this.getResultCode().getId());
        hashtable.put("ScanTime", Double.valueOf(this.scanTime.getTime()));
        hashtable.put("Deviations", this.deviations);
        return hashtable;
    }

    public abstract long saveToDatabase(Connection var1, long var2) throws SQLException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long saveToDatabaseInitial(Connection connection, long scanRuleId, String ruleType) throws SQLException {
        if (connection == null) {
            return -1L;
        }
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            statement = connection.prepareStatement("Insert into ScanResult(ScanRuleID, RuleType, ScanDate, Deviations, ScanResultCode, ParentScanResultID) values (?, ?, ?, -1, ?, ?)", 1);
            statement.setLong(1, scanRuleId);
            statement.setString(2, ruleType);
            statement.setTimestamp(3, this.scanTime);
            statement.setInt(4, this.resultCode.getId());
            statement.setLong(5, this.parentScanResultId);
            if (statement.executeUpdate() < 0) {
                return -1L;
            }
            result = statement.getGeneratedKeys();
            if (!result.next()) return -1L;
            long l = result.getLong(1);
            return l;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    protected boolean saveToDatabaseFinalize(Connection connection, long scanResultId, long deviations, long scanRuleId) throws SQLException {
        return this.saveToDatabaseFinalize(connection, scanResultId, deviations, 0L, 0L, scanRuleId);
    }

    protected boolean saveToDatabaseFinalize(Connection connection, long scanResultId, long deviations, long accepts, long incompletes, long scanRuleId) throws SQLException {
        if (connection == null) {
            return false;
        }
        if (deviations < 0L) {
            throw new IllegalArgumentException("Deviation count cannot be less than 0");
        }
        if (accepts < 0L) {
            throw new IllegalArgumentException("Accepted count cannot be less than 0");
        }
        if (incompletes < 0L) {
            throw new IllegalArgumentException("Incomplete count cannot be less than 0");
        }
        PreparedStatement statement = null;
        Statement statementUpdate = null;
        try {
            statement = connection.prepareStatement("Update ScanResult set Deviations = ?, Incompletes = ?, Accepts = ? where ScanResultID = ?");
            statement.setLong(1, deviations);
            statement.setLong(2, incompletes);
            statement.setLong(3, accepts);
            statement.setLong(4, scanResultId);
            if (statement.executeUpdate() < 0) {
                return false;
            }
            if (scanRuleId >= 0L) {
                statementUpdate = connection.prepareStatement("Update ScanRule set ScanDataObsolete = ? where ScanRuleID = ?");
                statementUpdate.setLong(1, 0L);
                statementUpdate.setLong(2, scanRuleId);
                statementUpdate.executeUpdate();
            }
            this.scanResultId = scanResultId;
            this.ruleId = scanRuleId;
            return true;
        }
        finally {
            if (statementUpdate != null) {
                statementUpdate.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    public abstract String getSpecimenDescription();

    protected boolean loadScanResult(ResultSet result) throws SQLException {
        try {
            if (result == null || !result.next()) {
                return false;
            }
            this.resultCode = ScanResultCode.getScanResultCodeById(result.getInt("ScanResultCode"));
            this.scanTime = result.getTimestamp("ScanDate");
            this.ruleId = result.getLong("ScanRuleID");
            this.deviations = result.getInt("Deviations");
            this.accepts = result.getInt("Accepts");
            this.incompletes = result.getInt("Incompletes");
            this.parentScanResultId = result.getLong("ParentScanResultID");
            return true;
        }
        finally {
            if (result != null) {
                result.close();
            }
        }
    }

    protected boolean loadScanResultParams(Connection connection, long scanResultId) throws SQLException, NoDatabaseConnectionException, ScanRule.ScanResultLoadFailureException {
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            if (connection == null) {
                throw new NoDatabaseConnectionException();
            }
            statement = connection.prepareStatement("Select * from ScanResult where ScanResultID = ?");
            statement.setLong(1, scanResultId);
            result = statement.executeQuery();
            boolean bl = this.loadScanResult(result);
            return bl;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }
}

