/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

public class ScanResultCode {
    private int id = 0;
    private String desc = null;
    public static final ScanResultCode UNREADY = new ScanResultCode(0, "Not Ready");
    public static final ScanResultCode SCAN_COMPLETED = new ScanResultCode(1, "Scan Completed");
    public static final ScanResultCode SCAN_FAILED = new ScanResultCode(2, "Scan failed to complete");
    public static final ScanResultCode READY = new ScanResultCode(3, "Ready");
    public static final ScanResultCode PENDING = new ScanResultCode(4, "Not Scanned Yet");
    public static final ScanResultCode SCAN_TERMINATED = new ScanResultCode(5, "Scan terminated");

    private ScanResultCode(int resultId, String description) {
        this.id = resultId;
        this.desc = description;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.desc;
    }

    public String getDescription() {
        return this.desc;
    }

    public static ScanResultCode getScanResultCodeById(int id) {
        if (id == UNREADY.getId()) {
            return UNREADY;
        }
        if (id == SCAN_COMPLETED.getId()) {
            return SCAN_COMPLETED;
        }
        if (id == READY.getId()) {
            return READY;
        }
        if (id == SCAN_FAILED.getId()) {
            return SCAN_FAILED;
        }
        if (id == SCAN_TERMINATED.getId()) {
            return SCAN_TERMINATED;
        }
        return null;
    }

    public boolean equals(ScanResultCode resultCode) {
        if (resultCode == null) {
            return false;
        }
        return this.id == resultCode.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ScanResultCode) {
            return this.equals((ScanResultCode)obj);
        }
        return false;
    }
}

