/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.MaxMinCount;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.scan.HttpDefinitionScanResult;
import net.lukemurphey.nsia.scan.HttpSeekingScanResult;
import net.lukemurphey.nsia.scan.HttpStaticScanResult;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanResultCode;
import net.lukemurphey.nsia.scan.ScanRule;
import net.lukemurphey.nsia.scan.ServiceScanResult;

public class ScanResultLoader {
    private static ScanResult getScanResult(long scanRuleId, long scanResultId) throws ScanRule.ScanResultLoadFailureException {
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        Exception initCause = null;
        try {
            connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            if (scanResultId == -1L) {
                statement = connection.prepareStatement("Select * from ScanResult where ScanRuleID = ? order by ScanDate desc");
                statement.setLong(1, scanRuleId);
            } else {
                statement = connection.prepareStatement("Select * from ScanResult where ScanResultID = ?");
                statement.setLong(1, scanResultId);
            }
            statement.setFetchSize(1);
            result = statement.executeQuery();
            ScanResult scanResult = ScanResultLoader.getResult(result);
            return scanResult;
        }
        catch (NoDatabaseConnectionException e) {
            initCause = e;
            throw new ScanRule.ScanResultLoadFailureException("The scan result could not be loaded", e);
        }
        catch (SQLException e) {
            initCause = e;
            throw new ScanRule.ScanResultLoadFailureException("The scan result could not be loaded", e);
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException ex) {
                if (ex.getCause() == null && initCause != null) {
                    ex.initCause(initCause);
                }
                throw new ScanRule.ScanResultLoadFailureException("The scan result could not be loaded", ex);
            }
        }
    }

    public static ScanResult getLastScanResult(long scanRuleId) throws ScanRule.ScanResultLoadFailureException {
        return ScanResultLoader.getScanResult(scanRuleId, -1L);
    }

    public static ScanResult getScanResult(long scanResultId) throws ScanRule.ScanResultLoadFailureException {
        return ScanResultLoader.getScanResult(-1L, scanResultId);
    }

    public static ScanResult[] getLinkedScanResults(long parentScanResultId) throws ScanRule.ScanResultLoadFailureException {
        Statement statement = null;
        ResultSet result = null;
        Connection connection = null;
        Exception initCause = null;
        try {
            connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            Vector<ScanResult> scanResults = new Vector<ScanResult>();
            statement = connection.prepareStatement("Select * from ScanResult where ParentScanResultID = ?");
            statement.setLong(1, parentScanResultId);
            result = statement.executeQuery();
            boolean endFound = false;
            while (!endFound) {
                ScanResult current = ScanResultLoader.getResult(result);
                if (current == null) {
                    endFound = true;
                    continue;
                }
                scanResults.add(current);
            }
            ScanResult[] scanResultArray = new ScanResult[scanResults.size()];
            scanResults.toArray(scanResultArray);
            ScanResult[] scanResultArray2 = scanResultArray;
            return scanResultArray2;
        }
        catch (NoDatabaseConnectionException e) {
            initCause = e;
            throw new ScanRule.ScanResultLoadFailureException("The scan result could not be loaded", e);
        }
        catch (SQLException e) {
            initCause = e;
            throw new ScanRule.ScanResultLoadFailureException("The scan result could not be loaded", e);
        }
        finally {
            block15: {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (result != null) {
                        result.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException ex) {
                    if (ex.getCause() != null || initCause == null) break block15;
                    ex.initCause(initCause);
                }
            }
        }
    }

    private static ScanResult getResult(ResultSet result) throws SQLException, NoDatabaseConnectionException, ScanRule.ScanResultLoadFailureException {
        ScanResult scanResult;
        if (!result.next()) {
            return null;
        }
        String ruleType = result.getString("RuleType");
        long scanResultId = result.getLong("ScanResultID");
        long parentScanResultId = result.getLong("ParentScanResultID");
        long scanRuleId = result.getLong("ScanRuleID");
        int deviations = result.getInt("Deviations");
        int incompletes = result.getInt("Incompletes");
        int accepts = result.getInt("Accepts");
        ScanResultCode scanResultCode = ScanResultCode.getScanResultCodeById(result.getInt("ScanResultCode"));
        Timestamp scanTime = result.getTimestamp("ScanDate");
        if (ruleType.matches("HTTP/Static")) {
            scanResult = HttpStaticScanResult.loadFromDatabase(scanRuleId, scanResultId, scanResultCode, scanTime, deviations, incompletes, accepts);
        } else if (ruleType.matches("HTTP/Autodiscovery")) {
            scanResult = HttpSeekingScanResult.loadFromDatabase(scanRuleId, scanResultId, scanResultCode, scanTime, deviations, incompletes, accepts);
        } else if (ruleType.matches("HTTP/SignatureScan")) {
            scanResult = HttpDefinitionScanResult.loadFromDatabase(scanRuleId, scanResultId, scanResultCode, scanTime, deviations);
        } else if (ruleType.matches("Service Scan")) {
            scanResult = ServiceScanResult.loadFromDatabase(scanRuleId, scanResultId, scanResultCode, scanTime, deviations, incompletes, accepts);
        } else {
            return null;
        }
        scanResult.setScanResultID(scanResultId);
        scanResult.parentScanResultId = parentScanResultId;
        return scanResult;
    }

    public static int getNumberOfScanResults(long scanRuleId) throws NoDatabaseConnectionException, SQLException {
        PreparedStatement statement = null;
        ResultSet result = null;
        Connection connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
        try {
            statement = connection.prepareStatement("Select count(*) from ScanResult where ScanRuleID = ?");
            statement.setLong(1, scanRuleId);
            result = statement.executeQuery();
            if (result != null && result.next()) {
                int n = result.getInt(1);
                return n;
            }
            return 0;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public static ScanResult[] getScanResults(long scanRuleId, int count) throws NoDatabaseConnectionException, SQLException, ScanRule.ScanResultLoadFailureException {
        return ScanResultLoader.getScanResults(scanRuleId, -1L, count);
    }

    public static ScanResult[] getScanResults(long scanRuleId, long firstScanResultId, int count) throws NoDatabaseConnectionException, SQLException, ScanRule.ScanResultLoadFailureException {
        return ScanResultLoader.getScanResults(scanRuleId, firstScanResultId, count, true);
    }

    public static long getMinEntry(long scanRuleId) throws NoDatabaseConnectionException, SQLException {
        return ScanResultLoader.getEntryNum(Application.getApplication(), scanRuleId, true);
    }

    public static long getMaxEntry(long scanRuleId) throws NoDatabaseConnectionException, SQLException {
        return ScanResultLoader.getEntryNum(Application.getApplication(), scanRuleId, false);
    }

    public static MaxMinCount getEntryInfo(long scanRuleId) throws NoDatabaseConnectionException, SQLException {
        if (scanRuleId < 0L) {
            throw new IllegalArgumentException("The scan rule ID must be greater than or equal to 0");
        }
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        Connection connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
        int max = -1;
        int min = -1;
        int count = 0;
        try {
            statement = connection.prepareStatement("Select Max(ScanResultID), Min(ScanResultID), Count(*) from ScanResult where ScanRuleID = ?");
            statement.setLong(1, scanRuleId);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                max = resultSet.getInt(1);
                min = resultSet.getInt(2);
                count = resultSet.getInt(3);
            }
            MaxMinCount maxMinCount = new MaxMinCount(max, min, count);
            return maxMinCount;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    private static long getEntryNum(Application application, long scanRuleId, boolean getMin) throws NoDatabaseConnectionException, SQLException {
        if (scanRuleId < 0L) {
            throw new IllegalArgumentException("The scan rule ID must be greater than or equal to 0");
        }
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        Connection connection = application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
        try {
            statement = getMin ? connection.prepareStatement("Select Min(ScanResultID) from ScanResult where ScanRuleID = ?") : connection.prepareStatement("Select Max(ScanResultID) from ScanResult where ScanRuleID = ?");
            statement.setLong(1, scanRuleId);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                long l = resultSet.getLong(1);
                return l;
            }
            return -1L;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    public static ScanResult[] getScanResults(long scanRuleId, long firstScanResultId, int count, boolean getResultsAfter) throws NoDatabaseConnectionException, SQLException, ScanRule.ScanResultLoadFailureException {
        if (count <= 0) {
            throw new IllegalArgumentException("The number of items to return must be greater than 0");
        }
        Statement statement = null;
        ResultSet result = null;
        Connection connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
        try {
            if (firstScanResultId == -1L) {
                statement = connection.prepareStatement("Select * from ScanResult where ScanRuleID = ? order by ScanDate desc");
                statement.setMaxRows(count);
                statement.setLong(1, scanRuleId);
            } else {
                statement = getResultsAfter ? connection.prepareStatement("Select * from ScanResult where ScanResultID >= ? and ScanRuleID = ? order by ScanDate asc") : connection.prepareStatement("Select * from ScanResult where ScanResultID <= ? and ScanRuleID = ? order by ScanDate desc");
                statement.setMaxRows(count);
                statement.setLong(1, firstScanResultId);
                statement.setLong(2, scanRuleId);
            }
            result = statement.executeQuery();
            Vector<ScanResult> scanResults = new Vector<ScanResult>();
            boolean endFound = false;
            while (!endFound) {
                ScanResult scanResult = ScanResultLoader.getResult(result);
                if (scanResult != null) {
                    scanResults.add(scanResult);
                    continue;
                }
                endFound = true;
            }
            ScanResult[] resultsArray = new ScanResult[scanResults.size()];
            if (getResultsAfter) {
                int c = 0;
                while (c < scanResults.size()) {
                    resultsArray[resultsArray.length - 1 - c] = (ScanResult)scanResults.get(c);
                    ++c;
                }
            } else {
                int c = 0;
                while (c < scanResults.size()) {
                    resultsArray[c] = (ScanResult)scanResults.get(c);
                    ++c;
                }
            }
            ScanResult[] scanResultArray = resultsArray;
            return scanResultArray;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }
}

