/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.scan.HttpSeekingScanRule;
import net.lukemurphey.nsia.scan.HttpStaticScanRule;
import net.lukemurphey.nsia.scan.ScanRule;
import net.lukemurphey.nsia.scan.ServiceScanRule;

public class ScanRuleLoader {
    public static ScanRule getScanRule(long ruleId) throws NotFoundException, NoDatabaseConnectionException, SQLException, ScanRule.ScanRuleLoadFailureException {
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        ScanRule scan = null;
        try {
            connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Select * from ScanRule where ScanRuleID = ?");
            statement.setLong(1, ruleId);
            result = statement.executeQuery();
            if (result.next()) {
                String ruleType = result.getString("RuleType");
                boolean isScanDataObsolete = result.getBoolean("ScanDataObsolete");
                if (ruleType.matches("HTTP/Static")) {
                    scan = new HttpStaticScanRule(Application.getApplication());
                    scan.loadFromDatabase(ruleId);
                    scan.scanDataObsolete = isScanDataObsolete;
                } else if (ruleType.matches("HTTP/Autodiscovery")) {
                    scan = new HttpSeekingScanRule(Application.getApplication());
                    scan.loadFromDatabase(ruleId);
                    scan.scanDataObsolete = isScanDataObsolete;
                } else if (ruleType.matches("Service Scan")) {
                    scan = new ServiceScanRule(Application.getApplication());
                    scan.loadFromDatabase(ruleId);
                    scan.scanDataObsolete = isScanDataObsolete;
                }
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        if (scan == null) {
            throw new NotFoundException("No rule exists with the given identifier");
        }
        return scan;
    }

    public static ScanRule[] getScanRules(long siteGroupId) throws NoDatabaseConnectionException, SQLException, NotFoundException, ScanRule.ScanRuleLoadFailureException {
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        Vector<ScanRule> scanRulesVector = new Vector<ScanRule>();
        try {
            connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Select * from ScanRule where SiteGroupID = ?");
            statement.setLong(1, siteGroupId);
            result = statement.executeQuery();
            ScanRule scan = null;
            while (result.next()) {
                String ruleType = result.getString("RuleType");
                long ruleId = result.getLong("ScanRuleID");
                boolean isScanDataObsolete = result.getBoolean("ScanDataObsolete");
                if (ruleType.matches("HTTP/Static")) {
                    scan = new HttpStaticScanRule(Application.getApplication());
                    scan.loadFromDatabase(ruleId);
                    scanRulesVector.add(scan);
                    scan.scanDataObsolete = isScanDataObsolete;
                    continue;
                }
                if (ruleType.matches("HTTP/Autodiscovery")) {
                    scan = new HttpSeekingScanRule(Application.getApplication());
                    scan.loadFromDatabase(ruleId);
                    scanRulesVector.add(scan);
                    scan.scanDataObsolete = isScanDataObsolete;
                    continue;
                }
                if (!ruleType.matches("Service Scan")) continue;
                scan = new ServiceScanRule(Application.getApplication());
                scan.loadFromDatabase(ruleId);
                scan.scanDataObsolete = isScanDataObsolete;
                scanRulesVector.add(scan);
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        ScanRule[] scanRules = new ScanRule[scanRulesVector.size()];
        int c = 0;
        while (c < scanRulesVector.size()) {
            scanRules[c] = (ScanRule)scanRulesVector.get(c);
            ++c;
        }
        return scanRules;
    }
}

