/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.scan.ScriptSignatureUtils;
import net.lukemurphey.nsia.scan.scriptenvironment.DeleteMethod;
import net.lukemurphey.nsia.scan.scriptenvironment.GetMethod;
import net.lukemurphey.nsia.scan.scriptenvironment.HeadMethod;
import net.lukemurphey.nsia.scan.scriptenvironment.JSoup;
import net.lukemurphey.nsia.scan.scriptenvironment.OptionsMethod;
import net.lukemurphey.nsia.scan.scriptenvironment.Parser;
import net.lukemurphey.nsia.scan.scriptenvironment.PostMethod;
import net.lukemurphey.nsia.scan.scriptenvironment.PutMethod;
import net.lukemurphey.nsia.scan.scriptenvironment.Result;
import net.lukemurphey.nsia.scan.scriptenvironment.TraceMethod;
import net.lukemurphey.nsia.scan.scriptenvironment.Vector;
import org.htmlparser.filters.TagNameFilter;

public class ScriptClassLoader
extends ClassLoader {
    private static java.util.Vector<String> WHITELIST = null;
    private static Hashtable<String, String> SHORTCUTS = null;
    private static final Object INITIALIZE_MUTEX = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptClassLoader() {
        super(ScriptClassLoader.class.getClassLoader());
        if (SHORTCUTS == null) {
            Object object = INITIALIZE_MUTEX;
            synchronized (object) {
                ScriptClassLoader.populateShortcuts();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateShortcuts() {
        Object object = INITIALIZE_MUTEX;
        synchronized (object) {
            Cloneable temp;
            if (SHORTCUTS == null) {
                temp = new Hashtable<String, String>();
                ((Hashtable)temp).put("ThreatScript.Result", Result.class.getName());
                ((Hashtable)temp).put("HTTP.URL", URL.class.getName());
                ((Hashtable)temp).put("HTTP.TagNameFilter", TagNameFilter.class.getName());
                ((Hashtable)temp).put("HTTP.JSoup", JSoup.class.getName());
                ((Hashtable)temp).put("HTTP.Parser", Parser.class.getName());
                ((Hashtable)temp).put("HTTP.GetRequest", GetMethod.class.getName());
                ((Hashtable)temp).put("HTTP.PostRequest", PostMethod.class.getName());
                ((Hashtable)temp).put("HTTP.DeleteRequest", DeleteMethod.class.getName());
                ((Hashtable)temp).put("HTTP.PutRequest", PutMethod.class.getName());
                ((Hashtable)temp).put("HTTP.TraceRequest", TraceMethod.class.getName());
                ((Hashtable)temp).put("HTTP.HeadRequest", HeadMethod.class.getName());
                ((Hashtable)temp).put("HTTP.OptionsRequest", OptionsMethod.class.getName());
                ((Hashtable)temp).put("ThreatScript.DataAnalysis", ScriptSignatureUtils.class.getName());
                ((Hashtable)temp).put("ThreatScript.Vector", Vector.class.getName());
                ((Hashtable)temp).put("ThreatScript.Date", Date.class.getName());
                ((Hashtable)temp).put("ThreatScript.Pattern", Pattern.class.getName());
                SHORTCUTS = temp;
            }
            if (WHITELIST == null) {
                temp = new java.util.Vector();
                ((java.util.Vector)temp).add("sun.org.mozilla.javascript.internal.ContextFactory");
                WHITELIST = temp;
            }
        }
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        String resolvedClass = SHORTCUTS.get(className);
        if (resolvedClass != null) {
            return super.loadClass(resolvedClass);
        }
        if (WHITELIST.contains(className)) {
            return super.loadClass(className);
        }
        throw new ClassNotFoundException("Class " + className + " not found");
    }
}

