/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.scan.LineParseException;
import net.lukemurphey.nsia.scan.NetworkPortRange;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanResultCode;
import net.lukemurphey.nsia.scan.ScanRule;

public class ServiceScanResult
extends ScanResult {
    private String address;
    private NetworkPortRange[] portsScanned;
    private NetworkPortRange[] portsExpectedOpen;
    private NetworkPortRange[] differencesObserved;

    private ServiceScanResult(ScanResultCode scanResultCode, Timestamp timeOfScan) {
        super(scanResultCode, timeOfScan);
    }

    protected ServiceScanResult(ScanResultCode scanResultCode, Timestamp timeOfScan, String address, NetworkPortRange[] portsScanned, NetworkPortRange[] portsExpectedOpen, NetworkPortRange[] portDifferences) {
        super(scanResultCode, timeOfScan);
        if (address == null || address.length() == 0) {
            throw new IllegalArgumentException("The address to scan must not be null or empty");
        }
        if (portsExpectedOpen == null) {
            throw new IllegalArgumentException("The expected port range must not be null");
        }
        if (portsScanned == null) {
            throw new IllegalArgumentException("The expected port range must not be null");
        }
        if (portsScanned.length == 0) {
            throw new IllegalArgumentException("The expected port range must have at least one entry");
        }
        if (portDifferences == null) {
            throw new IllegalArgumentException("The range of differences observed must not be null");
        }
        this.address = address;
        this.portsScanned = portsScanned;
        this.portsExpectedOpen = portsExpectedOpen;
        this.differencesObserved = portDifferences;
        this.deviations = 0;
        int c = 0;
        while (c < portDifferences.length) {
            if (portDifferences[c] != null) {
                this.deviations += portDifferences[c].getNumberOfPorts();
            }
            ++c;
        }
    }

    @Override
    public String getRuleType() {
        return "Service Scan";
    }

    @Override
    public String getSpecimenDescription() {
        return this.address;
    }

    @Override
    public long saveToDatabase(Connection connection, long scanRuleId) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException("The database connection cannot be null");
        }
        long scanResultId = this.saveToDatabaseInitial(connection, scanRuleId, "Service Scan");
        PreparedStatement statement = null;
        Vector<NetworkPortRange> portsUnexpectedOpenVector = new Vector<NetworkPortRange>();
        Vector<NetworkPortRange> portsUnexpectedClosedVector = new Vector<NetworkPortRange>();
        Vector<NetworkPortRange> portsUnexpectedNotRespondingVector = new Vector<NetworkPortRange>();
        NetworkPortRange[] networkPortRangeArray = this.differencesObserved;
        int n = this.differencesObserved.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkPortRange networkPortRange = networkPortRangeArray[n2];
            if (networkPortRange.getState() == NetworkPortRange.SocketState.CLOSED) {
                portsUnexpectedClosedVector.add(networkPortRange);
            } else if (networkPortRange.getState() == NetworkPortRange.SocketState.OPEN) {
                portsUnexpectedOpenVector.add(networkPortRange);
            } else {
                portsUnexpectedNotRespondingVector.add(networkPortRange);
            }
            ++n2;
        }
        NetworkPortRange[] portsUnexpectedOpen = new NetworkPortRange[portsUnexpectedOpenVector.size()];
        portsUnexpectedOpenVector.toArray(portsUnexpectedOpen);
        NetworkPortRange[] portsUnexpectedClosed = new NetworkPortRange[portsUnexpectedClosedVector.size()];
        portsUnexpectedClosedVector.toArray(portsUnexpectedClosed);
        NetworkPortRange[] portsUnexpectedNotResponding = new NetworkPortRange[portsUnexpectedNotRespondingVector.size()];
        portsUnexpectedNotRespondingVector.toArray(portsUnexpectedNotResponding);
        try {
            statement = connection.prepareStatement("Insert into ServiceScanResult (ScanResultID, PortsExpectedOpen, PortsScanned, PortsUnexpectedClosed, PortsUnexpectedOpen, PortsUnexpectedNotResponding, Server) values(?, ?, ?, ?, ?, ?, ?)");
            statement.setLong(1, scanResultId);
            statement.setString(2, NetworkPortRange.convertToString(this.portsExpectedOpen));
            statement.setString(3, NetworkPortRange.convertToString(this.portsScanned));
            statement.setString(4, NetworkPortRange.convertToString(portsUnexpectedClosed));
            statement.setString(5, NetworkPortRange.convertToString(portsUnexpectedOpen));
            statement.setString(6, NetworkPortRange.convertToString(portsUnexpectedNotResponding));
            statement.setString(7, this.address);
            statement.execute();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        this.incompletes = 0;
        this.accepts = 0;
        NetworkPortRange[] networkPortRangeArray2 = this.portsScanned;
        int n3 = this.portsScanned.length;
        int n4 = 0;
        while (n4 < n3) {
            NetworkPortRange scannedRange = networkPortRangeArray2[n4];
            this.accepts += scannedRange.getNumberOfPorts();
            ++n4;
        }
        this.accepts -= this.deviations;
        this.saveToDatabaseFinalize(connection, scanResultId, this.deviations, this.accepts, this.incompletes, scanRuleId);
        return scanResultId;
    }

    protected static ServiceScanResult loadFromDatabase(long scanRuleId, long scanResultId, ScanResultCode resultCode, Timestamp scanTime, int deviations, int incompletes, int accepts) throws SQLException, NoDatabaseConnectionException, ScanRule.ScanResultLoadFailureException {
        Application application = Application.getApplication();
        Connection connection = null;
        ServiceScanResult scanResult = new ServiceScanResult(resultCode, scanTime);
        scanResult.deviations = deviations;
        scanResult.incompletes = incompletes;
        scanResult.accepts = accepts;
        scanResult.ruleId = scanRuleId;
        scanResult.scanResultId = scanResultId;
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            connection = application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Select * from ServiceScanResult where ScanResultID = ?");
            statement.setLong(1, scanResultId);
            result = statement.executeQuery();
            if (result.next()) {
                NetworkPortRange networkPortRange;
                int n;
                int n2;
                NetworkPortRange[] networkPortRangeArray;
                scanResult.address = result.getString("Server");
                Vector<NetworkPortRange> differences = new Vector<NetworkPortRange>();
                try {
                    scanResult.portsScanned = NetworkPortRange.parseRange(result.getString("PortsScanned"));
                }
                catch (LineParseException e) {
                    throw new ScanRule.ScanResultLoadFailureException("The list of ports scanned could not be loaded", e);
                }
                try {
                    NetworkPortRange[] portsObservedOpen;
                    networkPortRangeArray = portsObservedOpen = NetworkPortRange.parseRange(result.getString("PortsUnexpectedOpen"));
                    n2 = portsObservedOpen.length;
                    n = 0;
                    while (n < n2) {
                        networkPortRange = networkPortRangeArray[n];
                        differences.add(new NetworkPortRange(networkPortRange.getStartPort(), networkPortRange.getEndPort(), networkPortRange.getProtocol(), NetworkPortRange.SocketState.OPEN));
                        ++n;
                    }
                }
                catch (LineParseException e) {
                    throw new ScanRule.ScanResultLoadFailureException("The list of ports that were observed unexpectedly open could not be loaded", e);
                }
                try {
                    NetworkPortRange[] portsObservedClosed;
                    networkPortRangeArray = portsObservedClosed = NetworkPortRange.parseRange(result.getString("PortsUnexpectedClosed"));
                    n2 = portsObservedClosed.length;
                    n = 0;
                    while (n < n2) {
                        networkPortRange = networkPortRangeArray[n];
                        differences.add(new NetworkPortRange(networkPortRange.getStartPort(), networkPortRange.getEndPort(), networkPortRange.getProtocol(), NetworkPortRange.SocketState.CLOSED));
                        ++n;
                    }
                }
                catch (LineParseException e) {
                    throw new ScanRule.ScanResultLoadFailureException("The list of ports that were observed unexpectedly closed could not be loaded", e);
                }
                try {
                    NetworkPortRange[] portsObservedNotResponding;
                    networkPortRangeArray = portsObservedNotResponding = NetworkPortRange.parseRange(result.getString("PortsUnexpectedNotResponding"));
                    n2 = portsObservedNotResponding.length;
                    n = 0;
                    while (n < n2) {
                        networkPortRange = networkPortRangeArray[n];
                        differences.add(new NetworkPortRange(networkPortRange.getStartPort(), networkPortRange.getEndPort(), networkPortRange.getProtocol(), NetworkPortRange.SocketState.NO_RESPONSE));
                        ++n;
                    }
                }
                catch (LineParseException e) {
                    throw new ScanRule.ScanResultLoadFailureException("The list of ports that were observed unexpectedly not responding could not be loaded", e);
                }
                try {
                    scanResult.portsExpectedOpen = NetworkPortRange.parseRange(result.getString("PortsExpectedOpen"));
                }
                catch (LineParseException e) {
                    throw new ScanRule.ScanResultLoadFailureException("The list of ports expected open could not be loaded", e);
                }
                scanResult.deviations = 0;
                for (NetworkPortRange diff : differences) {
                    scanResult.deviations += diff.getNumberOfPorts();
                }
                NetworkPortRange[] diffArray = new NetworkPortRange[differences.size()];
                differences.toArray(diffArray);
                scanResult.differencesObserved = diffArray;
                scanResult.portsScanned = NetworkPortRange.computeScannedResultRange(diffArray, scanResult.portsScanned, scanResult.portsExpectedOpen);
            }
            ServiceScanResult serviceScanResult = scanResult;
            return serviceScanResult;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
        }
    }

    protected static NetworkPortRange[] computeDifferences(NetworkPortRange[] expectedOpen, NetworkPortRange[] scanned, NetworkPortRange[] observedClosed, NetworkPortRange[] observedOpen) {
        NetworkPortRange portExpectedOpen;
        int n;
        int n2;
        NetworkPortRange[] networkPortRangeArray;
        boolean isExpectedOpen;
        int c;
        Vector<NetworkPortRange> differences = new Vector<NetworkPortRange>();
        NetworkPortRange[] networkPortRangeArray2 = observedOpen;
        int n3 = observedOpen.length;
        int n4 = 0;
        while (n4 < n3) {
            NetworkPortRange portObservedopen = networkPortRangeArray2[n4];
            c = 0;
            while (c < portObservedopen.getNumberOfPorts()) {
                isExpectedOpen = false;
                networkPortRangeArray = expectedOpen;
                n2 = expectedOpen.length;
                n = 0;
                while (n < n2) {
                    portExpectedOpen = networkPortRangeArray[n];
                    if (portExpectedOpen.getProtocol() == portObservedopen.getProtocol() && portExpectedOpen.getStartPort() >= portObservedopen.getStartPort() + c && portExpectedOpen.getStartPort() <= portObservedopen.getStartPort() + c) {
                        isExpectedOpen = true;
                        break;
                    }
                    ++n;
                }
                if (!isExpectedOpen) {
                    differences.add(new NetworkPortRange(portObservedopen.getStartPort() + c, portObservedopen.getProtocol(), NetworkPortRange.SocketState.OPEN));
                }
                ++c;
            }
            ++n4;
        }
        networkPortRangeArray2 = observedClosed;
        n3 = observedClosed.length;
        n4 = 0;
        while (n4 < n3) {
            NetworkPortRange portObservedClosed = networkPortRangeArray2[n4];
            c = 0;
            while (c < portObservedClosed.getNumberOfPorts()) {
                isExpectedOpen = false;
                networkPortRangeArray = expectedOpen;
                n2 = expectedOpen.length;
                n = 0;
                while (n < n2) {
                    portExpectedOpen = networkPortRangeArray[n];
                    if (portExpectedOpen.getProtocol() == portObservedClosed.getProtocol() && portExpectedOpen.getStartPort() >= portObservedClosed.getStartPort() + c && portExpectedOpen.getStartPort() <= portObservedClosed.getStartPort() + c) {
                        isExpectedOpen = true;
                        break;
                    }
                    ++n;
                }
                if (isExpectedOpen) {
                    differences.add(new NetworkPortRange(portObservedClosed.getStartPort() + c, portObservedClosed.getProtocol(), portObservedClosed.getState()));
                }
                ++c;
            }
            ++n4;
        }
        NetworkPortRange[] differencesArray = new NetworkPortRange[differences.size()];
        differences.toArray(differencesArray);
        return differencesArray;
    }

    public NetworkPortRange[] getDifferences() {
        NetworkPortRange[] result = new NetworkPortRange[this.differencesObserved.length];
        System.arraycopy(this.differencesObserved, 0, result, 0, result.length);
        return result;
    }

    public NetworkPortRange[] getPortsScanned() {
        NetworkPortRange[] result = new NetworkPortRange[this.portsScanned.length];
        System.arraycopy(this.portsScanned, 0, result, 0, result.length);
        return result;
    }

    public NetworkPortRange[] getPortsExpectedOpen() {
        NetworkPortRange[] result = new NetworkPortRange[this.portsExpectedOpen.length];
        System.arraycopy(this.portsExpectedOpen, 0, result, 0, result.length);
        return result;
    }
}

