/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.io.IOException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Vector;
import javax.script.ScriptException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.WorkerThread;
import net.lukemurphey.nsia.scan.DefinitionSetLoadException;
import net.lukemurphey.nsia.scan.LineParseException;
import net.lukemurphey.nsia.scan.NetworkPortRange;
import net.lukemurphey.nsia.scan.ScanException;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanResultCode;
import net.lukemurphey.nsia.scan.ScanResultLoader;
import net.lukemurphey.nsia.scan.ScanRule;
import net.lukemurphey.nsia.scan.ServiceScanResult;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.transport.socket.nio.SocketConnector;

public class ServiceScanRule
extends ScanRule
implements WorkerThread {
    public static final NetworkPortRange[] WELL_KNOWN_PORTS = new NetworkPortRange[]{new NetworkPortRange(1, 1023, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(1, 1023, NetworkPortRange.Protocol.UDP, NetworkPortRange.SocketState.UNDEFINED)};
    public static final NetworkPortRange[] COMMON_PORTS = new NetworkPortRange[]{new NetworkPortRange(20, 23, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(25, 25, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(43, 43, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(53, 53, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(53, 53, NetworkPortRange.Protocol.UDP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(68, 68, NetworkPortRange.Protocol.UDP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(69, 69, NetworkPortRange.Protocol.UDP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(79, 79, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(80, 80, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(110, 110, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(115, 115, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(119, 119, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(123, 123, NetworkPortRange.Protocol.UDP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(137, 137, NetworkPortRange.Protocol.UDP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(137, 137, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(138, 138, NetworkPortRange.Protocol.UDP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(138, 138, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(139, 139, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(139, 139, NetworkPortRange.Protocol.UDP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(143, 143, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(161, 161, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(161, 161, NetworkPortRange.Protocol.UDP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(162, 162, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(162, 162, NetworkPortRange.Protocol.UDP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(194, 194, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(194, 194, NetworkPortRange.Protocol.UDP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(220, 220, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED)};
    public static final NetworkPortRange[] ALL_PORTS = new NetworkPortRange[]{new NetworkPortRange(0, 65535, NetworkPortRange.Protocol.TCP, NetworkPortRange.SocketState.UNDEFINED), new NetworkPortRange(0, 65535, NetworkPortRange.Protocol.UDP, NetworkPortRange.SocketState.UNDEFINED)};
    public static final int SCAN_ALL = 0;
    public static final int SCAN_COMMON = 1;
    public static final int SCAN_WELL_KNOWN = 2;
    public static final int SCAN_CUSTOM = 3;
    public static final String RULE_TYPE = "Service Scan";
    private String address;
    private NetworkPortRange[] portsExpectedOpen = null;
    private NetworkPortRange[] portsToBeScanned = null;
    private Exception exceptionThrown = null;
    private int numberOfPortsToScan = 0;
    private int currentPort = 0;
    private boolean continueExecuting = true;
    private WorkerThread.State state = WorkerThread.State.INITIALIZED;
    private ScanResult lastScanResult = null;
    private Vector<PortScanResult> currentScanResults;

    public ServiceScanRule(Application applicationResources) {
        super(applicationResources);
    }

    public ServiceScanRule(Application application, String address, NetworkPortRange[] expectedOpenPortRange, NetworkPortRange[] scanPortRange) {
        super(application);
        if (address == null) {
            throw new IllegalArgumentException("The address to scan cannot be null");
        }
        if (address.isEmpty()) {
            throw new IllegalArgumentException("The address to scan cannot be empty");
        }
        if (expectedOpenPortRange == null) {
            throw new IllegalArgumentException("The expected port range cannot be null");
        }
        if (scanPortRange == null) {
            throw new IllegalArgumentException("The scan port range cannot be null");
        }
        if (scanPortRange.length == 0) {
            throw new IllegalArgumentException("The scan port range cannot be empty");
        }
        int c = 0;
        while (c < scanPortRange.length) {
            if (scanPortRange[c] == null) {
                throw new IllegalArgumentException("The scan port range contains a null entry");
            }
            this.numberOfPortsToScan += scanPortRange[c].getNumberOfPorts();
            ++c;
        }
        this.address = address;
        this.portsExpectedOpen = new NetworkPortRange[expectedOpenPortRange.length];
        this.portsToBeScanned = new NetworkPortRange[scanPortRange.length];
        System.arraycopy(expectedOpenPortRange, 0, this.portsExpectedOpen, 0, expectedOpenPortRange.length);
        System.arraycopy(scanPortRange, 0, this.portsToBeScanned, 0, scanPortRange.length);
    }

    @Override
    public void delete() throws SQLException, NoDatabaseConnectionException {
        ScanRule.deleteRule(this.getRuleId());
    }

    @Override
    public ScanResult doScan() throws ScanException {
        Timestamp timeOfScan = new Timestamp(System.currentTimeMillis());
        NetworkPortRange[] portDifferences = null;
        try {
            portDifferences = this.scanPortsAsync();
        }
        catch (IOException e) {
            throw new ScanException("The scan failed due to an exception", e);
        }
        ServiceScanResult result = new ServiceScanResult(ScanResultCode.SCAN_COMPLETED, timeOfScan, this.address, this.portsToBeScanned, this.portsExpectedOpen, portDifferences);
        this.logScanComplete(ScanResultCode.SCAN_COMPLETED, result.getDeviations(), RULE_TYPE, "", true, false);
        return result;
    }

    public NetworkPortRange[] getPortsToScan() {
        NetworkPortRange[] range = new NetworkPortRange[this.portsToBeScanned.length];
        System.arraycopy(this.portsToBeScanned, 0, range, 0, this.portsToBeScanned.length);
        return range;
    }

    public NetworkPortRange[] getPortsExpectedOpen() {
        NetworkPortRange[] range = new NetworkPortRange[this.portsExpectedOpen.length];
        System.arraycopy(this.portsExpectedOpen, 0, range, 0, this.portsExpectedOpen.length);
        return range;
    }

    public String getServerAddress() {
        return this.address;
    }

    @Override
    public String getRuleType() {
        return RULE_TYPE;
    }

    @Override
    public String getSpecimenDescription() {
        return this.address;
    }

    public String toString() {
        return "Scanner : Port Scan (" + this.address + ")";
    }

    public long saveToDatabase() throws IllegalStateException, SQLException, NoDatabaseConnectionException {
        if (this.scanRuleId == -1L) {
            throw new IllegalStateException("Scan rule must not be less than zero");
        }
        return this.saveToDatabaseEx(this.scanRuleId);
    }

    public long saveNewRuleToDatabase(long siteGroupId) throws IllegalStateException, SQLException, NoDatabaseConnectionException {
        if (siteGroupId < 0L) {
            throw new IllegalArgumentException("Site group identifer must not be less than zero");
        }
        return this.saveNewRuleToDatabaseEx(siteGroupId);
    }

    private synchronized long saveNewRuleToDatabaseEx(long siteGroupId) throws IllegalStateException, SQLException, NoDatabaseConnectionException {
        if (siteGroupId < -1L) {
            throw new IllegalArgumentException("Site group ID is invalid (must not be less than zero)");
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            this.scanRuleId = this.createRule(siteGroupId, this.getScanFrequency(), RULE_TYPE, 1);
            statement = connection.prepareStatement("Insert into ServiceScanRule (PortsOpen, PortsToScan, Server, ScanRuleID) values (?, ?, ?, ?)");
            statement.setString(1, NetworkPortRange.convertToString(this.portsExpectedOpen));
            statement.setString(2, NetworkPortRange.convertToString(this.portsToBeScanned));
            statement.setString(3, this.address);
            statement.setLong(4, this.scanRuleId);
            statement.execute();
            long l = this.scanRuleId;
            return l;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private synchronized long saveToDatabaseEx(long scanRuleId) throws IllegalStateException, SQLException, NoDatabaseConnectionException {
        if (scanRuleId < 0L) {
            throw new IllegalArgumentException("Scan rule ID is invalid (must not be less than zero)");
        }
        Connection connection = null;
        Statement statement = null;
        Statement generalStatement = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Update ServiceScanRule set PortsOpen = ?, PortsToScan = ?, Server = ? where ScanRuleID = ?");
            statement.setString(1, NetworkPortRange.convertToString(this.portsExpectedOpen));
            statement.setString(2, NetworkPortRange.convertToString(this.portsToBeScanned));
            statement.setString(3, this.address);
            statement.setLong(4, scanRuleId);
            statement.executeUpdate();
            this.scanRuleId = scanRuleId;
            generalStatement = connection.prepareStatement("Update ScanRule set ScanFrequency = ?, ScanDataObsolete = ? where ScanRuleID = ?");
            generalStatement.setInt(1, this.getScanFrequency());
            generalStatement.setBoolean(2, true);
            generalStatement.setLong(3, scanRuleId);
            generalStatement.executeUpdate();
            long l = this.scanRuleId;
            return l;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (generalStatement != null) {
                generalStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Override
    public boolean loadFromDatabase(long scanRuleId) throws NotFoundException, NoDatabaseConnectionException, SQLException, ScanRule.ScanRuleLoadFailureException {
        if (scanRuleId < 0L) {
            throw new IllegalArgumentException("The scan rule identifier must be greater than zero");
        }
        Connection connection = null;
        Statement statement = null;
        PreparedStatement generalRuleStatement = null;
        ResultSet generalRuleResult = null;
        ResultSet result = null;
        try {
            int scanFrequency;
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            generalRuleStatement = connection.prepareStatement("Select * from ScanRule where ScanRuleID = ?");
            generalRuleStatement.setLong(1, scanRuleId);
            generalRuleResult = generalRuleStatement.executeQuery();
            if (!generalRuleResult.next()) {
                return false;
            }
            this.scanFrequency = scanFrequency = generalRuleResult.getInt("ScanFrequency");
            this.scanRuleId = scanRuleId;
            statement = connection.prepareStatement("Select * from ServiceScanRule where ScanRuleID = ?");
            statement.setLong(1, scanRuleId);
            result = statement.executeQuery();
            if (!result.next()) {
                return false;
            }
            String portsOpen = result.getString("PortsOpen");
            String portsToScan = result.getString("PortsToScan");
            try {
                this.portsExpectedOpen = NetworkPortRange.parseRange(NetworkPortRange.SocketState.OPEN, portsOpen);
            }
            catch (LineParseException e) {
                throw new ScanRule.ScanRuleLoadFailureException("The scan rule could not be loaded, the expected ports list is invalid", e);
            }
            try {
                NetworkPortRange[] networkPortRangeArray = this.portsToBeScanned = NetworkPortRange.parseRange(NetworkPortRange.SocketState.OPEN, portsToScan);
                int n = this.portsToBeScanned.length;
                int n2 = 0;
                while (n2 < n) {
                    NetworkPortRange range = networkPortRangeArray[n2];
                    this.numberOfPortsToScan += range.getNumberOfPorts();
                    ++n2;
                }
            }
            catch (LineParseException e) {
                throw new ScanRule.ScanRuleLoadFailureException("The scan rule could not be loaded, the list of ports to scan is invalid", e);
            }
            this.address = result.getString("Server");
            return true;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
            if (generalRuleStatement != null) {
                generalRuleStatement.close();
            }
            if (generalRuleResult != null) {
                generalRuleResult.close();
            }
        }
    }

    @Override
    public ScanResult loadScanResult(long scanResultId) throws NotFoundException, NoDatabaseConnectionException, SQLException, ScanRule.ScanResultLoadFailureException {
        if (scanResultId < 0L) {
            throw new IllegalArgumentException("The scan result identifier must be greater than zero");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkPortRange[] scanPortsAsync() throws IOException {
        ServiceScanRule serviceScanRule = this;
        synchronized (serviceScanRule) {
            this.continueExecuting = true;
        }
        if (this.address == null || this.address.length() == 0) {
            throw new IllegalArgumentException("The address to scan must not be null or empty");
        }
        if (this.portsExpectedOpen == null) {
            throw new IllegalArgumentException("The expected port range must not be null");
        }
        if (this.portsToBeScanned == null) {
            throw new IllegalArgumentException("The port range to be scanned must not be null");
        }
        if (this.portsToBeScanned.length == 0) {
            throw new IllegalArgumentException("The port range to be scanned must have at least one entry");
        }
        SocketConnector connector = new SocketConnector();
        connector.getDefaultConfig().setConnectTimeout(30);
        Vector<ConnectFuture> inProgressScans = new Vector<ConnectFuture>();
        int asyncLimit = 200;
        this.currentScanResults = new Vector(100);
        NetworkPortRange[] networkPortRangeArray = this.portsToBeScanned;
        int n = this.portsToBeScanned.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkPortRange port = networkPortRangeArray[n2];
            int numberOfPorts = port.getNumberOfPorts();
            int c = 0;
            while (c < numberOfPorts) {
                ServiceScanRule serviceScanRule2 = this;
                synchronized (serviceScanRule2) {
                    if (!this.continueExecuting) {
                        break;
                    }
                }
                if (inProgressScans.size() >= asyncLimit) {
                    Iterator iterator = inProgressScans.iterator();
                    while (iterator.hasNext()) {
                        ConnectFuture cf = (ConnectFuture)iterator.next();
                        this.processConnection(cf);
                        iterator.remove();
                    }
                }
                int currentPortNum = port.getStartPort() + c;
                PortScanResult resultToAdd = new PortScanResult(currentPortNum, port.getProtocol());
                this.currentScanResults.add(resultToAdd);
                ConnectFuture cf = connector.connect((SocketAddress)new InetSocketAddress(this.address, currentPortNum), (IoHandler)new PortScanProtocolHandler(this, currentPortNum, port.getProtocol()));
                inProgressScans.add(cf);
                resultToAdd.connectFuture = cf;
                ++c;
            }
            ++n2;
        }
        for (ConnectFuture cf : inProgressScans) {
            this.processConnection(cf);
        }
        Vector<NetworkPortRange> deviations = new Vector<NetworkPortRange>();
        for (PortScanResult result : this.currentScanResults) {
            boolean isExpectedOpen = false;
            NetworkPortRange[] networkPortRangeArray2 = this.portsExpectedOpen;
            int n3 = this.portsExpectedOpen.length;
            int n4 = 0;
            while (n4 < n3) {
                NetworkPortRange expectedOpen = networkPortRangeArray2[n4];
                if (expectedOpen.getNumberOfPorts() > 0 && result.port >= expectedOpen.getStartPort() && result.port <= expectedOpen.getEndPort()) {
                    isExpectedOpen = true;
                }
                ++n4;
            }
            if ((result.state != NetworkPortRange.SocketState.OPEN || isExpectedOpen) && (result.state != NetworkPortRange.SocketState.CLOSED || !isExpectedOpen)) continue;
            deviations.add(new NetworkPortRange(result.port, result.protocol, result.state));
        }
        NetworkPortRange[] deviations_array = new NetworkPortRange[deviations.size()];
        deviations.toArray(deviations_array);
        this.state = WorkerThread.State.STOPPED;
        return deviations_array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConnection(ConnectFuture cf) {
        ConnectFuture connectFuture = cf;
        synchronized (connectFuture) {
            try {
                if (cf.getSession() == null && !cf.isConnected()) {
                    cf.wait(10000L);
                    cf.getSession();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (RuntimeIOException e) {
                if (e.getCause().getMessage().contains("timed out")) {
                    this.setResult(cf, NetworkPortRange.SocketState.NO_RESPONSE);
                }
                if (e.getCause().getMessage().contains("refused")) {
                    this.setResult(cf, NetworkPortRange.SocketState.CLOSED);
                }
                this.setResult(cf, NetworkPortRange.SocketState.NO_RESPONSE);
            }
        }
    }

    private void setResult(int port, NetworkPortRange.SocketState state, NetworkPortRange.Protocol protocol) {
        if (state == null) {
            throw new IllegalArgumentException("State cannot be null");
        }
        for (PortScanResult scanResult : this.currentScanResults) {
            if (scanResult.port != port || scanResult.protocol != protocol) continue;
            scanResult.state = state;
            scanResult.connectFuture = null;
            ++this.currentPort;
            this.logScanResult(ScanResultCode.SCAN_COMPLETED, 0, RULE_TYPE, null, false);
        }
    }

    private void setResult(ConnectFuture cf, NetworkPortRange.SocketState state) {
        if (state == null) {
            throw new IllegalArgumentException("State cannot be null");
        }
        for (PortScanResult scanResult : this.currentScanResults) {
            if (cf != scanResult.connectFuture) continue;
            scanResult.state = state;
            scanResult.connectFuture = null;
            ++this.currentPort;
            this.logScanResult(ScanResultCode.SCAN_COMPLETED, 0, RULE_TYPE, null, false);
        }
    }

    public static NetworkPortRange.SocketState scanPort(String address, int port, NetworkPortRange.Protocol protocol, int timeoutMilliseconds) throws IOException {
        if (protocol == NetworkPortRange.Protocol.TCP) {
            return ServiceScanRule.scanPortTCP(address, port, timeoutMilliseconds);
        }
        return ServiceScanRule.scanPortUDP(address, port, timeoutMilliseconds);
    }

    private static NetworkPortRange.SocketState scanPortTCP(String address, int port, int timeoutMilliseconds) throws IOException {
        Socket s = null;
        try {
            s = new Socket();
            InetSocketAddress addr = new InetSocketAddress(address, port);
            s.connect(addr, timeoutMilliseconds);
            if (s.getPort() == s.getLocalPort() && address.startsWith("127.")) {
                NetworkPortRange.SocketState socketState = NetworkPortRange.SocketState.CLOSED;
                return socketState;
            }
            NetworkPortRange.SocketState socketState = NetworkPortRange.SocketState.OPEN;
            return socketState;
        }
        catch (ConnectException e) {
            NetworkPortRange.SocketState socketState = NetworkPortRange.SocketState.CLOSED;
            return socketState;
        }
        catch (PortUnreachableException e) {
            NetworkPortRange.SocketState socketState = NetworkPortRange.SocketState.CLOSED;
            return socketState;
        }
        catch (SocketTimeoutException e) {
            NetworkPortRange.SocketState socketState = NetworkPortRange.SocketState.NO_RESPONSE;
            return socketState;
        }
        finally {
            s.close();
        }
    }

    private static NetworkPortRange.SocketState scanPortUDP(String address, int port, int timeoutMilliseconds) throws IOException {
        DatagramSocket s = null;
        try {
            s = new DatagramSocket();
            s.setSoTimeout(timeoutMilliseconds);
            s.connect(new InetSocketAddress(address, port));
            byte[] b = new byte[1];
            DatagramPacket dg = new DatagramPacket(b, 0);
            s.send(dg);
            dg = new DatagramPacket(b, 0);
            s.receive(dg);
            NetworkPortRange.SocketState socketState = NetworkPortRange.SocketState.OPEN;
            return socketState;
        }
        catch (PortUnreachableException pue) {
            NetworkPortRange.SocketState socketState = NetworkPortRange.SocketState.CLOSED;
            return socketState;
        }
        catch (SocketTimeoutException stoe) {
            NetworkPortRange.SocketState socketState = NetworkPortRange.SocketState.NO_RESPONSE;
            return socketState;
        }
        finally {
            s.close();
        }
    }

    @Override
    public boolean canPause() {
        return false;
    }

    @Override
    public int getProgress() {
        if (this.numberOfPortsToScan > 0) {
            return 100 * this.currentPort / this.numberOfPortsToScan;
        }
        return -1;
    }

    @Override
    public WorkerThread.State getStatus() {
        return this.state;
    }

    @Override
    public String getStatusDescription() {
        WorkerThread.State status = this.getStatus();
        if (status == WorkerThread.State.INITIALIZED || status == WorkerThread.State.STARTED || status == WorkerThread.State.STARTING) {
            return "Scanned " + this.currentPort + " of " + this.numberOfPortsToScan + " ports";
        }
        if (status == WorkerThread.State.STOPPING) {
            return "Service scan stopping";
        }
        return "Service scan stopped";
    }

    @Override
    public void pause() {
    }

    @Override
    public boolean reportsProgress() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        ServiceScanRule serviceScanRule = this;
        synchronized (serviceScanRule) {
            this.state = WorkerThread.State.STOPPING;
            this.continueExecuting = false;
        }
    }

    @Override
    public String getTaskDescription() {
        return "Service Scan:" + this.scanRuleId;
    }

    public ScanResult getLastScanResult() {
        return this.lastScanResult;
    }

    @Override
    public void run() {
        try {
            this.state = WorkerThread.State.STARTED;
            this.lastScanResult = this.doScan();
        }
        catch (ScanException e) {
            this.exceptionThrown = e;
        }
    }

    public void setServerAddress(String serverAddress) {
        if (this.address == null) {
            throw new IllegalArgumentException("The address to scan cannot be null");
        }
        if (this.address.isEmpty()) {
            throw new IllegalArgumentException("The address to scan cannot be empty");
        }
        this.address = serverAddress;
    }

    public void setPortsToScan(NetworkPortRange[] portsToScan) {
        if (portsToScan == null) {
            throw new IllegalArgumentException("The ports to scan cannot be null");
        }
        this.portsToBeScanned = new NetworkPortRange[portsToScan.length];
        System.arraycopy(portsToScan, 0, this.portsToBeScanned, 0, this.portsToBeScanned.length);
    }

    public synchronized boolean baseline() throws SQLException, NoDatabaseConnectionException, DefinitionSetLoadException, InputValidationException, ScriptException, IOException {
        Connection conn = null;
        try {
            if (this.scanRuleId < 0L) {
                return false;
            }
            try {
                conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
                ServiceScanResult result = (ServiceScanResult)ScanResultLoader.getLastScanResult(this.scanRuleId);
                NetworkPortRange[] diff = result.getDifferences();
                Vector<NetworkPortRange> newExpectedOpen = new Vector<NetworkPortRange>();
                NetworkPortRange[] networkPortRangeArray = this.portsExpectedOpen;
                int n = this.portsExpectedOpen.length;
                int n2 = 0;
                while (n2 < n) {
                    NetworkPortRange networkPortRange = networkPortRangeArray[n2];
                    newExpectedOpen.add(networkPortRange);
                    ++n2;
                }
                Vector<NetworkPortRange> toRemoveFromExpectedOpen = new Vector<NetworkPortRange>();
                Vector<NetworkPortRange> toAddToExpectedOpen = new Vector<NetworkPortRange>();
                NetworkPortRange[] networkPortRangeArray2 = diff;
                int n3 = diff.length;
                int n4 = 0;
                while (n4 < n3) {
                    NetworkPortRange networkPortRange = networkPortRangeArray2[n4];
                    if (networkPortRange.getState() == NetworkPortRange.SocketState.CLOSED || networkPortRange.getState() == NetworkPortRange.SocketState.NO_RESPONSE) {
                        toRemoveFromExpectedOpen.add(networkPortRange);
                    } else if (networkPortRange.getState() == NetworkPortRange.SocketState.OPEN) {
                        toAddToExpectedOpen.add(networkPortRange);
                    }
                    ++n4;
                }
                NetworkPortRange[] expectedOpen = result.getPortsExpectedOpen();
                Vector<NetworkPortRange> expectedOpenNew = new Vector<NetworkPortRange>();
                NetworkPortRange[] networkPortRangeArray3 = expectedOpen;
                int n5 = expectedOpen.length;
                int n6 = 0;
                while (n6 < n5) {
                    NetworkPortRange networkPortRange = networkPortRangeArray3[n6];
                    expectedOpenNew.add(networkPortRange);
                    ++n6;
                }
                for (NetworkPortRange networkPortRange : toAddToExpectedOpen) {
                    expectedOpenNew.add(networkPortRange);
                }
                Vector<NetworkPortRange> expectedOpenNew2 = new Vector<NetworkPortRange>();
                for (NetworkPortRange removeRange : toRemoveFromExpectedOpen) {
                    for (NetworkPortRange existingRange : expectedOpenNew) {
                        if (existingRange.overlapsWith(removeRange, true)) {
                            NetworkPortRange[] ranges;
                            NetworkPortRange[] networkPortRangeArray4 = ranges = NetworkPortRange.removeFromRange(existingRange, removeRange);
                            int n7 = ranges.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                NetworkPortRange splitRange = networkPortRangeArray4[n8];
                                expectedOpenNew2.add(splitRange);
                                ++n8;
                            }
                            continue;
                        }
                        expectedOpenNew2.add(existingRange);
                    }
                }
                NetworkPortRange[] portsExceptionOpenFile = new NetworkPortRange[expectedOpenNew2.size()];
                expectedOpenNew2.toArray(portsExceptionOpenFile);
                this.portsExpectedOpen = portsExceptionOpenFile;
                this.saveToDatabase();
                ScanRule.setScanDataObsolete(this.scanRuleId);
            }
            catch (ScanRule.ScanResultLoadFailureException e) {
                return false;
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return true;
    }

    public void setPortsExpectedOpen(NetworkPortRange[] portsExpectedOpen) {
        if (portsExpectedOpen == null) {
            throw new IllegalArgumentException("The ports to scan cannot be null");
        }
        this.portsExpectedOpen = new NetworkPortRange[portsExpectedOpen.length];
        System.arraycopy(portsExpectedOpen, 0, this.portsExpectedOpen, 0, this.portsExpectedOpen.length);
    }

    @Override
    public Throwable getException() {
        return this.exceptionThrown;
    }

    private static class PortScanProtocolHandler
    extends IoHandlerAdapter {
        private ServiceScanRule scanRule;
        private int port;
        private NetworkPortRange.Protocol protocol;

        public PortScanProtocolHandler(ServiceScanRule scanRule, int port, NetworkPortRange.Protocol protocol) {
            if (scanRule == null) {
                throw new IllegalArgumentException("The reference to the service scan rule that executing the scan cannot be null (otherwise, the results cannot be reported back");
            }
            if (protocol == null) {
                throw new IllegalArgumentException("The protocol cannot be null");
            }
            this.port = port;
            this.scanRule = scanRule;
            this.protocol = protocol;
        }

        public void exceptionCaught(IoSession session, Throwable t) throws Exception {
            session.close();
        }

        public void sessionOpened(IoSession session) {
            this.scanRule.setResult(this.port, NetworkPortRange.SocketState.OPEN, this.protocol);
            session.close();
        }

        public void sessionClosed(IoSession session) {
        }

        public void sessionIdle(IoSession session, IdleStatus status) {
            if (status == IdleStatus.READER_IDLE) {
                session.close();
            }
        }

        public void messageReceived(IoSession session, Object message) {
        }
    }

    private static class PortScanResult {
        public int port;
        public NetworkPortRange.Protocol protocol;
        public NetworkPortRange.SocketState state;
        public ConnectFuture connectFuture;

        public PortScanResult(int port, NetworkPortRange.Protocol protocol) {
            this.port = port;
            this.protocol = protocol;
            this.connectFuture = null;
        }
    }
}

