/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.scan.DataSpecimen;

public class SpecimenSnapshot {
    private byte[] data;
    private Charset encoding;
    private Date observedTime;
    private String mimeType;
    private int specimenId = -1;
    private int scanResultId = -1;
    private String filename;
    private int actualLength;
    private Application application;

    private SpecimenSnapshot() {
    }

    public SpecimenSnapshot(String mimeType, String encoding, URL url, int actualLength, Date observedTime, byte[] bytes, Application app) {
        this(mimeType, Charset.forName(encoding), url, actualLength, observedTime, bytes, app);
    }

    public SpecimenSnapshot(String mimeType, Charset encoding, URL url, int actualLength, Date observedTime, byte[] bytes, Application app) {
        this.mimeType = mimeType;
        this.encoding = encoding;
        this.filename = url.toExternalForm();
        this.actualLength = actualLength;
        this.observedTime = observedTime;
        this.data = new byte[bytes.length];
        System.arraycopy(bytes, 0, this.data, 0, bytes.length);
        this.application = app;
    }

    public SpecimenSnapshot(int actualLength, Date observedTime, DataSpecimen dataSpecimen) {
        if (observedTime == null) {
            throw new IllegalArgumentException("The observed time argument cannot be null");
        }
        if (dataSpecimen == null) {
            throw new IllegalArgumentException("The data specimen argument cannot be null");
        }
        this.mimeType = dataSpecimen.getContentType();
        this.data = dataSpecimen.getBytes();
        this.filename = dataSpecimen.getFilename();
        this.actualLength = actualLength;
        this.observedTime = observedTime;
    }

    public SpecimenSnapshot(Date observedTime, DataSpecimen dataSpecimen) {
        if (observedTime == null) {
            throw new IllegalArgumentException("The observed time argument cannot be null");
        }
        if (dataSpecimen == null) {
            throw new IllegalArgumentException("The data specimen argument cannot be null");
        }
        this.mimeType = dataSpecimen.getContentType();
        this.data = dataSpecimen.getBytes();
        this.filename = dataSpecimen.getFilename();
        this.actualLength = -1;
        this.observedTime = observedTime;
    }

    public String getDataAsString() {
        return new String(this.data, this.encoding);
    }

    public byte[] getData() {
        return this.data;
    }

    public int getActualLength() {
        return this.actualLength;
    }

    public String getFilename() {
        return this.filename;
    }

    public int specimenID() {
        return this.specimenId;
    }

    public int getScanResultID() {
        return this.scanResultId;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Date getObservedDate() {
        return this.observedTime;
    }

    public static SpecimenSnapshot loadBySpecimenID(int specimenId, Application app) throws SQLException, NotFoundException, NoDatabaseConnectionException {
        if (app == null) {
            throw new IllegalArgumentException("The application object cannot be null");
        }
        Statement preparedStatement = null;
        ResultSet result = null;
        Connection connection = null;
        try {
            connection = app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            preparedStatement = connection.prepareStatement("Select * from SpecimenArchive where SpecimenID = ?");
            preparedStatement.setInt(1, specimenId);
            result = preparedStatement.executeQuery();
            if (result.next()) {
                SpecimenSnapshot specimenSnapshot = SpecimenSnapshot.loadFromRow(result, app);
                return specimenSnapshot;
            }
            throw new NotFoundException("A specimen could not be found that matches the identifier given");
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (result != null) {
                result.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public static SpecimenSnapshot[] loadByScanResultID(int scanResultID, Application app) throws SQLException, NoDatabaseConnectionException {
        if (app == null) {
            throw new IllegalArgumentException("The application object cannot be null");
        }
        Statement preparedStatement = null;
        ResultSet result = null;
        Connection connection = null;
        Vector<SpecimenSnapshot> snapshots = new Vector<SpecimenSnapshot>();
        try {
            connection = app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            preparedStatement = connection.prepareStatement("Select * from SpecimenArchive where ScanResultID = ?");
            preparedStatement.setInt(1, scanResultID);
            result = preparedStatement.executeQuery();
            while (result.next()) {
                snapshots.add(SpecimenSnapshot.loadFromRow(result, app));
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (result != null) {
                result.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        SpecimenSnapshot[] snapshotsArray = new SpecimenSnapshot[snapshots.size()];
        snapshots.toArray(snapshotsArray);
        return snapshotsArray;
    }

    public static SpecimenSnapshot load(URL url, Date observedDate, Application app) throws SQLException, NoDatabaseConnectionException, NotFoundException {
        if (app == null) {
            throw new IllegalArgumentException("The application object cannot be null");
        }
        Statement preparedStatement = null;
        ResultSet result = null;
        Connection connection = null;
        try {
            connection = app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            preparedStatement = connection.prepareStatement("Select * from SpecimenArchive where URL = ? and DateObserved = ?");
            preparedStatement.setString(1, url.toString());
            preparedStatement.setDate(2, new java.sql.Date(observedDate.getTime()));
            result = preparedStatement.executeQuery();
            if (result.next()) {
                SpecimenSnapshot specimenSnapshot = SpecimenSnapshot.loadFromRow(result, app);
                return specimenSnapshot;
            }
            throw new NotFoundException("A specimen could not be found that matches the identifier given");
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (result != null) {
                result.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws SQLException, NoDatabaseConnectionException {
        SpecimenSnapshot specimenSnapshot = this;
        synchronized (specimenSnapshot) {
            if (this.specimenId < 0) {
                this.insert();
            } else {
                this.update();
            }
        }
    }

    private void update() throws SQLException, NoDatabaseConnectionException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Update SpecimenArchive Set ScanResultID = ?, Encoding = ?, DateObserved = ?, Data = ?, MimeType = ?, URL = ?, ActualLength = ? where SpecimenID = ?");
            statement.setInt(1, this.scanResultId);
            statement.setString(2, this.encoding.displayName());
            statement.setDate(3, new java.sql.Date(this.observedTime.getTime()));
            statement.setBytes(4, this.data);
            statement.setString(5, this.mimeType);
            statement.setString(6, this.filename);
            statement.setInt(7, this.actualLength);
            statement.setInt(8, this.specimenId);
            statement.executeUpdate();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    private void insert() throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        try {
            connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Insert into SpecimenArchive (ScanResultID, Encoding, DateObserved, Data, MimeType, URL, ActualLength) values (?,?,?,?,?,?,?)", 1);
            statement.setInt(1, this.scanResultId);
            statement.setString(2, this.encoding.displayName());
            statement.setDate(3, new java.sql.Date(this.observedTime.getTime()));
            statement.setBytes(4, this.data);
            statement.setString(5, this.mimeType);
            statement.setString(6, this.filename);
            statement.setInt(7, this.actualLength);
            statement.execute();
            resultSet = statement.getGeneratedKeys();
            this.specimenId = resultSet.next() ? resultSet.getInt(1) : -1;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    private static SpecimenSnapshot loadFromRow(ResultSet result, Application app) throws SQLException {
        SpecimenSnapshot snapshot = new SpecimenSnapshot();
        snapshot.specimenId = result.getInt("SpecimentID");
        snapshot.scanResultId = result.getInt("ScanResultID");
        snapshot.actualLength = result.getInt("ActualLength");
        snapshot.application = app;
        Blob dataBlob = result.getBlob("Data");
        snapshot.data = dataBlob.getBytes(0L, Integer.MAX_VALUE);
        String encoding = result.getString("Encoding");
        snapshot.encoding = Charset.forName(encoding);
        snapshot.mimeType = result.getString("MimeType");
        snapshot.observedTime = result.getDate("DateObserved");
        snapshot.filename = result.getString("URL");
        return snapshot;
    }
}

