/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan.scriptenvironment;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.lukemurphey.nsia.scan.HttpResponseData;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.TraceMethod;

public class WebClient {
    HttpMethodBase method = null;
    URL url = null;
    int downloadTimeoutSeconds = 5;
    int downloadBytesMax = 262144;
    Object httpMethodMutex = new Object();
    boolean timeOutReached = false;

    public WebClient(HttpMethod httpMethod, String url) throws MalformedURLException {
        if (url == null) {
            throw new IllegalArgumentException("The URL cannot be null");
        }
        this.initialize(httpMethod, new URL(url));
    }

    public WebClient(HttpMethod httpMethod, URL url) {
        this.initialize(httpMethod, url);
    }

    private void initialize(HttpMethod httpMethod, URL url) {
        if (url == null) {
            throw new IllegalArgumentException("The URL cannot be null");
        }
        this.url = url;
        if (httpMethod == HttpMethod.HEAD) {
            this.method = new HeadMethod(url.toString());
        } else if (httpMethod == HttpMethod.GET) {
            this.method = new GetMethod(url.toString());
        } else if (httpMethod == HttpMethod.POST) {
            this.method = new PostMethod(url.toString());
        } else if (httpMethod == HttpMethod.PUT) {
            this.method = new PutMethod(url.toString());
        } else if (httpMethod == HttpMethod.DELETE) {
            this.method = new DeleteMethod(url.toString());
        } else if (httpMethod == HttpMethod.TRACE) {
            this.method = new TraceMethod(url.toString());
        } else if (httpMethod == HttpMethod.OPTIONS) {
            this.method = new OptionsMethod(url.toString());
        }
    }

    public void setTimeLimit(int seconds) {
        this.downloadTimeoutSeconds = seconds;
    }

    public void setSizeLimit(int bytes) {
        if (bytes <= 0) {
            throw new IllegalArgumentException("Maximum number of bytes to download must be greater than 0");
        }
        this.downloadBytesMax = bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResult run() throws HttpException, IOException {
        HttpResult httpResult;
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost(this.url.getHost(), this.url.getPort(), this.url.getProtocol());
        HttpClient httpClient = new HttpClient();
        TimeoutThread timeoutThread = new TimeoutThread();
        timeoutThread.setName("Timeout for Web-client to " + this.url);
        timeoutThread.start();
        try {
            this.method.setFollowRedirects(true);
            httpClient.executeMethod(hostConfig, (org.apache.commons.httpclient.HttpMethod)this.method);
            HttpResponseData httpResponse = new HttpResponseData((org.apache.commons.httpclient.HttpMethod)this.method, this.downloadBytesMax);
            httpResult = new HttpResult(httpResponse, this.timeOutReached);
        }
        catch (Throwable throwable) {
            this.method.releaseConnection();
            Object object = this.httpMethodMutex;
            synchronized (object) {
                this.httpMethodMutex.notify();
                timeoutThread.terminate();
            }
            throw throwable;
        }
        this.method.releaseConnection();
        Object object = this.httpMethodMutex;
        synchronized (object) {
            this.httpMethodMutex.notify();
            timeoutThread.terminate();
        }
        return httpResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object object = this.httpMethodMutex;
        synchronized (object) {
            this.method.abort();
        }
    }

    public static enum HttpMethod {
        HEAD,
        GET,
        POST,
        PUT,
        DELETE,
        TRACE,
        OPTIONS;

    }

    public static class HttpResult {
        HttpResponseData httpResponse;
        boolean timeOutReached = false;

        public HttpResult(HttpResponseData response, boolean timeOutReached) {
            this.httpResponse = response;
            this.timeOutReached = timeOutReached;
        }

        public String getResponseBodyAsString() {
            return this.httpResponse.getResponseAsString();
        }

        public byte[] getResponseBodyAsBytes() {
            return this.httpResponse.getResponseAsBytes();
        }

        public String getFinalLocation() {
            return this.httpResponse.getLocation();
        }

        public String getRequestedLocation() {
            return this.httpResponse.getRequestedLocation();
        }

        public String getHeaderValue(String headerName) {
            return this.httpResponse.getHeaderValue(headerName);
        }

        public String getQueryString() {
            return this.httpResponse.getQueryString();
        }

        public String getContentType() {
            return this.httpResponse.getContentType();
        }

        public StatusLine getStatusLine() {
            return this.httpResponse.getStatusLine();
        }

        public int getResponseCode() {
            return this.httpResponse.getResponseCode();
        }

        public boolean sizeLimitReached() {
            return this.httpResponse.wasDownloadLimitReached();
        }

        public boolean timeOutReached() {
            return this.timeOutReached;
        }
    }

    private class TimeoutThread
    extends Thread {
        private boolean stop = false;

        private TimeoutThread() {
        }

        public void terminate() {
            this.stop = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long start = System.currentTimeMillis();
                long waitFor = WebClient.this.downloadTimeoutSeconds * 1000;
                Object object = WebClient.this.httpMethodMutex;
                synchronized (object) {
                    if (!this.stop) {
                        WebClient.this.httpMethodMutex.wait(waitFor);
                    }
                }
                if ((System.currentTimeMillis() - start) * 1000L >= waitFor) {
                    WebClient.this.method.abort();
                    WebClient.this.timeOutReached = true;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

