/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.support;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import net.lukemurphey.nsia.rest.DefinitionsDownload;
import net.lukemurphey.nsia.rest.RESTRequestFailedException;
import net.lukemurphey.nsia.scan.DefinitionArchive;
import net.lukemurphey.nsia.scan.DefinitionSet;

public class DefinitionDownload {
    public static final String APPLICATION_NAME = "definition_download";

    public static void main(String[] args) {
        String outputFileName;
        JSAP jsap = null;
        try {
            jsap = DefinitionDownload.getCommandLineProcessor();
        }
        catch (JSAPException e) {
            System.out.println("Could not get a command-line parser");
            e.printStackTrace();
            System.exit(1);
        }
        JSAPResult commandLineData = jsap.parse(args);
        if (!commandLineData.success()) {
            System.err.println();
            System.err.println("Usage: definition_download");
            System.err.println(jsap.getHelp());
            System.exit(1);
        }
        boolean verbose = false;
        if (commandLineData.getBoolean("verbose")) {
            verbose = true;
        }
        String licenseKey = commandLineData.getString("licenseKey");
        DefinitionSet.DefinitionVersionID definitionVersionID = null;
        try {
            definitionVersionID = DefinitionArchive.getLatestAvailableDefinitionSetID();
        }
        catch (RESTRequestFailedException e) {
            System.out.println("Unable to get version of current definitions: " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("Unable to get version of current definitions: " + e.getMessage());
        }
        if (definitionVersionID != null && verbose) {
            System.out.println("Current definition set ID: " + definitionVersionID);
        }
        Date definitionDate = null;
        try {
            definitionDate = DefinitionArchive.getLatestAvailableDefinitionSetDate();
        }
        catch (RESTRequestFailedException e) {
            System.out.println("Unable to get date of current definitions: " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("Unable to get date of current definitions: " + e.getMessage());
        }
        catch (ParseException e) {
            System.out.println("Unable to get date of current definitions: " + e.getMessage());
        }
        if (definitionDate != null && verbose) {
            System.out.println("Current definition set date: " + definitionDate);
        }
        String definitionsXML = null;
        try {
            if (verbose) {
                System.out.print("Downloading definitions from threatfactor.com...");
            }
            definitionsXML = DefinitionsDownload.getDefinitionsAsString(licenseKey, "Command-line");
            if (verbose) {
                System.out.println("Done");
            }
        }
        catch (RESTRequestFailedException e) {
            System.err.println();
            System.err.println("Unable to retrieve the definitions from threatfactor.com");
            System.exit(1);
        }
        if (definitionsXML == null) {
            System.err.println();
            System.err.println("No definitions exist on threatfactor.com");
            System.exit(1);
        }
        if ((outputFileName = commandLineData.getString("outputFile")) == null && definitionVersionID != null) {
            outputFileName = "definitions " + definitionVersionID.toString() + ".xml";
        } else if (outputFileName == null) {
            outputFileName = "definitions.xml";
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outputFileName));
            if (verbose) {
                System.out.print("Writing definitions to \"" + outputFileName + "\"...");
            }
            out.write(definitionsXML);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (verbose) {
            System.out.println("Done");
        }
    }

    private static JSAP getCommandLineProcessor() throws JSAPException {
        JSAP jsap = new JSAP();
        FlaggedOption opt1 = new FlaggedOption("outputFile").setStringParser(JSAP.STRING_PARSER).setRequired(false).setShortFlag('f').setLongFlag("file");
        opt1.setHelp("The name of the file to store the definitions in");
        jsap.registerParameter(opt1);
        Switch sw1 = new Switch("verbose").setShortFlag('v').setLongFlag("verbose");
        sw1.setHelp("Output messages to standard output");
        jsap.registerParameter(sw1);
        UnflaggedOption opt2 = new UnflaggedOption("licenseKey").setRequired(true);
        jsap.registerParameter(opt2);
        return jsap;
    }
}

