/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.support;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.DefinitionSet;
import net.lukemurphey.nsia.scan.InvalidDefinitionException;
import net.lukemurphey.nsia.scan.PatternDefinition;
import net.lukemurphey.nsia.scan.ScriptDefinition;
import net.lukemurphey.nsia.scan.UnpurposedDefinitionException;

public class DefinitionSupport {
    public static String readFileAsString(String filePath) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    public static final void main(String[] args) {
        if (args.length != 4 && args.length != 3) {
            System.err.println("The correct number of arguments was not provided: NSIAsupport <import_directory> <definitions_file> <definitions_ver> <definition_date>");
            System.err.println("\timport_directory : The directory containing the definitions to import");
            System.err.println("\tdefinitions_file  : File to write the definitions to");
            System.err.println("\tdefinition_ver    : The version of the definition set");
            System.err.println("\tdefinition_date   : The date of the definitions (optional, will use the current date and time if excluded))");
            return;
        }
        Vector<Definition> definitions = new Vector<Definition>(10000);
        File dir = new File(args[0]);
        String[] children = dir.list();
        if (children != null) {
            String ruleCode;
            String filename;
            int i = 0;
            while (i < children.length) {
                filename = children[i];
                try {
                    if (filename.endsWith(".js")) {
                        System.out.println("Loading definition in " + filename);
                        ruleCode = DefinitionSupport.readFileAsString(String.valueOf(args[0]) + "/" + filename);
                        ScriptDefinition definition = ScriptDefinition.parse(ruleCode);
                        if (definition.getID() <= 0) {
                            System.err.println("Definition in " + filename + " does not have a valid ID (" + definition.getFullName() + ")");
                        } else {
                            definitions.add(definition);
                        }
                    }
                }
                catch (IOException e) {
                    System.out.println("IOException from " + filename);
                    e.printStackTrace();
                }
                catch (InvalidDefinitionException e) {
                    System.out.println("Definition is invalid from " + filename);
                }
                ++i;
            }
            i = 0;
            while (i < children.length) {
                filename = children[i];
                try {
                    if (filename.endsWith(".rule")) {
                        System.out.println("Loading definitions in " + filename);
                        ruleCode = DefinitionSupport.readFileAsString(String.valueOf(args[0]) + "/" + filename);
                        PatternDefinition[] sigs = PatternDefinition.parseAll(ruleCode);
                        int c = 0;
                        while (c < sigs.length) {
                            PatternDefinition definition = sigs[c];
                            if (definition.getID() <= 0) {
                                System.err.println("Definition in " + filename + " does not have a valid ID (" + definition.getFullName() + ")");
                            } else {
                                definitions.add(definition);
                            }
                            ++c;
                        }
                    }
                }
                catch (IOException e) {
                    System.out.println("IOException from " + filename);
                    e.printStackTrace();
                }
                catch (InvalidDefinitionException e) {
                    System.out.println("Definition is invalid from " + filename + "(" + e.getMessage() + ")");
                }
                catch (UnpurposedDefinitionException e) {
                    System.out.println("Definition is invalid (unpurposed) from " + filename);
                }
                ++i;
            }
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss Z yyyy");
            Date date = args.length > 3 ? dateFormat.parse(args[3]) : new Date();
            DefinitionSet definitionSet = new DefinitionSet(date, definitions, args[2]);
            String xml = definitionSet.getAsXML();
            FileWriter fileWriter = new FileWriter(args[1]);
            BufferedWriter buffWriter = new BufferedWriter(fileWriter);
            buffWriter.write(xml);
            buffWriter.close();
        }
        catch (ParseException e) {
            System.err.println("Date format is invalid, should be in the format \"MMM dd HH:mm:ss Z yyyy\": " + e);
            return;
        }
        catch (IOException e) {
            System.err.println("File could not be written: " + e);
        }
        System.out.println("Done, " + definitions.size() + " definitions exported");
    }
}

