/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import junit.framework.TestCase;
import net.lukemurphey.nsia.AccessControlDescriptor;
import net.lukemurphey.nsia.ObjectPermissionDescriptor;

public class AccessControlDescriptorTest
extends TestCase {
    ObjectPermissionDescriptor noExecute = new ObjectPermissionDescriptor(AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.DENY, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Subject.USER, 1, 1L);
    ObjectPermissionDescriptor allowExcute = new ObjectPermissionDescriptor(AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.PERMIT, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Subject.USER, 1, 1L);
    ObjectPermissionDescriptor unspecified = new ObjectPermissionDescriptor(AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Subject.USER, 1, 1L);
    ObjectPermissionDescriptor noRead = new ObjectPermissionDescriptor(AccessControlDescriptor.Action.DENY, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Subject.USER, 1, 1L);

    public static void main(String[] args) {
    }

    public AccessControlDescriptorTest(String name) {
        super(name);
    }

    public void testGetReadPermission() {
        if (this.noRead.getReadPermission() != AccessControlDescriptor.Action.DENY) {
            AccessControlDescriptorTest.fail((String)"Read permission should have been denied");
        }
        if (this.noExecute.getReadPermission() != AccessControlDescriptor.Action.UNSPECIFIED) {
            AccessControlDescriptorTest.fail((String)"Read permission should have been unspecified");
        }
    }

    public void testGetModifyPermission() {
        if (this.noRead.getReadPermission() != AccessControlDescriptor.Action.DENY) {
            AccessControlDescriptorTest.fail((String)"Read permission should have been denied");
        }
        if (this.noExecute.getReadPermission() != AccessControlDescriptor.Action.UNSPECIFIED) {
            AccessControlDescriptorTest.fail((String)"Read permission should have been unspecified");
        }
    }

    public void testGetCreatePermission() {
        if (this.noRead.getCreatePermission() != AccessControlDescriptor.Action.UNSPECIFIED) {
            AccessControlDescriptorTest.fail((String)"Create permission should have been unspecified");
        }
    }

    public void testGetExecutePermission() {
        if (this.noExecute.getExecutePermission() != AccessControlDescriptor.Action.DENY) {
            AccessControlDescriptorTest.fail((String)"Execute permission should have been denied");
        }
        if (this.unspecified.getExecutePermission() != AccessControlDescriptor.Action.UNSPECIFIED) {
            AccessControlDescriptorTest.fail((String)"Execute permission should have been unspecified");
        }
    }

    public void testGetDeletePermission() {
        if (this.noRead.getDeletePermission() != AccessControlDescriptor.Action.UNSPECIFIED) {
            AccessControlDescriptorTest.fail((String)"Delete permission should have been unspecified");
        }
    }

    public void testResolvePermissions() {
        ObjectPermissionDescriptor result = this.noExecute.resolvePermissions(this.allowExcute);
        if (result.getExecutePermission() != AccessControlDescriptor.Action.DENY) {
            AccessControlDescriptorTest.fail((String)"Execute permission should have been denied");
        }
    }
}

