/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import junit.framework.TestCase;
import net.lukemurphey.nsia.scan.ByteJumpEvaluator;
import net.lukemurphey.nsia.scan.InvalidEvaluatorException;

public class ByteJumpEvaluatorTest
extends TestCase {
    public void testParse() throws InvalidEvaluatorException {
        ByteJumpEvaluator eval = ByteJumpEvaluator.parse("1 bytes (align-4, little-endian, hexadecimal) x 2");
        if (eval.getAlignment() != 4) {
            TestCase.fail((String)"The alignment was not correctly parsed");
        }
        if (eval.isBigEndian()) {
            TestCase.fail((String)"The big-endian operator was not correctly parsed");
        }
        if (eval.getBase() != 16) {
            TestCase.fail((String)"The base was not correctly parsed");
        }
        if (eval.getMultiplier() != 2) {
            TestCase.fail((String)"The mulitplier was not correctly parsed");
        }
    }

    public void testParseMultiplierOnly() throws InvalidEvaluatorException {
        ByteJumpEvaluator eval = ByteJumpEvaluator.parse("1 bytes x 2");
        if (eval.getAlignment() != 1) {
            TestCase.fail((String)"The alignment was not correctly parsed");
        }
        if (!eval.isBigEndian()) {
            TestCase.fail((String)"The big-endian was not correctly parsed");
        }
        if (eval.getBase() != 10) {
            TestCase.fail((String)"The base was not correctly parsed");
        }
        if (eval.getMultiplier() != 2) {
            TestCase.fail((String)"The mulitplier was not correctly parsed");
        }
    }

    public void testSingleByte() throws InvalidEvaluatorException {
        ByteJumpEvaluator eval = ByteJumpEvaluator.parse("1 byte");
        eval.setOffset(2);
        byte[] byArray = new byte[30];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArray[16] = 16;
        byArray[17] = 17;
        byArray[18] = 18;
        byArray[19] = 19;
        byArray[20] = 20;
        byArray[21] = 21;
        byArray[22] = 22;
        byArray[23] = 23;
        byArray[24] = 24;
        byArray[25] = 25;
        byArray[26] = 26;
        byArray[27] = 27;
        byArray[28] = 29;
        byArray[29] = 30;
        byte[] data = byArray;
        int result = eval.evaluate(data);
        if (result != 5) {
            TestCase.fail((String)("The evaluator failed to derive the correct results (returned " + result + ")"));
        }
    }

    public void testMultipleBytes() throws InvalidEvaluatorException {
        ByteJumpEvaluator eval = ByteJumpEvaluator.parse("2 bytes");
        eval.setOffset(1);
        byte[] byArray = new byte[30];
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArray[16] = 16;
        byArray[17] = 17;
        byArray[18] = 18;
        byArray[19] = 19;
        byArray[20] = 20;
        byArray[21] = 21;
        byArray[22] = 22;
        byArray[23] = 23;
        byArray[24] = 24;
        byArray[25] = 25;
        byArray[26] = 26;
        byArray[27] = 27;
        byArray[28] = 29;
        byArray[29] = 30;
        byte[] data = byArray;
        int result = eval.evaluate(data);
        if (result != 5) {
            TestCase.fail((String)("The evaluator failed to derive the correct results (returned " + result + ")"));
        }
    }

    public void testMultiplier() throws InvalidEvaluatorException {
        ByteJumpEvaluator eval = ByteJumpEvaluator.parse("1 byte x 2");
        eval.setOffset(2);
        byte[] byArray = new byte[30];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArray[16] = 16;
        byArray[17] = 17;
        byArray[18] = 18;
        byArray[19] = 19;
        byArray[20] = 20;
        byArray[21] = 21;
        byArray[22] = 22;
        byArray[23] = 23;
        byArray[24] = 24;
        byArray[25] = 25;
        byArray[26] = 26;
        byArray[27] = 27;
        byArray[28] = 29;
        byArray[29] = 30;
        byte[] data = byArray;
        int result = eval.evaluate(data);
        if (result != 7) {
            TestCase.fail((String)("The evaluator failed to derive the correct results (returned " + result + ")"));
        }
    }

    public void testJustPastEdge() throws InvalidEvaluatorException {
        ByteJumpEvaluator eval = ByteJumpEvaluator.parse("2 bytes");
        eval.setOffset(30);
        byte[] byArray = new byte[31];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArray[16] = 16;
        byArray[17] = 17;
        byArray[18] = 18;
        byArray[19] = 19;
        byArray[20] = 20;
        byArray[21] = 21;
        byArray[22] = 22;
        byArray[23] = 23;
        byArray[24] = 24;
        byArray[25] = 25;
        byArray[26] = 26;
        byArray[27] = 27;
        byArray[28] = 28;
        byArray[29] = 29;
        byArray[30] = 30;
        byte[] data = byArray;
        int result = eval.evaluate(data);
        if (result != -1) {
            TestCase.fail((String)("The evaluator failed to derive the correct results (returned " + result + ")"));
        }
    }

    public void testAtEdge() throws InvalidEvaluatorException {
        ByteJumpEvaluator eval = ByteJumpEvaluator.parse("1 byte");
        eval.setOffset(28);
        byte[] byArray = new byte[31];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArray[16] = 16;
        byArray[17] = 17;
        byArray[18] = 18;
        byArray[19] = 19;
        byArray[20] = 20;
        byArray[21] = 21;
        byArray[22] = 22;
        byArray[23] = 23;
        byArray[24] = 24;
        byArray[25] = 25;
        byArray[26] = 26;
        byArray[27] = 27;
        byArray[28] = 1;
        byArray[29] = 29;
        byArray[30] = 30;
        byte[] data = byArray;
        int result = eval.evaluate(data);
        if (result != 30) {
            TestCase.fail((String)("The evaluator failed to derive the correct results (returned " + result + ")"));
        }
    }
}

