/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import java.util.Vector;
import junit.framework.TestCase;
import net.lukemurphey.nsia.scan.DefinitionPolicyDescriptor;
import net.lukemurphey.nsia.scan.DefinitionPolicySet;

public class DefinitionPolicyDescriptorTest
extends TestCase {
    public void testFilterMultipleOverride() {
        Vector<DefinitionPolicyDescriptor> descriptors = new Vector<DefinitionPolicyDescriptor>();
        descriptors.add(DefinitionPolicyDescriptor.createCategoryPolicy("CategoryOne", DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE));
        descriptors.add(DefinitionPolicyDescriptor.createCategoryPolicy(1, "CategoryOne", DefinitionPolicyDescriptor.DefinitionPolicyAction.INCLUDE));
        descriptors.add(DefinitionPolicyDescriptor.createSubCategoryPolicy(1, "SubCategory", "CategoryTwo", DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE));
        descriptors.add(DefinitionPolicyDescriptor.createCategoryPolicy(2, "CategoryOne", DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE));
        descriptors.add(DefinitionPolicyDescriptor.createDefinitionPolicy(-1, "CategoryOne", "SubCategory", "FilterMe", DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE));
        DefinitionPolicySet set = new DefinitionPolicySet(descriptors);
        if (set.isFiltered(1L, -1L, "DefName", "CategoryOne", "SubCategory", null)) {
            DefinitionPolicyDescriptorTest.fail((String)"The isFiltered method should have returned false");
        }
        if (!set.isFiltered(2L, -1L, "DefName", "CategoryOne", "SubCategory", null)) {
            DefinitionPolicyDescriptorTest.fail((String)"The isFiltered method should have returned true");
        }
        if (!set.isFiltered(32L, -1L, "DefName", "CategoryOne", "SubCategory", null)) {
            DefinitionPolicyDescriptorTest.fail((String)"The isFiltered method should have returned true");
        }
        if (!set.isFiltered(5L, -1L, "FilterMe", "CategoryOne", "SubCategory", null)) {
            DefinitionPolicyDescriptorTest.fail((String)"The isFiltered method should have returned true");
        }
    }

    public void testFilterSiteGroupID() {
        DefinitionPolicyDescriptor filter2;
        DefinitionPolicyDescriptor filter = new DefinitionPolicyDescriptor(1, -1, null, null, null, null, DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE);
        if (DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE != filter.getActionIfMatches(1L, -1, null, null, null)) {
            DefinitionPolicyDescriptorTest.fail((String)"The isFiltered method should have returned EXCLUDE");
        }
        if ((filter2 = new DefinitionPolicyDescriptor(2, -1, null, null, null, null, DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE)).getActionIfMatches(1L, -1, null, null, null) != null) {
            DefinitionPolicyDescriptorTest.fail((String)"The isFiltered method should have returned null");
        }
    }

    public void testFilterSiteGroupRule() {
        DefinitionPolicyDescriptor filter = new DefinitionPolicyDescriptor(1, 1024, null, null, null, null, DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE);
        if (DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE != filter.getActionIfMatches(1L, 1024, null, null, null)) {
            DefinitionPolicyDescriptorTest.fail((String)"The isFiltered method should have returned EXCLUDE");
        }
        if (filter.getActionIfMatches(1L, -1, null, null, null) != null) {
            DefinitionPolicyDescriptorTest.fail((String)"The isFiltered method should have returned null");
        }
        if (filter.getActionIfMatches(1L, 2148, null, null, null) != null) {
            DefinitionPolicyDescriptorTest.fail((String)"The isFiltered method should have returned null");
        }
        if (filter.getActionIfMatches(-1L, 2148, null, null, null) != null) {
            DefinitionPolicyDescriptorTest.fail((String)"The isFiltered method should have returned null");
        }
        if (filter.getActionIfMatches(1L, -1, "tree", null, null) != null) {
            DefinitionPolicyDescriptorTest.fail((String)"The isFiltered method should have returned null");
        }
    }
}

