/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import junit.framework.TestCase;
import net.lukemurphey.nsia.FirewallRule;
import net.lukemurphey.nsia.InetAddressRange;

public class FirewallRuleTest
extends TestCase {
    FirewallRule firewallDenyRule;
    FirewallRule firewallAcceptRule;

    public static void main(String[] args) {
    }

    public FirewallRuleTest(String name) throws UnknownHostException {
        super(name);
        InetAddressRange inetAddressRange = InetAddressRange.getByRange(InetAddress.getByName("127.0.0.1"), InetAddress.getByName("127.255.255.254"));
        this.firewallDenyRule = new FirewallRule(inetAddressRange, true, 1L);
        this.firewallAcceptRule = new FirewallRule(inetAddressRange, false, 2L);
    }

    public void testFirewallRuleInetAddressRangeBooleanLongTimestamp() throws UnknownHostException {
        FirewallRule tempBlockedFirewallRule;
        InetAddress address;
        InetAddressRange inetAddressRange = InetAddressRange.getByRange(InetAddress.getByName("127.0.0.1"), InetAddress.getByName("127.255.255.254"));
        FirewallRule oldFirewallRule = new FirewallRule(inetAddressRange, false, 1L, new Timestamp(System.currentTimeMillis() - 10000L));
        if (oldFirewallRule.isAccepted(address = InetAddress.getByName("127.0.0.3")) != FirewallRule.Result.ACCEPT) {
            FirewallRuleTest.fail((String)"The temporarily blocked rule should have been accepted since the block has expired");
        }
        if ((tempBlockedFirewallRule = new FirewallRule(inetAddressRange, true, 1L, new Timestamp(System.currentTimeMillis() + 100000L))).isAccepted(address) != FirewallRule.Result.REJECT) {
            FirewallRuleTest.fail((String)"The temporarily blocked rule should have been rejected since the block is active");
        }
    }

    public void testFirewallRuleInetAddressRangeBooleanLong() throws UnknownHostException {
        FirewallRule rejectFirewallRule;
        InetAddressRange inetAddressRange = InetAddressRange.getByRange(InetAddress.getByName("127.0.0.1"), InetAddress.getByName("127.255.255.254"));
        FirewallRule acceptFirewallRule = new FirewallRule(inetAddressRange, false, 1L);
        InetAddress inAddress = InetAddress.getByName("127.0.0.3");
        InetAddress outAddress = InetAddress.getByName("191.1.3.11");
        if (acceptFirewallRule.isAccepted(inAddress) != FirewallRule.Result.ACCEPT) {
            FirewallRuleTest.fail((String)"The firewall rule should have accepted");
        }
        if (acceptFirewallRule.isAccepted(outAddress) != FirewallRule.Result.NOT_MATCH) {
            FirewallRuleTest.fail((String)"The firewall rule should have not matched");
        }
        if ((rejectFirewallRule = new FirewallRule(inetAddressRange, true, 1L)).isAccepted(inAddress) != FirewallRule.Result.REJECT) {
            FirewallRuleTest.fail((String)"The firewall rule should have rejected");
        }
        if (rejectFirewallRule.isAccepted(outAddress) != FirewallRule.Result.NOT_MATCH) {
            FirewallRuleTest.fail((String)"The firewall rule should have not matched");
        }
    }

    public void testIsDenyRule() {
        if (!this.firewallDenyRule.isDenyRule()) {
            FirewallRuleTest.fail((String)"The rule was not properly flagged as a deny rule");
        }
        if (this.firewallAcceptRule.isDenyRule()) {
            FirewallRuleTest.fail((String)"The rule was not properly flagged as an accept rule");
        }
    }

    public void testGetAddressRange() throws UnknownHostException {
        InetAddress inAddress = InetAddress.getByName("127.0.0.3");
        InetAddress outAddress = InetAddress.getByName("191.1.3.11");
        InetAddressRange inetAddressRange = this.firewallDenyRule.getAddressRange();
        if (!inetAddressRange.isWithinRange(inAddress)) {
            FirewallRuleTest.fail((String)"The range did not include the range");
        }
        if (inetAddressRange.isWithinRange(outAddress)) {
            FirewallRuleTest.fail((String)"The range included the range");
        }
    }

    public void testGetRuleExpireTime() throws UnknownHostException {
        Timestamp expireTime;
        InetAddressRange inetAddressRange = InetAddressRange.getByRange(InetAddress.getByName("127.0.0.1"), InetAddress.getByName("127.255.255.254"));
        FirewallRule oldFirewallRule = new FirewallRule(inetAddressRange, false, 1L, expireTime = new Timestamp(System.currentTimeMillis() - 10000L));
        Timestamp returnedExpireTime = oldFirewallRule.getRuleExpireTime();
        if (returnedExpireTime.getTime() != expireTime.getTime()) {
            FirewallRuleTest.fail((String)"The expiration times do not match but should have");
        }
    }

    public void testIsExpired() throws UnknownHostException {
        FirewallRule tempBlockedFirewallRule;
        InetAddressRange inetAddressRange = InetAddressRange.getByRange(InetAddress.getByName("127.0.0.1"), InetAddress.getByName("127.255.255.254"));
        FirewallRule oldFirewallRule = new FirewallRule(inetAddressRange, false, 1L, new Timestamp(System.currentTimeMillis() - 10000L));
        if (!oldFirewallRule.isExpired()) {
            FirewallRuleTest.fail((String)"The temporarily blocked rule have indicated an expired status");
        }
        if ((tempBlockedFirewallRule = new FirewallRule(inetAddressRange, true, 1L, new Timestamp(System.currentTimeMillis() + 100000L))).isExpired()) {
            FirewallRuleTest.fail((String)"The temporarily blocked rule should have indicated an active status");
        }
    }

    public void testGetRuleId() throws UnknownHostException {
        InetAddressRange inetAddressRange = InetAddressRange.getByRange(InetAddress.getByName("127.0.0.1"), InetAddress.getByName("127.255.255.254"));
        FirewallRule oldFirewallRule = new FirewallRule(inetAddressRange, false, 100L, new Timestamp(System.currentTimeMillis() - 10000L));
        if (oldFirewallRule.getRuleId() != 100L) {
            FirewallRuleTest.fail((String)"Incorrect rule identifier was returned");
        }
    }
}

