/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import java.net.BindException;
import java.sql.SQLException;
import junit.framework.TestCase;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GroupManagement;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.tests.TestApplication;
import net.lukemurphey.nsia.tests.TestApplicationException;

public class GroupManagementTest
extends TestCase {
    GroupManagement groupManagement;
    Application app = null;

    public void setUp() throws TestApplicationException {
        this.app = TestApplication.getApplication();
        this.groupManagement = new GroupManagement(this.app);
    }

    public void tearDown() {
        TestApplication.stopApplication();
    }

    public GroupManagementTest(String name) throws BindException, SQLException, InputValidationException, Exception {
        super(name);
    }

    public void testGetGroupId() throws InputValidationException, SQLException, NoDatabaseConnectionException {
        if (this.groupManagement.getGroupID("Analysts") < 1) {
            GroupManagementTest.fail((String)"Group could not be found");
        }
    }

    public void testAddGroup() throws SQLException, NoDatabaseConnectionException, InputValidationException, NotFoundException {
        int groupID = this.groupManagement.addGroup("SomeTestGroup", "For testing...");
        GroupManagement.GroupDescriptor groupDescriptor = this.groupManagement.getGroupDescriptor(groupID);
        if (groupDescriptor == null) {
            GroupManagementTest.fail((String)"Group was not successfully created");
        } else if (!groupDescriptor.getGroupName().equals("SomeTestGroup")) {
            GroupManagementTest.fail((String)"Group was not loaded correctly");
        }
    }

    public void testGetGroupDescriptorLong() throws SQLException, InputValidationException, NoDatabaseConnectionException, NotFoundException {
        GroupManagement.GroupDescriptor groupDesc = this.groupManagement.getGroupDescriptor(1);
        if (groupDesc == null) {
            GroupManagementTest.fail((String)"The group could not be found");
        }
    }

    public void testGetGroupDescriptorString() throws SQLException, InputValidationException, NoDatabaseConnectionException, NotFoundException {
        GroupManagement.GroupDescriptor groupDesc = this.groupManagement.getGroupDescriptor("Analysts");
        if (groupDesc == null) {
            GroupManagementTest.fail((String)"The group could not be found");
        }
    }

    public void testUpdateGroupInfo() throws SQLException, InputValidationException, NoDatabaseConnectionException, NotFoundException {
        GroupManagement.GroupDescriptor groupDesc = this.groupManagement.getGroupDescriptor(1);
        String oldDesc = groupDesc.getDescription();
        String newDesc = String.valueOf(oldDesc) + " Test";
        this.groupManagement.updateGroupInfo(1, groupDesc.getGroupName(), newDesc);
        GroupManagement.GroupDescriptor groupDescAfter = this.groupManagement.getGroupDescriptor(1);
        if (groupDescAfter.getDescription().length() != newDesc.length()) {
            GroupManagementTest.fail((String)"The new description was not saved");
        }
        this.groupManagement.updateGroupInfo(1, groupDesc.getGroupName(), oldDesc);
        groupDescAfter = this.groupManagement.getGroupDescriptor(1);
        if (groupDescAfter.getDescription().length() != oldDesc.length()) {
            GroupManagementTest.fail((String)"The old description was not re-saved");
        }
    }

    public void testDisableGroup() throws SQLException, NoDatabaseConnectionException, InputValidationException, NotFoundException {
        GroupManagement.GroupDescriptor groupDesc;
        if (!this.groupManagement.disableGroup(1)) {
            GroupManagementTest.fail((String)"The account could not be disabled");
        }
        if ((groupDesc = this.groupManagement.getGroupDescriptor(1)).getGroupState() != GroupManagement.State.INACTIVE) {
            GroupManagementTest.fail((String)"Account was not disabled");
        }
        if (!this.groupManagement.enableGroup(1)) {
            GroupManagementTest.fail((String)"The account could not be re-enabled");
        }
        if ((groupDesc = this.groupManagement.getGroupDescriptor(1)).getGroupState() != GroupManagement.State.ACTIVE) {
            GroupManagementTest.fail((String)"Account was not re-enabled");
        }
    }

    public void testGetGroupDescriptors() throws SQLException, InputValidationException, NoDatabaseConnectionException {
        if (this.groupManagement.getGroupDescriptors() == null || this.groupManagement.getGroupDescriptors().length == 0) {
            GroupManagementTest.fail((String)"No groups were found");
        }
    }
}

