/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import javax.script.ScriptException;
import junit.framework.TestCase;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.scan.DefinitionEvaluationException;
import net.lukemurphey.nsia.scan.HttpResponseData;
import net.lukemurphey.nsia.scan.InvalidDefinitionException;
import net.lukemurphey.nsia.scan.ScriptDefinition;
import net.lukemurphey.nsia.scan.URLToScan;
import net.lukemurphey.nsia.scan.scriptenvironment.Result;
import net.lukemurphey.nsia.scan.scriptenvironment.Variables;
import net.lukemurphey.nsia.tests.TestApplication;
import net.lukemurphey.nsia.tests.TestApplicationException;
import net.lukemurphey.nsia.tests.TestResources;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class ScriptDefinitionTest
extends TestCase {
    public void tearDown() {
        TestApplication.stopApplication();
    }

    protected static ScriptDefinition getSignatureFromFile(String file) throws ScriptException, InvalidDefinitionException, IOException {
        String script = TestResources.readFileAsString(file);
        return ScriptDefinition.parse(script);
    }

    public void testParseMultilineComments() throws ScriptException, InvalidDefinitionException, IOException {
        ScriptDefinition sig = ScriptDefinitionTest.getSignatureFromFile(String.valueOf(TestResources.getTestResourcePath()) + "ValidRule.js");
        if (!sig.getMessage().matches("This is a test") || !sig.toString().matches("1.2.3")) {
            ScriptDefinitionTest.fail((String)"The rule was not parsed correctly");
        }
    }

    public void testParseQuotedName() throws ScriptException, InvalidDefinitionException, IOException {
        ScriptDefinition sig = ScriptDefinitionTest.getSignatureFromFile(String.valueOf(TestResources.getTestResourcePath()) + "ValidRuleQuoted.js");
        if (!sig.getMessage().matches("This is a test") || !sig.toString().matches("1.2.3")) {
            ScriptDefinitionTest.fail((String)("The rule was not parsed correctly: " + sig.getMessage()));
        }
    }

    public void testParseSingleLineComment() throws ScriptException, InvalidDefinitionException, IOException {
        ScriptDefinitionTest.getSignatureFromFile(String.valueOf(TestResources.getTestResourcePath()) + "ValidRuleLineComments.js");
    }

    public void testScriptDefinition() throws ScriptException, InvalidDefinitionException, IOException, NoDatabaseConnectionException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NoSuchMethodException, DefinitionEvaluationException, TestApplicationException {
        ScriptDefinition sig = ScriptDefinitionTest.getSignatureFromFile(String.valueOf(TestResources.getTestResourcePath()) + "URLExists.js");
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost("google.com", 80, "http");
        GetMethod httpMethod = new GetMethod("/");
        httpMethod.setFollowRedirects(true);
        HttpClient httpClient = new HttpClient();
        httpClient.executeMethod(hostConfig, (HttpMethod)httpMethod);
        HttpResponseData httpResponse = new HttpResponseData((HttpMethod)httpMethod, "http://google.com");
        Application app = TestApplication.getApplication();
        if (!sig.evaluate(httpResponse, new Variables(), 1L, app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER)).matched()) {
            ScriptDefinitionTest.fail((String)"The script should have matched");
        }
    }

    public void testUsePackageShortCuts() throws ScriptException, InvalidDefinitionException, IOException, NoDatabaseConnectionException, SQLException, NoSuchMethodException, InstantiationException, IllegalAccessException, ClassNotFoundException, DefinitionEvaluationException, TestApplicationException {
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost("google.com", 80, "http");
        GetMethod httpMethod = new GetMethod("/");
        httpMethod.setFollowRedirects(true);
        HttpClient httpClient = new HttpClient();
        httpClient.executeMethod(hostConfig, (HttpMethod)httpMethod);
        HttpResponseData httpResponse = new HttpResponseData((HttpMethod)httpMethod, "http://google.com");
        ScriptDefinition sig = ScriptDefinitionTest.getSignatureFromFile(String.valueOf(TestResources.getTestResourcePath()) + "ValidRulePackages.js");
        Application app = TestApplication.getApplication();
        sig.evaluate(httpResponse, new Variables(), 1L, app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER));
        if (!sig.getMessage().matches("This is a test") || !sig.toString().matches("1.2.3")) {
            ScriptDefinitionTest.fail((String)"The rule was not parsed correctly");
        }
    }

    public void testInvasiveFlagSet() throws InvalidDefinitionException {
        String rule = "";
        rule = String.valueOf(rule) + "/*";
        rule = String.valueOf(rule) + "* Name: Test.Test.InvasiveFlag\n";
        rule = String.valueOf(rule) + "* Version: 1\n";
        rule = String.valueOf(rule) + "* ID: 203\n";
        rule = String.valueOf(rule) + "* Message: Test\n";
        rule = String.valueOf(rule) + "* Severity: Low\n";
        rule = String.valueOf(rule) + "* Invasive: True\n";
        rule = String.valueOf(rule) + "*/\n";
        rule = String.valueOf(rule) + "function analyze( httpResponse, operation, variables, environment, defaultRule ){\n";
        rule = String.valueOf(rule) + "\treturn new Result( false, \"Just a Test\" );\n";
        ScriptDefinition sig = ScriptDefinition.parse(rule = String.valueOf(rule) + "}");
        if (!sig.isInvasive()) {
            ScriptDefinitionTest.fail((String)"The rule invasive flag was not set properly");
        }
    }

    public void testSetEnvironmentDataNotShared() throws ScriptException, InvalidDefinitionException, IOException, NoDatabaseConnectionException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NoSuchMethodException, DefinitionEvaluationException, TestApplicationException {
        ScriptDefinition sig = ScriptDefinitionTest.getSignatureFromFile(String.valueOf(TestResources.getTestResourcePath()) + "SaveDataNotShared.js");
        Application app = TestApplication.getApplication();
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost("google.com", 80, "http");
        GetMethod httpMethod = new GetMethod("/");
        httpMethod.setFollowRedirects(true);
        HttpClient httpClient = new HttpClient();
        httpClient.executeMethod(hostConfig, (HttpMethod)httpMethod);
        HttpResponseData httpResponse = new HttpResponseData((HttpMethod)httpMethod, "http://google.com");
        Result res = sig.evaluate(httpResponse, new Variables(), 1L, app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER));
        if (!res.getDescription().matches("No value set")) {
            ScriptDefinitionTest.fail((String)"The definition should not have set the variable");
        }
        HostConfiguration hostConfig2 = new HostConfiguration();
        hostConfig2.setHost("threatfactor.com", 80, "http");
        GetMethod httpMethod2 = new GetMethod("/");
        httpMethod2.setFollowRedirects(true);
        HttpClient httpClient2 = new HttpClient();
        httpClient2.executeMethod(hostConfig2, (HttpMethod)httpMethod2);
        HttpResponseData httpResponse2 = new HttpResponseData((HttpMethod)httpMethod2, "http://threatfactor.com");
        Result res2 = sig.evaluate(httpResponse2, new Variables(), 1L, app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER));
        if (!res2.getDescription().matches("No value set")) {
            ScriptDefinitionTest.fail((String)("The definition should not have set the variable: " + res2.getDescription()));
        }
    }

    public void testSetEnvironmentDataIsSpecimen() throws ScriptException, InvalidDefinitionException, IOException, NoDatabaseConnectionException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NoSuchMethodException, DefinitionEvaluationException, TestApplicationException {
        Application app = TestApplication.getApplication();
        ScriptDefinition sig = ScriptDefinitionTest.getSignatureFromFile(String.valueOf(TestResources.getTestResourcePath()) + "SaveDataNoSpecimen.js");
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost("google.com", 80, "http");
        GetMethod httpMethod = new GetMethod("/");
        httpMethod.setFollowRedirects(true);
        HttpClient httpClient = new HttpClient();
        httpClient.executeMethod(hostConfig, (HttpMethod)httpMethod);
        HttpResponseData httpResponse = new HttpResponseData((HttpMethod)httpMethod, "http://google.com");
        Result res = sig.evaluate(httpResponse, new Variables(), 1L, app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER));
        if (!res.getDescription().matches("No value set")) {
            ScriptDefinitionTest.fail((String)"The definition should not have set the variable");
        }
        HostConfiguration hostConfig2 = new HostConfiguration();
        hostConfig2.setHost("threatfactor.com", 80, "http");
        GetMethod httpMethod2 = new GetMethod("/");
        httpMethod2.setFollowRedirects(true);
        HttpClient httpClient2 = new HttpClient();
        httpClient2.executeMethod(hostConfig2, (HttpMethod)httpMethod2);
        HttpResponseData httpResponse2 = new HttpResponseData((HttpMethod)httpMethod2, "http://threatfactor.com");
        Result res2 = sig.evaluate(httpResponse2, new Variables(), 1L, app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER));
        if (!res2.getDescription().startsWith("Value set: 12345678")) {
            ScriptDefinitionTest.fail((String)("The definition did not set the variable correctly: " + res2.getDescription()));
        }
    }

    public void testVector() throws ScriptException, InvalidDefinitionException, IOException, NoDatabaseConnectionException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NoSuchMethodException, DefinitionEvaluationException, TestApplicationException {
        Application app = TestApplication.getApplication();
        ScriptDefinition sig = ScriptDefinitionTest.getSignatureFromFile(String.valueOf(TestResources.getTestResourcePath()) + "Vector.js");
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost("google.com", 80, "http");
        GetMethod httpMethod = new GetMethod("/");
        httpMethod.setFollowRedirects(true);
        HttpClient httpClient = new HttpClient();
        httpClient.executeMethod(hostConfig, (HttpMethod)httpMethod);
        HttpResponseData httpResponse = new HttpResponseData((HttpMethod)httpMethod, "http://google.com");
        Result result = sig.evaluate(httpResponse, new Variables(), 1L, app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER));
        if (!result.getDescription().equals("1")) {
            ScriptDefinitionTest.fail((String)("The definition did not set the variable correctly: " + result.getDescription()));
        }
        if (!(result = sig.evaluate(httpResponse, new Variables(), 1L, app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER))).getDescription().equals("2")) {
            ScriptDefinitionTest.fail((String)("The definition did not set the vector entry correctly: " + result.getDescription()));
        }
    }

    public void testVectorNativeArrayConversion() throws ScriptException, InvalidDefinitionException, IOException, NoDatabaseConnectionException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NoSuchMethodException, DefinitionEvaluationException, TestApplicationException {
        Application app = TestApplication.getApplication();
        ScriptDefinition sig = ScriptDefinitionTest.getSignatureFromFile(String.valueOf(TestResources.getTestResourcePath()) + "VectorNativeArrayConversion.js");
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost("google.com", 80, "http");
        GetMethod httpMethod = new GetMethod("/");
        httpMethod.setFollowRedirects(true);
        HttpClient httpClient = new HttpClient();
        httpClient.executeMethod(hostConfig, (HttpMethod)httpMethod);
        HttpResponseData httpResponse = new HttpResponseData((HttpMethod)httpMethod, "http://google.com");
        Result result = sig.evaluate(httpResponse, new Variables(), 1L, app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER));
        if (!result.getDescription().equals("2")) {
            ScriptDefinitionTest.fail((String)("The definition did not populate the vector correctly: " + result.getDescription()));
        }
        if (!(result = sig.evaluate(httpResponse, new Variables(), 1L, app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER))).getDescription().equals("2")) {
            ScriptDefinitionTest.fail((String)("The definition did not populate the vector correctly: " + result.getDescription()));
        }
    }

    public void testWebClient() throws ScriptException, InvalidDefinitionException, IOException, NoDatabaseConnectionException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NoSuchMethodException, DefinitionEvaluationException, TestApplicationException {
        Application app = TestApplication.getApplication();
        ScriptDefinition sig = ScriptDefinitionTest.getSignatureFromFile(String.valueOf(TestResources.getTestResourcePath()) + "WebClient.js");
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost("google.com", 80, "http");
        GetMethod httpMethod = new GetMethod("/");
        httpMethod.setFollowRedirects(true);
        HttpClient httpClient = new HttpClient();
        httpClient.executeMethod(hostConfig, (HttpMethod)httpMethod);
        HttpResponseData httpResponse = new HttpResponseData((HttpMethod)httpMethod, "http://google.com");
        Result result = sig.evaluate(httpResponse, new Variables(), 1L, app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER));
        if (!result.getDescription().equals("200")) {
            ScriptDefinitionTest.fail((String)("The definition did not load the content from the website correctly, did not receive a 200 code but: " + result.getDescription()));
        }
    }

    public void testHTMLParsing() throws ScriptException, InvalidDefinitionException, IOException, NoDatabaseConnectionException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NoSuchMethodException, DefinitionEvaluationException, TestApplicationException {
        Application app = TestApplication.getApplication();
        ScriptDefinition sig = ScriptDefinitionTest.getSignatureFromFile(String.valueOf(TestResources.getTestResourcePath()) + "HTMLParse.js");
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost("google.com", 80, "http");
        GetMethod httpMethod = new GetMethod("/");
        httpMethod.setFollowRedirects(true);
        HttpClient httpClient = new HttpClient();
        httpClient.executeMethod(hostConfig, (HttpMethod)httpMethod);
        HttpResponseData httpResponse = new HttpResponseData((HttpMethod)httpMethod, "http://google.com");
        Result result = sig.evaluate(httpResponse, new Variables(), 1L, app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER));
        if (!result.getDescription().equals("1")) {
            ScriptDefinitionTest.fail((String)("The definition did not parse the HTML correctly: " + result.getDescription()));
        }
    }

    public void testSetVariable() throws ScriptException, InvalidDefinitionException, IOException, NoDatabaseConnectionException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NoSuchMethodException, DefinitionEvaluationException, TestApplicationException {
        Application app = TestApplication.getApplication();
        ScriptDefinition sig = ScriptDefinitionTest.getSignatureFromFile(String.valueOf(TestResources.getTestResourcePath()) + "SetVariable.js");
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost("google.com", 80, "http");
        GetMethod httpMethod = new GetMethod("/");
        httpMethod.setFollowRedirects(true);
        HttpClient httpClient = new HttpClient();
        httpClient.executeMethod(hostConfig, (HttpMethod)httpMethod);
        HttpResponseData httpResponse = new HttpResponseData((HttpMethod)httpMethod, "http://google.com");
        Variables vars = new Variables();
        sig.evaluate(httpResponse, vars, 1L, app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER));
        if (!vars.isSet("Test")) {
            ScriptDefinitionTest.fail((String)"The definition did not set the correctly");
        }
    }

    public void testSetVariableWithValue() throws ScriptException, InvalidDefinitionException, IOException, NoDatabaseConnectionException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NoSuchMethodException, DefinitionEvaluationException, TestApplicationException {
        Application app = TestApplication.getApplication();
        ScriptDefinition sigSet = ScriptDefinitionTest.getSignatureFromFile(String.valueOf(TestResources.getTestResourcePath()) + "SetVariableWithValue.js");
        ScriptDefinition sigRead = ScriptDefinitionTest.getSignatureFromFile(String.valueOf(TestResources.getTestResourcePath()) + "ReadVariableWithValue.js");
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost("google.com", 80, "http");
        GetMethod httpMethod = new GetMethod("/");
        httpMethod.setFollowRedirects(true);
        HttpClient httpClient = new HttpClient();
        httpClient.executeMethod(hostConfig, (HttpMethod)httpMethod);
        HttpResponseData httpResponse = new HttpResponseData((HttpMethod)httpMethod, "http://google.com");
        Variables vars = new Variables();
        sigSet.evaluate(httpResponse, vars, 1L, app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER));
        Result result = sigRead.evaluate(httpResponse, vars, 1L, app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER));
        if (!vars.isSet("Test") || !"This is the value".equals((String)vars.get("Test"))) {
            ScriptDefinitionTest.fail((String)"The definition did not set the variable correctly");
        }
        if (!result.matched) {
            ScriptDefinitionTest.fail((String)"The definition did not set the variable correctly");
        }
    }

    public void testExtractURLs() throws ScriptException, InvalidDefinitionException, IOException, NoDatabaseConnectionException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NoSuchMethodException, DefinitionEvaluationException, TestApplicationException {
        Application app = TestApplication.getApplication();
        ScriptDefinition sig = ScriptDefinitionTest.getSignatureFromFile(String.valueOf(TestResources.getTestResourcePath()) + "ExtractURLs.js");
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost("google.com", 80, "http");
        GetMethod httpMethod = new GetMethod("/");
        httpMethod.setFollowRedirects(true);
        HttpClient httpClient = new HttpClient();
        httpClient.executeMethod(hostConfig, (HttpMethod)httpMethod);
        HttpResponseData httpResponse = new HttpResponseData((HttpMethod)httpMethod, "http://google.com");
        Variables vars = new Variables();
        Result result = sig.evaluate(httpResponse, vars, 1L, app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER));
        Vector<URLToScan> urls = result.getURLs();
        if (urls.size() != 5) {
            ScriptDefinitionTest.fail((String)("The definition did not return the URLs correctly: " + urls.size()));
        }
    }
}

