/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import junit.framework.TestCase;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.ClientData;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.SessionManagement;
import net.lukemurphey.nsia.SessionStatus;
import net.lukemurphey.nsia.tests.TestApplication;

public class SessionManagementTest
extends TestCase {
    private SessionManagement sessionMgt;
    private String sID;
    Application app = null;

    public void setUp() throws Exception {
        this.app = TestApplication.getApplication();
        this.sessionMgt = new SessionManagement(this.app);
        ClientData clientData = new ClientData(InetAddress.getLocalHost(), "SiteSentry Test (main session)");
        this.sID = this.sessionMgt.createSession(1L, clientData);
    }

    public void tearDown() {
        TestApplication.stopApplication();
    }

    public void testCreateSession() throws UnknownHostException, NoSuchAlgorithmException, SQLException, NoDatabaseConnectionException, InputValidationException {
        ClientData clientData = new ClientData(InetAddress.getLocalHost(), "SiteSentry Test (test creation)");
        this.sID = this.sessionMgt.createSession(1L, clientData);
        if (this.sID == null) {
            SessionManagementTest.fail((String)"The session could not be created");
        }
    }

    public void testRefreshSessionIdentifier() throws NoSuchAlgorithmException, InputValidationException, SQLException, NoDatabaseConnectionException {
        String oldSid = this.sID;
        this.sID = this.sessionMgt.refreshSessionIdentifier(this.sID);
        if (this.sID == null) {
            this.sID = oldSid;
            SessionManagementTest.fail((String)"The session refresh failed, session destroyed");
        } else if (this.sID.equals(oldSid)) {
            SessionManagementTest.fail((String)"The session refresh failed, session identifier unchanged");
        }
    }

    public void testGetSessionStatusValid() throws SQLException, InputValidationException, NoDatabaseConnectionException {
        SessionStatus sessionStatus;
        if (this.sID != null && (sessionStatus = this.sessionMgt.getSessionStatus(this.sID)) != SessionStatus.SESSION_ACTIVE) {
            SessionManagementTest.fail((String)"Session status should be active");
        }
    }

    public void testGetSessionStatusInvalid() throws SQLException, InputValidationException, NoDatabaseConnectionException {
        SessionStatus sessionStatus = this.sessionMgt.getSessionStatus("ABCDEF1234567890");
        if (sessionStatus != SessionStatus.SESSION_NULL) {
            SessionManagementTest.fail((String)"Session status should be null");
        }
    }

    public void testTerminateSession() throws InputValidationException, SQLException, UnknownHostException, NoSuchAlgorithmException, NoDatabaseConnectionException {
        if (this.sID != null) {
            this.sessionMgt.terminateSession(this.sID);
            SessionStatus sessionStatus = this.sessionMgt.getSessionStatus(this.sID);
            if (sessionStatus != SessionStatus.SESSION_NULL) {
                SessionManagementTest.fail((String)"Session status should be null");
            }
            this.testCreateSession();
        }
    }

    public void testGetSessionInfo() throws InputValidationException, SQLException, NoDatabaseConnectionException {
        SessionManagement.SessionInfo sessionInfo = this.sessionMgt.getSessionInfo(this.sID);
        if (sessionInfo.getSessionStatus() != SessionStatus.SESSION_ACTIVE) {
            SessionManagementTest.fail((String)"The session was not disabled properly");
        }
    }

    public void testDisableUserSessions() throws UnknownHostException, NoSuchAlgorithmException, SQLException, NoDatabaseConnectionException, InputValidationException {
        ClientData clientData = new ClientData(InetAddress.getLocalHost(), "SiteSentry Test (To be disabled)");
        String disableSession = this.sessionMgt.createSession(100L, clientData);
        this.sessionMgt.disableUserSessions(100);
        SessionManagement.SessionInfo sessionInfo = this.sessionMgt.getSessionInfo(disableSession);
        if (sessionInfo.getSessionStatus() != SessionStatus.SESSION_ADMIN_TERMINATED) {
            SessionManagementTest.fail((String)"The session was not disabled properly");
        }
    }

    public void testGetCurrentSessions() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        SessionManagement.SessionInfo[] sessionInfo = this.sessionMgt.getCurrentSessions();
        if (sessionInfo.length < 1) {
            SessionManagementTest.fail((String)"No active sessions where found even though at least one valid one should exist");
        }
    }
}

