/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.trustBoundary;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogHook;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.eventlog.EventLogSeverity;
import net.lukemurphey.nsia.eventlog.RuleStatusEventLogHook;
import net.lukemurphey.nsia.eventlog.SiteGroupStatusEventLogHook;
import net.lukemurphey.nsia.eventlog.SystemStatusEventLogHook;
import net.lukemurphey.nsia.extension.ArgumentFieldsInvalidException;
import net.lukemurphey.nsia.response.Action;
import net.lukemurphey.nsia.trustBoundary.ApiHandler;

public class ApiActions
extends ApiHandler {
    public ApiActions(Application appRes) {
        super(appRes);
    }

    public SiteGroupStatusEventLogHook[] getSiteGroupEventLogHooks(String sessionIdentifier, long siteGroupID) {
        EventLogHook[] allHooks = this.appRes.getEventLog().getHooks();
        Vector<SiteGroupStatusEventLogHook> siteGroupHooks = new Vector<SiteGroupStatusEventLogHook>();
        int c = 0;
        while (c < allHooks.length) {
            if (allHooks[c] instanceof SiteGroupStatusEventLogHook && (long)((SiteGroupStatusEventLogHook)allHooks[c]).getSiteGroupID() == siteGroupID) {
                siteGroupHooks.add((SiteGroupStatusEventLogHook)allHooks[c]);
            }
            ++c;
        }
        SiteGroupStatusEventLogHook[] hooksArray = new SiteGroupStatusEventLogHook[siteGroupHooks.size()];
        siteGroupHooks.toArray(hooksArray);
        return hooksArray;
    }

    public RuleStatusEventLogHook[] getRuleStatusEventLogHooks(String sessionIdentifier, long ruleID) {
        EventLogHook[] allHooks = this.appRes.getEventLog().getHooks();
        Vector<RuleStatusEventLogHook> ruleHooks = new Vector<RuleStatusEventLogHook>();
        int c = 0;
        while (c < allHooks.length) {
            if (allHooks[c] instanceof RuleStatusEventLogHook && ((RuleStatusEventLogHook)allHooks[c]).getRuleID() == ruleID) {
                ruleHooks.add((RuleStatusEventLogHook)allHooks[c]);
            }
            ++c;
        }
        RuleStatusEventLogHook[] hooksArray = new RuleStatusEventLogHook[ruleHooks.size()];
        ruleHooks.toArray(hooksArray);
        return hooksArray;
    }

    public SystemStatusEventLogHook[] getSystemStatusEventLogHooks(String sessionIdentifier) {
        EventLogHook[] allHooks = this.appRes.getEventLog().getHooks();
        Vector<SystemStatusEventLogHook> ruleHooks = new Vector<SystemStatusEventLogHook>();
        int c = 0;
        while (c < allHooks.length) {
            if (allHooks[c] instanceof SystemStatusEventLogHook) {
                ruleHooks.add((SystemStatusEventLogHook)allHooks[c]);
            }
            ++c;
        }
        SystemStatusEventLogHook[] hooksArray = new SystemStatusEventLogHook[ruleHooks.size()];
        ruleHooks.toArray(hooksArray);
        return hooksArray;
    }

    public boolean updateEventLogHook(String sessionIdentifier, int actionID, Hashtable<String, String> moduleArguments) throws ArgumentFieldsInvalidException, GeneralizedException {
        EventLogHook hook = this.getEventLogHook(sessionIdentifier, actionID);
        if (hook != null) {
            hook.getAction().configure(moduleArguments);
            try {
                hook.saveToDatabase();
            }
            catch (SQLException e) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
                throw new GeneralizedException();
            }
            catch (IOException e) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
                throw new GeneralizedException();
            }
            catch (NoDatabaseConnectionException e) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
                throw new GeneralizedException();
            }
            return true;
        }
        return false;
    }

    public EventLogHook getEventLogHook(String sessionIdentifier, int actionID) {
        EventLogHook[] allHooks = this.appRes.getEventLog().getHooks();
        int c = 0;
        while (c < allHooks.length) {
            if (allHooks[c].getEventLogHookID() == actionID) {
                return allHooks[c];
            }
            ++c;
        }
        return null;
    }

    public void addSiteGroupAction(String sessionIdentifier, Action action, int siteGroupID) throws GeneralizedException {
        SiteGroupStatusEventLogHook hook = new SiteGroupStatusEventLogHook(action, siteGroupID, EventLogSeverity.WARNING);
        try {
            hook.saveToDatabase();
            this.appRes.getEventLog().addHook(hook);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (IOException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public void addRuleAction(String sessionIdentifier, Action action, long ruleID) throws GeneralizedException {
        RuleStatusEventLogHook hook = new RuleStatusEventLogHook(action, ruleID, EventLogSeverity.WARNING);
        try {
            hook.saveToDatabase();
            this.appRes.getEventLog().addHook(hook);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (IOException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public void addSystemAction(String sessionIdentifier, Action action) throws GeneralizedException {
        SystemStatusEventLogHook hook = new SystemStatusEventLogHook(action, EventLogSeverity.WARNING);
        try {
            hook.saveToDatabase();
            this.appRes.getEventLog().addHook(hook);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (IOException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public void deleteAction(String sessionIdentifier, long[] hookID) throws GeneralizedException {
        long[] lArray = hookID;
        int n = hookID.length;
        int n2 = 0;
        while (n2 < n) {
            long id = lArray[n2];
            this.deleteAction(sessionIdentifier, id);
            ++n2;
        }
    }

    public void deleteAction(String sessionIdentifier, long hookID) throws GeneralizedException {
        try {
            this.appRes.getEventLog().deleteHook(hookID);
            EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.RESPONSE_ACTION_DELETED, new EventLogField(EventLogField.FieldName.RESPONSE_ACTION_ID, hookID));
            this.appRes.logEvent(message);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }
}

