/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.trustBoundary;

import java.net.UnknownHostException;
import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.EmailAddress;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.InvalidLocalPartException;
import net.lukemurphey.nsia.LicenseDescriptor;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.trustBoundary.ApiHandler;

public class ApiApplicationConfiguration
extends ApiHandler {
    public ApiApplicationConfiguration(Application application) {
        super(application);
    }

    public void setAuthenticationAttemptAggregationCount(String sessionIdentifier, long value) throws InsufficientPermissionException, GeneralizedException, NoSessionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        UserManagement.UserDescriptor userDesc = this.getUserInfo(sessionIdentifier);
        try {
            this.appRes.getApplicationConfiguration().setAuthenticationAttemptAggregationCount(value);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        this.appRes.logEvent(new EventLogMessage(EventLogMessage.EventType.CONFIGURATION_CHANGE, new EventLogField(EventLogField.FieldName.PARAMETER, "Authentication Attempt Aggregation Count"), new EventLogField(EventLogField.FieldName.VALUE, value), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDesc.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDesc.getUserID())));
    }

    public long getAuthenticationAttemptAggregationCount(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        try {
            return this.appRes.getApplicationConfiguration().getAuthenticationAttemptAggregationCount();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setAuthenticationAttemptLimit(String sessionIdentifier, long value) throws InsufficientPermissionException, GeneralizedException, NoSessionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        UserManagement.UserDescriptor userDesc = this.getUserInfo(sessionIdentifier);
        try {
            this.appRes.getApplicationConfiguration().setAuthenticationAttemptLimit(value);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        this.appRes.logEvent(new EventLogMessage(EventLogMessage.EventType.CONFIGURATION_CHANGE, new EventLogField(EventLogField.FieldName.PARAMETER, "Authentication Attempt Limit"), new EventLogField(EventLogField.FieldName.VALUE, value), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDesc.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDesc.getUserID())));
    }

    public long getAuthenticationAttemptLimit(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        try {
            return this.appRes.getApplicationConfiguration().getAuthenticationAttemptLimit();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setHashAlgorithm(String sessionIdentifier, String value) throws InsufficientPermissionException, GeneralizedException, NoSessionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        UserManagement.UserDescriptor userDesc = this.getUserInfo(sessionIdentifier);
        try {
            this.appRes.getApplicationConfiguration().setHashAlgorithm(value);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        this.appRes.logEvent(new EventLogMessage(EventLogMessage.EventType.CONFIGURATION_CHANGE, new EventLogField(EventLogField.FieldName.PARAMETER, "Authentication Hash Algorithm"), new EventLogField(EventLogField.FieldName.VALUE, value), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDesc.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDesc.getUserID())));
    }

    public String getHashAlgorithm(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        try {
            return this.appRes.getApplicationConfiguration().getHashAlgorithm();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setHashIterations(String sessionIdentifier, long value) throws InsufficientPermissionException, GeneralizedException, NoSessionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        UserManagement.UserDescriptor userDesc = this.getUserInfo(sessionIdentifier);
        try {
            this.appRes.getApplicationConfiguration().setHashIterations(value);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        this.appRes.logEvent(new EventLogMessage(EventLogMessage.EventType.CONFIGURATION_CHANGE, new EventLogField(EventLogField.FieldName.PARAMETER, "Authentication Hash Iteration Count"), new EventLogField(EventLogField.FieldName.VALUE, value), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDesc.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDesc.getUserID())));
    }

    public long getHashIterations(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        try {
            return this.appRes.getApplicationConfiguration().getHashIterations();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public String getHttpClientId(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        try {
            return this.appRes.getApplicationConfiguration().getHttpClientId();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public String getKeystore(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        try {
            return this.appRes.getApplicationConfiguration().getKeystore();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setLoginBanner(String sessionIdentifier, String value) throws InsufficientPermissionException, GeneralizedException, NoSessionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        UserManagement.UserDescriptor userDesc = this.getUserInfo(sessionIdentifier);
        try {
            this.appRes.getApplicationConfiguration().setLoginBanner(value);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        this.appRes.logEvent(new EventLogMessage(EventLogMessage.EventType.CONFIGURATION_CHANGE, new EventLogField(EventLogField.FieldName.PARAMETER, "Login Banner"), new EventLogField(EventLogField.FieldName.VALUE, value), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDesc.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDesc.getUserID())));
    }

    public String getLoginBanner(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        try {
            return this.appRes.getApplicationConfiguration().getLoginBanner();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setServerPort(String sessionIdentifier, int value) throws InsufficientPermissionException, GeneralizedException, NoSessionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        UserManagement.UserDescriptor userDesc = this.getUserInfo(sessionIdentifier);
        try {
            this.appRes.getApplicationConfiguration().setServerPort(value);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        this.appRes.logEvent(new EventLogMessage(EventLogMessage.EventType.CONFIGURATION_CHANGE, new EventLogField(EventLogField.FieldName.PARAMETER, "Server Port"), new EventLogField(EventLogField.FieldName.VALUE, value), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDesc.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDesc.getUserID())));
    }

    public long getServerPort(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        try {
            return this.appRes.getApplicationConfiguration().getServerPort();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setSessionIdentifierLifetime(String sessionIdentifier, int value) throws InsufficientPermissionException, GeneralizedException, NoSessionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        UserManagement.UserDescriptor userDesc = this.getUserInfo(sessionIdentifier);
        try {
            this.appRes.getApplicationConfiguration().setSessionIdentifierLifetime(value);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        this.appRes.logEvent(new EventLogMessage(EventLogMessage.EventType.CONFIGURATION_CHANGE, new EventLogField(EventLogField.FieldName.PARAMETER, "Session Identifier Lifetime"), new EventLogField(EventLogField.FieldName.VALUE, value), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDesc.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDesc.getUserID())));
    }

    public long getSessionIdentifierLifetime(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        try {
            return this.appRes.getApplicationConfiguration().getSessionIdentifierLifetime();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setSessionInactivityThreshold(String sessionIdentifier, long value) throws InsufficientPermissionException, GeneralizedException, NoSessionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        UserManagement.UserDescriptor userDesc = this.getUserInfo(sessionIdentifier);
        try {
            this.appRes.getApplicationConfiguration().setSessionInactivityThreshold(value);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        this.appRes.logEvent(new EventLogMessage(EventLogMessage.EventType.CONFIGURATION_CHANGE, new EventLogField(EventLogField.FieldName.PARAMETER, "Session Inactivity Threshold"), new EventLogField(EventLogField.FieldName.VALUE, value), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDesc.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDesc.getUserID())));
    }

    public long getSessionInactivityThreshold(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        try {
            return this.appRes.getApplicationConfiguration().getSessionInactivityThreshold();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setSessionLifetime(String sessionIdentifier, long value) throws InsufficientPermissionException, GeneralizedException, NoSessionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        UserManagement.UserDescriptor userDesc = this.getUserInfo(sessionIdentifier);
        try {
            this.appRes.getApplicationConfiguration().setSessionLifetime(value);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        this.appRes.logEvent(new EventLogMessage(EventLogMessage.EventType.CONFIGURATION_CHANGE, new EventLogField(EventLogField.FieldName.PARAMETER, "Maximum Session Lifetime"), new EventLogField(EventLogField.FieldName.VALUE, value), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDesc.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDesc.getUserID())));
    }

    public long getSessionLifetime(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        try {
            return this.appRes.getApplicationConfiguration().getSessionLifetime();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setSslKeyPassword(String sessionIdentifier, String password) throws GeneralizedException, InsufficientPermissionException, NoSessionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        UserManagement.UserDescriptor userDesc = this.getUserInfo(sessionIdentifier);
        try {
            this.appRes.getApplicationConfiguration().setSslKeyPassword(password);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        this.appRes.logEvent(new EventLogMessage(EventLogMessage.EventType.CONFIGURATION_CHANGE, new EventLogField(EventLogField.FieldName.PARAMETER, "SSL Key Password"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDesc.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDesc.getUserID())));
    }

    public void setSslPassword(String sessionIdentifier, String password) throws GeneralizedException, InsufficientPermissionException, NoSessionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        UserManagement.UserDescriptor userDesc = this.getUserInfo(sessionIdentifier);
        try {
            this.appRes.getApplicationConfiguration().setSslPassword(password);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        this.appRes.logEvent(new EventLogMessage(EventLogMessage.EventType.CONFIGURATION_CHANGE, new EventLogField(EventLogField.FieldName.PARAMETER, "SSL Password"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDesc.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDesc.getUserID())));
    }

    public String getSslKeyPassword(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        try {
            return this.appRes.getApplicationConfiguration().getSslKeyPassword();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setLogFormat(String sessionIdentifier, String logFormat) throws GeneralizedException, InsufficientPermissionException, NoSessionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        UserManagement.UserDescriptor userDesc = this.getUserInfo(sessionIdentifier);
        try {
            this.appRes.getApplicationConfiguration().setLogFormat(logFormat);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        this.appRes.logEvent(new EventLogMessage(EventLogMessage.EventType.CONFIGURATION_CHANGE, new EventLogField(EventLogField.FieldName.PARAMETER, "Log Format"), new EventLogField(EventLogField.FieldName.VALUE, logFormat), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDesc.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDesc.getUserID())));
    }

    public String getLogFormat(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        try {
            return this.appRes.getApplicationConfiguration().getLogFormat();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public String getSslPassword(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        try {
            return this.appRes.getApplicationConfiguration().getSslPassword();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public String getLogServerAddress(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        try {
            return this.appRes.getApplicationConfiguration().getLogServerAddress();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setLogServerAddress(String sessionIdentifier, String value) throws GeneralizedException, InsufficientPermissionException, NoSessionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        try {
            this.appRes.getApplicationConfiguration().setLogServerAddress(value);
            this.appRes.getEventLog().setLogServer(value);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public int getLogServerPort(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        try {
            return this.appRes.getApplicationConfiguration().getLogServerPort();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setLogServerPort(String sessionIdentifier, int value) throws GeneralizedException, InsufficientPermissionException, NoSessionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit", "Set log server port");
        try {
            this.appRes.getApplicationConfiguration().setLogServerPort(value);
            this.appRes.getEventLog().setLogServerPort(value);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public void setSslEnabled(String sessionIdentifier, boolean value) throws InsufficientPermissionException, GeneralizedException, NoSessionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        UserManagement.UserDescriptor userDesc = this.getUserInfo(sessionIdentifier);
        try {
            this.appRes.getApplicationConfiguration().setSslEnabled(value);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        this.appRes.logEvent(new EventLogMessage(EventLogMessage.EventType.CONFIGURATION_CHANGE, new EventLogField(EventLogField.FieldName.PARAMETER, "SSL Enabled"), new EventLogField(EventLogField.FieldName.VALUE, String.valueOf(value)), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDesc.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDesc.getUserID())));
    }

    public boolean isSslEnabled(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        try {
            return this.appRes.getApplicationConfiguration().isSslEnabled();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setLicenseKey(String sessionIdentifier, String value) throws InsufficientPermissionException, GeneralizedException, NoSessionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        UserManagement.UserDescriptor userDesc = this.getUserInfo(sessionIdentifier);
        try {
            this.appRes.getApplicationConfiguration().setLicenseKey(value);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        this.appRes.logEvent(new EventLogMessage(EventLogMessage.EventType.CONFIGURATION_CHANGE, new EventLogField(EventLogField.FieldName.PARAMETER, "License Key"), new EventLogField(EventLogField.FieldName.VALUE, value), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDesc.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDesc.getUserID())));
    }

    public String getLicenseKey(String sessionIdentifier) throws GeneralizedException, NoSessionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.appRes.getApplicationConfiguration().getLicenseKey();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public LicenseDescriptor getLicense(String sessionIdentifier, boolean dontBlock) throws GeneralizedException, NoSessionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.appRes.getApplicationConfiguration().getLicense(dontBlock);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public boolean licenseKeyCheckCompleted(String sessionIdentifier) {
        return this.appRes.getApplicationConfiguration().licenseKeyCheckCompleted();
    }

    public LicenseDescriptor getLicense(String sessionIdentifier) throws GeneralizedException, NoSessionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.appRes.getApplicationConfiguration().getLicense();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setLogServerProtocol(String sessionIdentifier, String protocol) throws GeneralizedException, NoSessionException, InsufficientPermissionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        try {
            this.appRes.getApplicationConfiguration().setLogServerProtocol(protocol);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public String getLogServerProtocol(String sessionIdentifier) throws GeneralizedException, NoSessionException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.appRes.getApplicationConfiguration().getLogServerProtocol();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public boolean isLogServerEnabled(String sessionIdentifier) throws GeneralizedException, NoSessionException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.appRes.getApplicationConfiguration().getLogServerEnabled();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setLogServerEnabled(String sessionIdentifier, boolean enable) throws GeneralizedException, NoSessionException, InsufficientPermissionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        try {
            this.appRes.getApplicationConfiguration().setLogServerEnabled(enable);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean getAutoDefinitionUpdating(String sessionIdentifier) throws GeneralizedException, NoSessionException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.appRes.getApplicationConfiguration().getAutoDefinitionUpdating();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setAutoDefinitionUpdating(String sessionIdentifier, boolean enable) throws GeneralizedException, NoSessionException, InsufficientPermissionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        try {
            this.appRes.getApplicationConfiguration().setAutoDefinitionUpdating(enable);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public EmailAddress getEmailFromAddress(String sessionIdentifier) throws GeneralizedException, NoSessionException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.appRes.getApplicationConfiguration().getEmailFromAddress();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
        catch (UnknownHostException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            return null;
        }
        catch (InvalidLocalPartException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            return null;
        }
    }

    public void setEmailFromAddress(String sessionIdentifier, EmailAddress emailAddress) throws GeneralizedException, NoSessionException, InsufficientPermissionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        try {
            this.appRes.getApplicationConfiguration().setEmailFromAddress(emailAddress);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public String getEmailPassword(String sessionIdentifier) throws GeneralizedException, NoSessionException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.appRes.getApplicationConfiguration().getEmailPassword();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setEmailPassword(String sessionIdentifier, String password) throws GeneralizedException, NoSessionException, InsufficientPermissionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        try {
            this.appRes.getApplicationConfiguration().setEmailPassword(password);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public String getEmailSMTPServer(String sessionIdentifier) throws GeneralizedException, NoSessionException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.appRes.getApplicationConfiguration().getEmailSMTPServer();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setEmailSMTPServer(String sessionIdentifier, String smtpServer) throws GeneralizedException, NoSessionException, InsufficientPermissionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        try {
            this.appRes.getApplicationConfiguration().setEmailSMTPServer(smtpServer);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public String getEmailUsername(String sessionIdentifier) throws GeneralizedException, NoSessionException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.appRes.getApplicationConfiguration().getEmailUsername();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setEmailUsername(String sessionIdentifier, String username) throws GeneralizedException, NoSessionException, InsufficientPermissionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        try {
            this.appRes.getApplicationConfiguration().setEmailUsername(username);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public int getEmailSMTPPort(String sessionIdentifier) throws GeneralizedException, NoSessionException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.appRes.getApplicationConfiguration().getEmailSMTPPort();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            throw new GeneralizedException();
        }
    }

    public void setEmailSMTPPort(String sessionIdentifier, int port) throws GeneralizedException, NoSessionException, InsufficientPermissionException, InputValidationException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        try {
            this.appRes.getApplicationConfiguration().setEmailSMTPPort(port);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }
}

